/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.io.IOException;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.HttpUpgradeConnectionProviderFactory;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.XnioWorker;

public class EndpointService
implements Service<Endpoint> {
    protected final String endpointName;
    protected Endpoint endpoint;
    protected final OptionMap optionMap;
    private final InjectedValue<XnioWorker> worker = new InjectedValue();

    public EndpointService(String nodeName, EndpointType type, OptionMap optionMap) {
        if (nodeName == null) {
            nodeName = "remote";
        }
        this.endpointName = type == EndpointType.SUBSYSTEM ? nodeName : nodeName + ":" + (Object)((Object)type);
        this.optionMap = optionMap;
    }

    InjectedValue<XnioWorker> getWorker() {
        return this.worker;
    }

    protected Endpoint createEndpoint() throws IOException {
        return Remoting.createEndpoint((String)this.endpointName, (XnioWorker)((XnioWorker)this.worker.getValue()), (OptionMap)this.optionMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        Endpoint endpoint;
        try {
            boolean ok = false;
            endpoint = this.createEndpoint();
            try {
                endpoint.addConnectionProvider(Protocol.REMOTE.toString(), (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), this.optionMap);
                endpoint.addConnectionProvider(Protocol.HTTP_REMOTING.toString(), (ConnectionProviderFactory)new HttpUpgradeConnectionProviderFactory(), this.optionMap);
                endpoint.addConnectionProvider(Protocol.HTTPS_REMOTING.toString(), (ConnectionProviderFactory)new HttpUpgradeConnectionProviderFactory(), OptionMap.builder().set(Options.SSL_ENABLED, true).addAll(this.optionMap).getMap());
                ok = true;
            }
            finally {
                if (!ok) {
                    endpoint.closeAsync();
                }
            }
        }
        catch (IOException e) {
            throw RemotingLogger.ROOT_LOGGER.couldNotStart(e);
        }
        this.endpoint = endpoint;
    }

    public synchronized void stop(StopContext context) {
        context.asynchronous();
        try {
            this.endpoint.closeAsync();
        }
        catch (Throwable throwable) {
            this.endpoint.addCloseHandler((CloseHandler)new CloseHandler<Endpoint>(context){
                final /* synthetic */ StopContext val$context;
                {
                    this.val$context = stopContext;
                }

                public void handleClose(Endpoint closed, IOException exception) {
                    this.val$context.complete();
                }
            });
            throw throwable;
        }
        this.endpoint.addCloseHandler((CloseHandler)new /* invalid duplicate definition of identical inner class */);
    }

    public synchronized Endpoint getValue() throws IllegalStateException {
        Endpoint endpoint = this.endpoint;
        if (endpoint == null) {
            throw RemotingLogger.ROOT_LOGGER.endpointEmpty();
        }
        return endpoint;
    }

    public static enum EndpointType {
        MANAGEMENT,
        SUBSYSTEM;

    }
}

