/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.embedded.netty4;

import io.netty.handler.ssl.ClientAuth;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseFilter;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestCacheManager;
import org.infinispan.rest.Server;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.embedded.netty4.NettyJaxrsServer;
import org.infinispan.rest.embedded.netty4.SecurityActions;
import org.infinispan.rest.embedded.netty4.SniConfiguration;
import org.infinispan.rest.embedded.netty4.security.Authenticator;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.logging.RestAccessLoggingHandler;
import org.infinispan.server.core.AbstractCacheIgnoreAware;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.core.configuration.SslEngineConfiguration;
import org.infinispan.server.core.utils.SslUtils;
import org.jboss.resteasy.spi.ResteasyDeployment;

public final class NettyRestServer
extends AbstractCacheIgnoreAware
implements Lifecycle {
    private static final Log log = (Log)LogFactory.getLog(NettyRestServer.class, Log.class);
    private static final String DEFAULT_REST_PATH = "rest";
    private final EmbeddedCacheManager cacheManager;
    private final RestServerConfiguration configuration;
    private final Authenticator authenticator;
    private NettyJaxrsServer netty;
    private Server server;

    private NettyRestServer(EmbeddedCacheManager cacheManager, RestServerConfiguration configuration, Authenticator authenticator) {
        this.cacheManager = cacheManager;
        this.configuration = configuration;
        this.authenticator = authenticator;
    }

    public static NettyRestServer createServer(RestServerConfiguration configuration, EmbeddedCacheManager manager) {
        return new NettyRestServer(manager, configuration, null);
    }

    public static NettyRestServer createServer(RestServerConfiguration configuration, EmbeddedCacheManager manager, Authenticator authenticator) {
        return new NettyRestServer(manager, configuration, authenticator);
    }

    private static void addEncryption(RestServerConfiguration config, NettyJaxrsServer netty) {
        if (config.ssl() != null && config.ssl().enabled()) {
            SslConfiguration sslConfig = config.ssl();
            ClientAuth clientAuth = sslConfig.requireClientAuth() ? ClientAuth.OPTIONAL : ClientAuth.NONE;
            SniConfiguration nettySniConfiguration = new SniConfiguration(SslUtils.createJdkSslContext((SslConfiguration)sslConfig, (SslEngineConfiguration)((SslEngineConfiguration)sslConfig.sniDomainsConfiguration().get("*"))), clientAuth);
            sslConfig.sniDomainsConfiguration().forEach((domainName, domainConfiguration) -> nettySniConfiguration.addSniMapping((String)domainName, SslUtils.createJdkSslContext((SslConfiguration)sslConfig, (SslEngineConfiguration)domainConfiguration)));
            netty.setSSLContext(sslConfig.sslContext());
            netty.setSniConfiguration(nettySniConfiguration);
            netty.setClientAuth(clientAuth);
        }
    }

    private static void startCaches(EmbeddedCacheManager cm) {
        cm.getCacheNames().forEach(name -> SecurityActions.getCache(cm, name));
        cm.getCache();
    }

    private static EmbeddedCacheManager createCacheManager(String cfgFile) {
        try {
            return new DefaultCacheManager(cfgFile);
        }
        catch (IOException e) {
            log.errorReadingConfigurationFile(e, cfgFile);
            return new DefaultCacheManager();
        }
    }

    public void start() {
        this.configuration.ignoredCaches().forEach(arg_0 -> ((NettyRestServer)this).ignoreCache(arg_0));
        RestCacheManager restCacheManager = new RestCacheManager(this.cacheManager, arg_0 -> ((NettyRestServer)this).isCacheIgnored(arg_0));
        this.server = new Server(this.configuration, restCacheManager);
        if (this.configuration.startTransport()) {
            NettyJaxrsServer nettyServer = this.createNetty();
            NettyRestServer.addEncryption(this.configuration, nettyServer);
            nettyServer.start();
            ResteasyDeployment deployment = nettyServer.getDeployment();
            deployment.getRegistry().addSingletonResource((Object)this.server, DEFAULT_REST_PATH);
            deployment.getProviderFactory().register((Object)new RestAccessLoggingHandler(), new Class[]{ContainerRequestFilter.class, ContainerResponseFilter.class});
            log.startRestServer(this.configuration.host(), this.configuration.port());
            this.netty = nettyServer;
        }
    }

    private NettyJaxrsServer createNetty() {
        NettyRestServer.startCaches(this.cacheManager);
        NettyJaxrsServer netty = new NettyJaxrsServer();
        ResteasyDeployment deployment = new ResteasyDeployment();
        netty.setDeployment(deployment);
        netty.setHostname(this.configuration.host());
        netty.setPort(this.configuration.port());
        netty.setRootResourcePath("");
        if (this.authenticator != null) {
            netty.setAuthenticator(this.authenticator);
        }
        return netty;
    }

    public void stop() {
        if (this.netty != null) {
            this.netty.stop();
        }
        this.netty = null;
        this.server = null;
    }

    public Server getServer() {
        return this.server;
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }
}

