/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.bridge.util.impl.ToStringNullMarker;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.nulls.codec.impl.LuceneStringNullMarkerCodec;
import org.hibernate.search.engine.nulls.codec.impl.NullMarkerCodec;
import org.infinispan.protostream.MessageContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.JavaType;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;

final class IndexingTagHandler
implements TagHandler {
    private static final NullMarkerCodec NULL_TOKEN_CODEC = new LuceneStringNullMarkerCodec((NullMarker)new ToStringNullMarker((Object)"_null_"));
    private static final LuceneOptions NOT_STORED_NOT_ANALYZED = new LuceneOptionsImpl(new DocumentFieldMetadata.Builder(new BackReference(), new BackReference(), null, Store.NO, Field.Index.NOT_ANALYZED, Field.TermVector.NO).indexNullAs(NULL_TOKEN_CODEC).boost(Float.valueOf(1.0f)).build(), 1.0f, 1.0f);
    private static final LuceneOptions STORED_NOT_ANALYZED = new LuceneOptionsImpl(new DocumentFieldMetadata.Builder(new BackReference(), new BackReference(), null, Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO).indexNullAs(NULL_TOKEN_CODEC).boost(Float.valueOf(1.0f)).build(), 1.0f, 1.0f);
    private final Document document;
    private MessageContext<? extends MessageContext> messageContext;

    public IndexingTagHandler(Descriptor messageDescriptor, Document document) {
        this.document = document;
        this.messageContext = new MessageContext(null, null, messageDescriptor);
    }

    public void onStart() {
        NOT_STORED_NOT_ANALYZED.addFieldToDocument("$type$", this.messageContext.getMessageDescriptor().getFullName(), this.document);
    }

    public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
        this.messageContext.markField(fieldNumber);
        if (fieldDescriptor != null) {
            FieldMapping fieldMapping;
            IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageContext.getMessageDescriptor().getProcessedAnnotation("Indexed");
            FieldMapping fieldMapping2 = fieldMapping = indexingMetadata != null ? indexingMetadata.getFieldMapping(fieldDescriptor.getName()) : null;
            if (indexingMetadata == null || fieldMapping != null && fieldMapping.index()) {
                this.addFieldToDocument(fieldDescriptor.getName(), fieldDescriptor.getType(), tagValue, fieldMapping);
            }
        }
    }

    private void addFieldToDocument(String fieldName, Type type, Object value, FieldMapping fieldMapping) {
        LuceneOptions luceneOptions;
        boolean isSortable = false;
        if (fieldMapping == null) {
            if (value == null) {
                value = "_null_";
                type = Type.STRING;
                luceneOptions = NOT_STORED_NOT_ANALYZED;
            } else {
                luceneOptions = STORED_NOT_ANALYZED;
            }
        } else {
            luceneOptions = fieldMapping.luceneOptions();
            isSortable = fieldMapping.sortable();
            if (value == null) {
                if (fieldMapping.analyze() || fieldMapping.indexNullAs().equals("__DO_NOT_INDEX_NULL__")) {
                    return;
                }
                switch (type) {
                    case STRING: {
                        value = fieldMapping.indexNullAs();
                        break;
                    }
                    case DOUBLE: {
                        value = Double.parseDouble(fieldMapping.indexNullAs());
                        break;
                    }
                    case FLOAT: {
                        value = Float.valueOf(Float.parseFloat(fieldMapping.indexNullAs()));
                        break;
                    }
                    case INT64: 
                    case UINT64: 
                    case FIXED64: 
                    case SFIXED64: 
                    case SINT64: {
                        value = Long.parseLong(fieldMapping.indexNullAs());
                        break;
                    }
                    case INT32: 
                    case FIXED32: 
                    case UINT32: 
                    case SFIXED32: 
                    case SINT32: {
                        value = Integer.parseInt(fieldMapping.indexNullAs());
                        break;
                    }
                    case ENUM: {
                        FieldDescriptor fd = this.messageContext.getMessageDescriptor().findFieldByName(fieldName);
                        EnumValueDescriptor enumVal = fd.getEnumType().findValueByName(fieldMapping.indexNullAs());
                        if (enumVal == null) {
                            throw new IllegalArgumentException("Enum value not found :" + fieldMapping.indexNullAs());
                        }
                        value = enumVal.getNumber();
                        break;
                    }
                    case BOOL: {
                        value = Boolean.valueOf(fieldMapping.indexNullAs());
                    }
                }
            }
        }
        String fullFieldName = this.messageContext.getFullFieldName();
        fullFieldName = fullFieldName != null ? fullFieldName + "." + fieldName : fieldName;
        switch (type) {
            case DOUBLE: {
                if (isSortable) {
                    this.document.add((IndexableField)new NumericDocValuesField(fieldName, Double.doubleToRawLongBits(((Number)value).doubleValue())));
                }
                luceneOptions.addNumericFieldToDocument(fullFieldName, value, this.document);
                break;
            }
            case FLOAT: {
                if (isSortable) {
                    this.document.add((IndexableField)new NumericDocValuesField(fieldName, (long)Float.floatToRawIntBits(((Number)value).floatValue())));
                }
                luceneOptions.addNumericFieldToDocument(fullFieldName, value, this.document);
                break;
            }
            case INT64: 
            case UINT64: 
            case FIXED64: 
            case SFIXED64: 
            case SINT64: 
            case INT32: 
            case FIXED32: 
            case UINT32: 
            case SFIXED32: 
            case SINT32: 
            case ENUM: {
                if (isSortable) {
                    this.document.add((IndexableField)new NumericDocValuesField(fieldName, ((Number)value).longValue()));
                }
                luceneOptions.addNumericFieldToDocument(fullFieldName, value, this.document);
                break;
            }
            case BOOL: {
                String indexedBoolean = value.toString();
                if (isSortable) {
                    luceneOptions.addSortedDocValuesFieldToDocument(fullFieldName, indexedBoolean, this.document);
                }
                luceneOptions.addFieldToDocument(fullFieldName, indexedBoolean, this.document);
                break;
            }
            default: {
                String indexedString = String.valueOf(value);
                if (isSortable) {
                    luceneOptions.addSortedDocValuesFieldToDocument(fullFieldName, indexedString, this.document);
                }
                luceneOptions.addFieldToDocument(fullFieldName, indexedString, this.document);
            }
        }
    }

    public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        this.messageContext.markField(fieldNumber);
        this.pushContext(fieldDescriptor.getName(), fieldDescriptor.getMessageType());
    }

    public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
        this.popContext();
    }

    public void onEnd() {
        this.indexMissingFields();
    }

    private void pushContext(String fieldName, Descriptor messageDescriptor) {
        this.messageContext = new MessageContext(this.messageContext, fieldName, messageDescriptor);
    }

    private void popContext() {
        this.indexMissingFields();
        this.messageContext = this.messageContext.getParentContext();
    }

    private void indexMissingFields() {
        for (FieldDescriptor fd : this.messageContext.getMessageDescriptor().getFields()) {
            FieldMapping fieldMapping;
            if (this.messageContext.isFieldMarked(fd.getNumber())) continue;
            Object defaultValue = fd.getJavaType() == JavaType.MESSAGE || fd.hasDefaultValue() ? fd.getDefaultValue() : null;
            IndexingMetadata indexingMetadata = (IndexingMetadata)this.messageContext.getMessageDescriptor().getProcessedAnnotation("Indexed");
            FieldMapping fieldMapping2 = fieldMapping = indexingMetadata != null ? indexingMetadata.getFieldMapping(fd.getName()) : null;
            if (indexingMetadata != null && (fieldMapping == null || !fieldMapping.index())) continue;
            this.addFieldToDocument(fd.getName(), fd.getType(), defaultValue, fieldMapping);
        }
    }
}

