/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import org.apache.lucene.document.CompressionTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.StringHelper;

public class LuceneOptionsImpl
implements LuceneOptions {
    private static final FieldType TYPE_COMPRESSED = new FieldType();
    private final boolean storeCompressed;
    private final boolean storeUncompressed;
    private boolean documentBoostApplied = false;
    private final float fieldLevelBoost;
    private final float inheritedBoost;
    private final Field.Index indexMode;
    private final Field.TermVector termVector;
    private final Store storeType;
    private final String indexNullAs;

    public LuceneOptionsImpl(DocumentFieldMetadata fieldMetadata, float fieldLevelBoost, float inheritedBoost) {
        this.inheritedBoost = inheritedBoost;
        this.indexMode = fieldMetadata.getIndex();
        this.termVector = fieldMetadata.getTermVector();
        this.fieldLevelBoost = fieldLevelBoost;
        this.storeType = fieldMetadata.getStore();
        this.storeCompressed = this.storeType.equals((Object)Store.COMPRESS);
        this.storeUncompressed = this.storeType.equals((Object)Store.YES);
        NullMarker nullMarker = fieldMetadata.getNullMarkerCodec().getNullMarker();
        this.indexNullAs = nullMarker == null ? null : nullMarker.nullRepresentedAsString();
    }

    public LuceneOptionsImpl(Field.Index indexMode, Field.TermVector termVector, Store store, String indexNullAs, float fieldLevelBoost, float inheritedBoost) {
        this.inheritedBoost = inheritedBoost;
        this.indexMode = indexMode;
        this.termVector = termVector;
        this.fieldLevelBoost = fieldLevelBoost;
        this.storeType = store;
        this.storeCompressed = this.storeType.equals((Object)Store.COMPRESS);
        this.storeUncompressed = this.storeType.equals((Object)Store.YES);
        this.indexNullAs = indexNullAs;
    }

    @Override
    public void addFieldToDocument(String name, String indexedString, Document document) {
        if (StringHelper.isNotEmpty(indexedString)) {
            if (!this.indexMode.equals((Object)Field.Index.NO) || !this.storeCompressed) {
                this.standardFieldAdd(name, indexedString, document);
            }
            if (this.storeCompressed) {
                this.compressedFieldAdd(name, indexedString, document);
            }
        }
    }

    private void standardFieldAdd(String name, String indexedString, Document document) {
        if (this.storeType == Store.NO && this.indexMode == Field.Index.NO) {
            return;
        }
        Field field = new Field(name, indexedString, this.storeUncompressed ? Field.Store.YES : Field.Store.NO, this.indexMode, this.termVector);
        this.setBoost(field);
        document.add((IndexableField)field);
    }

    private void compressedFieldAdd(String name, String indexedString, Document document) {
        if (this.storeType == Store.NO && this.indexMode == Field.Index.NO) {
            return;
        }
        byte[] compressedString = CompressionTools.compressString((String)indexedString);
        Field field = new Field(name, compressedString, TYPE_COMPRESSED);
        document.add((IndexableField)field);
    }

    @Override
    public float getBoost() {
        return this.fieldLevelBoost;
    }

    @Override
    public String indexNullAs() {
        return this.indexNullAs;
    }

    @Override
    public boolean isCompressed() {
        return this.storeCompressed;
    }

    @Override
    public Field.Index getIndex() {
        return this.indexMode;
    }

    @Override
    public Field.Store getStore() {
        if (this.storeUncompressed || this.storeCompressed) {
            return Field.Store.YES;
        }
        return Field.Store.NO;
    }

    @Override
    public Field.TermVector getTermVector() {
        return this.termVector;
    }

    private void setBoost(Field field) {
        if (this.indexMode.isIndexed() && !this.indexMode.omitNorms()) {
            if (!this.documentBoostApplied) {
                this.documentBoostApplied = true;
                field.setBoost(this.fieldLevelBoost * this.inheritedBoost);
            } else {
                field.setBoost(this.fieldLevelBoost);
            }
        }
    }

    private void checkNotCompressed(String fieldName) {
        if (this.storeType == Store.COMPRESS) {
            throw new SearchException("Error indexing field " + fieldName + ", @NumericField cannot be compressed");
        }
    }

    public void addDoubleFieldToDocument(String fieldName, double doubleValue, Document document) {
        this.checkNotCompressed(fieldName);
        DoubleField field = new DoubleField(fieldName, doubleValue, this.storeType != Store.NO ? Field.Store.YES : Field.Store.NO);
        this.setBoost((Field)field);
        document.add((IndexableField)field);
    }

    public void addFloatFieldToDocument(String fieldName, float floatValue, Document document) {
        this.checkNotCompressed(fieldName);
        FloatField field = new FloatField(fieldName, floatValue, this.storeType != Store.NO ? Field.Store.YES : Field.Store.NO);
        this.setBoost((Field)field);
        document.add((IndexableField)field);
    }

    public void addIntFieldToDocument(String fieldName, int intValue, Document document) {
        this.checkNotCompressed(fieldName);
        IntField field = new IntField(fieldName, intValue, this.storeType != Store.NO ? Field.Store.YES : Field.Store.NO);
        this.setBoost((Field)field);
        document.add((IndexableField)field);
    }

    public void addLongFieldToDocument(String fieldName, long longValue, Document document) {
        this.checkNotCompressed(fieldName);
        LongField field = new LongField(fieldName, longValue, this.storeType != Store.NO ? Field.Store.YES : Field.Store.NO);
        this.setBoost((Field)field);
        document.add((IndexableField)field);
    }

    @Override
    public void addNumericFieldToDocument(String fieldName, Object indexedValue, Document document) {
        if (indexedValue == null) {
            throw new IllegalArgumentException("the indexedValue parameter shall not be null");
        }
        if (indexedValue instanceof Double) {
            this.addDoubleFieldToDocument(fieldName, (Double)indexedValue, document);
        } else if (indexedValue instanceof Float) {
            this.addFloatFieldToDocument(fieldName, ((Float)indexedValue).floatValue(), document);
        } else if (indexedValue instanceof Integer) {
            this.addIntFieldToDocument(fieldName, (Integer)indexedValue, document);
        } else if (indexedValue instanceof Long) {
            this.addLongFieldToDocument(fieldName, (Long)indexedValue, document);
        } else {
            throw new IllegalArgumentException("unsupported type of Number");
        }
    }

    @Override
    public void addSortedDocValuesFieldToDocument(String fieldName, String indexedString, Document document) {
        if (indexedString != null) {
            document.add((IndexableField)new SortedDocValuesField(fieldName, new BytesRef((CharSequence)indexedString)));
        }
    }

    @Override
    public void addNumericDocValuesFieldToDocument(String fieldName, Number numericValue, Document document) {
        if (numericValue == null) {
            throw new IllegalArgumentException("the numericValue parameter shall not be null");
        }
        if (numericValue instanceof Double) {
            document.add((IndexableField)new DoubleDocValuesField(fieldName, ((Double)numericValue).doubleValue()));
        } else if (numericValue instanceof Float) {
            document.add((IndexableField)new FloatDocValuesField(fieldName, ((Float)numericValue).floatValue()));
        } else if (numericValue instanceof Integer) {
            document.add((IndexableField)new NumericDocValuesField(fieldName, ((Integer)numericValue).longValue()));
        } else if (numericValue instanceof Long) {
            document.add((IndexableField)new NumericDocValuesField(fieldName, ((Long)numericValue).longValue()));
        } else {
            throw new IllegalArgumentException("unsupported type of Number");
        }
    }

    static {
        TYPE_COMPRESSED.setTokenized(false);
        TYPE_COMPRESSED.setOmitNorms(true);
        TYPE_COMPRESSED.setIndexOptions(IndexOptions.NONE);
        TYPE_COMPRESSED.setStored(true);
        TYPE_COMPRESSED.freeze();
    }
}

