/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Util;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.persistence.remote.upgrade.HotRodMigratorHelper;
import org.infinispan.persistence.remote.upgrade.MigrationMarshaller;
import org.infinispan.persistence.remote.upgrade.MigrationTask;
import org.infinispan.remoting.transport.Address;
import org.infinispan.upgrade.TargetMigrator;
import org.infinispan.util.logging.LogFactory;

public class HotRodTargetMigrator
implements TargetMigrator {
    private static final Log log = (Log)LogFactory.getLog(HotRodTargetMigrator.class, Log.class);

    public String getName() {
        return "hotrod";
    }

    public long synchronizeData(Cache<Object, Object> cache) throws CacheException {
        return this.synchronizeData(cache, 10000, Runtime.getRuntime().availableProcessors());
    }

    public long synchronizeData(Cache<Object, Object> cache, int readBatch, int threads) throws CacheException {
        byte[] knownKeys;
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        PersistenceManager loaderManager = (PersistenceManager)cr.getComponent(PersistenceManager.class);
        Set stores = loaderManager.getStores(RemoteStore.class);
        MigrationMarshaller marshaller = new MigrationMarshaller();
        try {
            knownKeys = marshaller.objectToByteBuffer("___MigrationManager_HotRod_KnownKeys___");
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
        Iterator iterator = stores.iterator();
        if (iterator.hasNext()) {
            RemoteStore store = (RemoteStore)iterator.next();
            RemoteCache<Object, Object> storeCache = store.getRemoteCache();
            if (!HotRodMigratorHelper.supportsIteration(store.getConfiguration().protocolVersion())) {
                if (storeCache.containsKey((Object)knownKeys)) {
                    Set keys;
                    RemoteStoreConfiguration storeConfig = store.getConfiguration();
                    if (!storeConfig.hotRodWrapping()) {
                        throw log.remoteStoreNoHotRodWrapping(cache.getName());
                    }
                    try {
                        keys = (Set)marshaller.objectFromByteBuffer((byte[])storeCache.get((Object)knownKeys));
                    }
                    catch (Exception e) {
                        throw new CacheException((Throwable)e);
                    }
                    ExecutorService es = Executors.newFixedThreadPool(threads);
                    AtomicInteger count = new AtomicInteger(0);
                    for (Object okey : keys) {
                        byte[] key = (byte[])okey;
                        es.submit(() -> {
                            try {
                                cache.get((Object)key);
                                int i = count.getAndIncrement();
                                if (log.isDebugEnabled() && i % 100 == 0) {
                                    log.debugf(">>    Moved %s keys\n", i);
                                }
                            }
                            catch (Exception e) {
                                log.keyMigrationFailed(Util.toStr((Object)key), e);
                            }
                        });
                    }
                    HotRodMigratorHelper.gracefulShutdown(es);
                    return count.longValue();
                }
                throw log.missingMigrationData(cache.getName());
            }
            CacheTopologyInfo cacheTopologyInfo = storeCache.getCacheTopologyInfo();
            Map remoteServers = cacheTopologyInfo.getSegmentsPerServer();
            if (remoteServers.size() == 1) {
                AtomicInteger count = new AtomicInteger(0);
                ExecutorService es = Executors.newFixedThreadPool(threads);
                HotRodMigratorHelper.migrateEntriesWithMetadata(storeCache, cache, es, knownKeys, count, null, readBatch);
                HotRodMigratorHelper.gracefulShutdown(es);
                return count.get();
            }
            int numSegments = cacheTopologyInfo.getNumSegments();
            List servers = cache.getAdvancedCache().getDistributionManager().getWriteConsistentHash().getMembers();
            List<List<Integer>> partitions = HotRodMigratorHelper.split(HotRodMigratorHelper.range(numSegments), servers.size());
            DefaultExecutorService executor = new DefaultExecutorService(cache);
            Iterator iterator2 = servers.iterator();
            ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(servers.size());
            for (List<Integer> partition : partitions) {
                HashSet<Integer> segmentSet = new HashSet<Integer>();
                segmentSet.addAll(partition);
                futures.add(executor.submit((Address)iterator2.next(), (Callable)((Object)new MigrationTask(segmentSet, readBatch, threads))));
            }
            return futures.stream().mapToInt(f -> {
                try {
                    return (Integer)f.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw log.couldNotMigrateData(cache.getName());
                }
                catch (ExecutionException e) {
                    throw new CacheException((Throwable)e);
                }
            }).sum();
        }
        throw log.couldNotMigrateData(cache.getName());
    }

    public void disconnectSource(Cache<Object, Object> cache) throws CacheException {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        PersistenceManager loaderManager = (PersistenceManager)cr.getComponent(PersistenceManager.class);
        loaderManager.disableStore(RemoteStore.class.getName());
    }
}

