/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.versioning;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import net.jcip.annotations.Immutable;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.container.versioning.InequalVersionComparisonResult;

@Immutable
public class SimpleClusteredVersion
implements IncrementableEntryVersion {
    private final int topologyId;
    final long version;

    public SimpleClusteredVersion(int topologyId, long version) {
        this.version = version;
        this.topologyId = topologyId;
    }

    @Override
    public InequalVersionComparisonResult compareTo(EntryVersion other) {
        if (other instanceof SimpleClusteredVersion) {
            SimpleClusteredVersion otherVersion = (SimpleClusteredVersion)other;
            if (this.topologyId > otherVersion.topologyId) {
                return InequalVersionComparisonResult.AFTER;
            }
            if (this.topologyId < otherVersion.topologyId) {
                return InequalVersionComparisonResult.BEFORE;
            }
            if (this.version > otherVersion.version) {
                return InequalVersionComparisonResult.AFTER;
            }
            if (this.version < otherVersion.version) {
                return InequalVersionComparisonResult.BEFORE;
            }
            return InequalVersionComparisonResult.EQUAL;
        }
        throw new IllegalArgumentException("I only know how to deal with SimpleClusteredVersions, not " + other.getClass().getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleClusteredVersion that = (SimpleClusteredVersion)o;
        if (this.topologyId != that.topologyId) {
            return false;
        }
        return this.version == that.version;
    }

    public int hashCode() {
        int result = this.topologyId;
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        return result;
    }

    public String toString() {
        return "SimpleClusteredVersion{topologyId=" + this.topologyId + ", version=" + this.version + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<SimpleClusteredVersion> {
        public void writeObject(ObjectOutput output, SimpleClusteredVersion ch) throws IOException {
            output.writeInt(ch.topologyId);
            output.writeLong(ch.version);
        }

        public SimpleClusteredVersion readObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            int topologyId = unmarshaller.readInt();
            long version = unmarshaller.readLong();
            return new SimpleClusteredVersion(topologyId, version);
        }

        public Integer getId() {
            return 55;
        }

        public Set<Class<? extends SimpleClusteredVersion>> getTypeClasses() {
            return Collections.singleton(SimpleClusteredVersion.class);
        }
    }
}

