/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.remoting.inboundhandler.NonTotalOrderPerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.NonTotalOrderTxPerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.TotalOrderTxPerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.TrianglePerCacheInboundInvocationHandler;

@DefaultFactoryFor(classes={PerCacheInboundInvocationHandler.class})
public class InboundInvocationHandlerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public <T> T construct(Class<T> componentType) {
        if (!this.configuration.clustering().cacheMode().isClustered()) {
            return null;
        }
        if (this.configuration.transaction().transactionMode().isTransactional()) {
            return this.configuration.transaction().transactionProtocol().isTotalOrder() ? componentType.cast(new TotalOrderTxPerCacheInboundInvocationHandler()) : componentType.cast(new NonTotalOrderTxPerCacheInboundInvocationHandler());
        }
        return this.configuration.clustering().cacheMode().isDistributed() ? componentType.cast(new TrianglePerCacheInboundInvocationHandler()) : componentType.cast(new NonTotalOrderPerCacheInboundInvocationHandler());
    }
}

