/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.read.GetCacheEntryCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.BackupPutMapRcpCommand;
import org.infinispan.commands.write.BackupWriteRcpCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.TriangleOrderManager;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.Collector;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.WriteResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.OutdatedTopologyException;
import org.infinispan.util.concurrent.CommandAckCollector;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TriangleDistributionInterceptor
extends NonTxDistributionInterceptor {
    private static final Log log = LogFactory.getLog(TriangleDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private CommandAckCollector commandAckCollector;
    private CommandsFactory commandsFactory;
    private TriangleOrderManager triangleOrderManager;
    private Address localAddress;

    private static Map<Object, Object> mergeMaps(Map<Address, Response> responses, Map<Object, Object> resultMap) {
        Map remoteMap = (Map)((SuccessfulResponse)responses.values().iterator().next()).getResponseValue();
        return InfinispanCollections.mergeMaps(resultMap, (Map)remoteMap);
    }

    @Inject
    public void inject(CommandAckCollector commandAckCollector, CommandsFactory commandsFactory, TriangleOrderManager triangleOrderManager) {
        this.commandAckCollector = commandAckCollector;
        this.commandsFactory = commandsFactory;
        this.triangleOrderManager = triangleOrderManager;
    }

    @Start
    public void start() {
        this.localAddress = this.rpcManager.getAddress();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            return this.handleLocalPutMapCommand(ctx, command);
        }
        return this.handleRemotePutMapCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleDataWriteCommand(ctx, command);
    }

    private Object handleRemotePutMapCommand(InvocationContext ctx, PutMapCommand command) {
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        ConsistentHash ch = cacheTopology.getWriteConsistentHash();
        VisitableCommand.LoadType loadType = command.loadType();
        if (command.isForwarded() || ch.getNumOwners() == 1) {
            return this.asyncInvokeNext(ctx, command, this.checkRemoteGetIfNeeded(ctx, command, command.getMap().keySet(), cacheTopology, loadType == VisitableCommand.LoadType.OWNER));
        }
        this.sendToBackups(command, command.getMap(), cacheTopology);
        return this.asyncInvokeNext(ctx, command, this.checkRemoteGetIfNeeded(ctx, command, command.getMap().keySet(), cacheTopology, loadType == VisitableCommand.LoadType.OWNER));
    }

    private void sendToBackups(PutMapCommand command, Map<Object, Object> entries, LocalizedCacheTopology cacheTopology) {
        BackupOwnerClassifier filter = new BackupOwnerClassifier(cacheTopology, entries.size());
        entries.entrySet().forEach(filter::add);
        int topologyId = command.getTopologyId();
        for (Map.Entry entry : filter.perSegmentKeyValue.entrySet()) {
            int segmentId = (Integer)entry.getKey();
            Collection<Address> backups = cacheTopology.getDistributionForSegment(segmentId).writeBackups();
            if (backups.isEmpty()) continue;
            Map map = (Map)entry.getValue();
            long sequence = this.triangleOrderManager.next(segmentId, topologyId);
            BackupPutMapRcpCommand backupPutMapRcpCommand = this.commandsFactory.buildBackupPutMapRcpCommand(command);
            backupPutMapRcpCommand.setMap(map);
            backupPutMapRcpCommand.setSequence(sequence);
            if (trace) {
                log.tracef("Command %s got sequence %s for segment %s", command.getCommandInvocationId(), segmentId, sequence);
            }
            this.rpcManager.sendToMany(backups, backupPutMapRcpCommand, DeliverOrder.NONE);
        }
    }

    private Object handleLocalPutMapCommand(InvocationContext ctx, PutMapCommand command) {
        LocalizedCacheTopology cacheTopology = this.checkTopologyId(command);
        PrimaryOwnerClassifier filter = new PrimaryOwnerClassifier(cacheTopology, command.getMap().size());
        boolean sync = this.isSynchronous(command);
        VisitableCommand.LoadType loadType = command.loadType();
        command.getMap().entrySet().forEach(filter::add);
        if (sync) {
            Collector<Map<Object, Object>> collector = this.commandAckCollector.createMultiKeyCollector(command.getCommandInvocationId().getId(), filter.primaries.keySet(), filter.backups, command.getTopologyId());
            CompletableFuture<Map<Object, Object>> localResult = new CompletableFuture<Map<Object, Object>>();
            Map localEntries = (Map)filter.primaries.remove(this.localAddress);
            this.forwardToPrimaryOwners(command, filter, localResult).handle((map, throwable) -> {
                if (throwable != null) {
                    collector.primaryException((Throwable)throwable);
                } else {
                    collector.primaryResult((Map<Object, Object>)map, true);
                }
                return null;
            });
            if (localEntries != null) {
                this.sendToBackups(command, localEntries, cacheTopology);
                CompletableFuture<?> remoteGet = this.checkRemoteGetIfNeeded(ctx, command, localEntries.keySet(), cacheTopology, loadType == VisitableCommand.LoadType.PRIMARY || loadType == VisitableCommand.LoadType.OWNER);
                return TriangleDistributionInterceptor.makeStage(this.asyncInvokeNext(ctx, command, remoteGet)).andHandle(ctx, command, (rCtx, rCommand, rv, throwable) -> {
                    if (throwable != null) {
                        localResult.completeExceptionally(CompletableFutures.extractException(throwable));
                    } else {
                        localResult.complete((Map)rv);
                    }
                    return TriangleDistributionInterceptor.asyncValue(collector.getFuture());
                });
            }
            localResult.complete(new HashMap());
            return TriangleDistributionInterceptor.asyncValue(collector.getFuture());
        }
        Map localEntries = (Map)filter.primaries.remove(this.localAddress);
        this.forwardToPrimaryOwners(command, filter);
        if (localEntries != null) {
            this.sendToBackups(command, localEntries, cacheTopology);
            return this.asyncInvokeNext(ctx, command, this.checkRemoteGetIfNeeded(ctx, command, localEntries.keySet(), cacheTopology, loadType == VisitableCommand.LoadType.PRIMARY || loadType == VisitableCommand.LoadType.OWNER));
        }
        return null;
    }

    private <C extends FlagAffectedCommand & TopologyAffectedCommand> CompletableFuture<?> checkRemoteGetIfNeeded(InvocationContext ctx, C command, Set<Object> keys, LocalizedCacheTopology cacheTopology, boolean needsPreviousValue) {
        if (!needsPreviousValue) {
            for (Object key : keys) {
                CacheEntry cacheEntry = ctx.lookupEntry(key);
                if (cacheEntry != null || !cacheTopology.isWriteOwner(key)) continue;
                this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
            }
            return CompletableFutures.completedNull();
        }
        ArrayList futureList = new ArrayList(keys.size());
        for (Object key : keys) {
            CacheEntry cacheEntry = ctx.lookupEntry(key);
            if (cacheEntry != null || !cacheTopology.isWriteOwner(key)) continue;
            this.wrapKeyExternally(ctx, command, key, futureList);
        }
        int size = futureList.size();
        if (size == 0) {
            return CompletableFutures.completedNull();
        }
        CompletableFuture[] array = new CompletableFuture[size];
        futureList.toArray(array);
        return CompletableFuture.allOf(array);
    }

    private <C extends FlagAffectedCommand & TopologyAffectedCommand> void wrapKeyExternally(InvocationContext ctx, C command, Object key, List<CompletableFuture<?>> futureList) {
        if (command.hasAnyFlag(FlagBitSets.SKIP_REMOTE_LOOKUP | FlagBitSets.CACHE_MODE_LOCAL)) {
            this.entryFactory.wrapExternalEntry(ctx, key, null, false, true);
        } else {
            GetCacheEntryCommand fakeGetCommand = this.cf.buildGetCacheEntryCommand(key, command.getFlagsBitSet());
            fakeGetCommand.setTopologyId(((TopologyAffectedCommand)command).getTopologyId());
            futureList.add(this.remoteGet(ctx, fakeGetCommand, key, true));
        }
    }

    private void forwardToPrimaryOwners(PutMapCommand command, PrimaryOwnerClassifier splitter) {
        for (Map.Entry entry : splitter.primaries.entrySet()) {
            PutMapCommand copy = new PutMapCommand(command, false);
            copy.setMap((Map)entry.getValue());
            this.rpcManager.sendTo((Address)entry.getKey(), copy, DeliverOrder.NONE);
        }
    }

    private CompletableFuture<Map<Object, Object>> forwardToPrimaryOwners(PutMapCommand command, PrimaryOwnerClassifier splitter, CompletableFuture<Map<Object, Object>> localResult) {
        CompletionStage<Map<Object, Object>> future = localResult;
        for (Map.Entry entry : splitter.primaries.entrySet()) {
            PutMapCommand copy = new PutMapCommand(command, false);
            copy.setMap((Map)entry.getValue());
            CompletableFuture<Map<Address, Response>> remoteFuture = this.rpcManager.invokeRemotelyAsync(Collections.singleton(entry.getKey()), copy, this.defaultSyncOptions);
            future = remoteFuture.thenCombine(future, TriangleDistributionInterceptor::mergeMaps);
        }
        return future;
    }

    private Object handleDataWriteCommand(InvocationContext context, AbstractDataWriteCommand command) {
        assert (!context.isInTxScope());
        if (command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            return this.invokeNext(context, command);
        }
        LocalizedCacheTopology topology = this.checkTopologyId(command);
        DistributionInfo distributionInfo = topology.getDistribution(command.getKey());
        if (distributionInfo.isPrimary()) {
            assert (context.lookupEntry(command.getKey()) != null);
            return context.isOriginLocal() ? this.localPrimaryOwnerWrite(context, command, distributionInfo) : this.remotePrimaryOwnerWrite(context, command, distributionInfo);
        }
        if (distributionInfo.isWriteBackup()) {
            return context.isOriginLocal() ? this.localWriteInvocation(context, command, distributionInfo) : this.remoteBackupOwnerWrite(context, command);
        }
        assert (context.isOriginLocal());
        return this.localWriteInvocation(context, command, distributionInfo);
    }

    private Object remoteBackupOwnerWrite(InvocationContext context, DataWriteCommand command) {
        CacheEntry entry = context.lookupEntry(command.getKey());
        if (entry == null) {
            if (command.loadType() == VisitableCommand.LoadType.OWNER) {
                return this.asyncInvokeNext(context, command, this.remoteGet(context, command, command.getKey(), true));
            }
            this.entryFactory.wrapExternalEntry(context, command.getKey(), null, false, true);
        }
        return this.invokeNext(context, command);
    }

    private Object localPrimaryOwnerWrite(InvocationContext context, DataWriteCommand command, DistributionInfo distributionInfo) {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            command.setValueMatcher(command.getValueMatcher().matcherForRetry());
        }
        return this.invokeNextThenApply(context, command, (rCtx, rCommand, rv) -> {
            DataWriteCommand dwCommand = (DataWriteCommand)rCommand;
            CommandInvocationId id = dwCommand.getCommandInvocationId();
            Collection<Address> backupOwners = distributionInfo.writeBackups();
            if (!dwCommand.isSuccessful() || backupOwners.isEmpty()) {
                if (trace) {
                    log.tracef("Command %s not successful in primary owner.", id);
                }
                return rv;
            }
            int topologyId = dwCommand.getTopologyId();
            if (this.isSynchronous(dwCommand) || dwCommand.isReturnValueExpected()) {
                Collector<Object> collector = this.commandAckCollector.create(id.getId(), backupOwners, topologyId);
                this.checkTopologyId(topologyId, collector);
                collector.primaryResult(rv, true);
                this.sendToBackups(distributionInfo, dwCommand, backupOwners);
                return TriangleDistributionInterceptor.asyncValue(collector.getFuture());
            }
            this.sendToBackups(distributionInfo, dwCommand, backupOwners);
            return rv;
        });
    }

    private Object remotePrimaryOwnerWrite(InvocationContext context, DataWriteCommand command, DistributionInfo distributionInfo) {
        if (command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            command.setValueMatcher(command.getValueMatcher().matcherForRetry());
        }
        return this.invokeNextThenApply(context, command, (rCtx, rCommand, rv) -> {
            DataWriteCommand dwCommand = (DataWriteCommand)rCommand;
            CommandInvocationId id = dwCommand.getCommandInvocationId();
            Collection<Address> backupOwners = distributionInfo.writeBackups();
            if (!dwCommand.isSuccessful() || backupOwners.isEmpty()) {
                if (trace) {
                    log.tracef("Command %s not successful in primary owner.", id);
                }
                return rv;
            }
            this.sendToBackups(distributionInfo, dwCommand, backupOwners);
            return rv;
        });
    }

    private void sendToBackups(DistributionInfo distributionInfo, DataWriteCommand command, Collection<Address> backupOwners) {
        CommandInvocationId id = command.getCommandInvocationId();
        int segmentId = distributionInfo.segmentId();
        if (trace) {
            log.tracef("Command %s send to backup owner %s.", id, backupOwners);
        }
        long sequenceNumber = this.triangleOrderManager.next(segmentId, command.getTopologyId());
        BackupWriteRcpCommand backupWriteRcpCommand = this.commandsFactory.buildBackupWriteRcpCommand(command);
        backupWriteRcpCommand.setSequence(sequenceNumber);
        if (trace) {
            log.tracef("Command %s got sequence %s for segment %s", id, sequenceNumber, segmentId);
        }
        this.rpcManager.sendToMany(backupOwners, backupWriteRcpCommand, DeliverOrder.NONE);
    }

    private Object localWriteInvocation(InvocationContext context, DataWriteCommand command, DistributionInfo distributionInfo) {
        assert (context.isOriginLocal());
        CommandInvocationId invocationId = command.getCommandInvocationId();
        if (this.isSynchronous(command) || command.isReturnValueExpected() && !command.hasAnyFlag(FlagBitSets.PUT_FOR_EXTERNAL_READ)) {
            int topologyId = command.getTopologyId();
            Collector<Object> collector = this.commandAckCollector.create(invocationId.getId(), distributionInfo.writeBackups(), topologyId);
            this.checkTopologyId(topologyId, collector);
            this.forwardToPrimary(command, distributionInfo, collector);
            return TriangleDistributionInterceptor.asyncValue(collector.getFuture());
        }
        this.rpcManager.sendTo(distributionInfo.primary(), command, DeliverOrder.NONE);
        return null;
    }

    private void forwardToPrimary(DataWriteCommand command, DistributionInfo distributionInfo, Collector<Object> collector) {
        CompletableFuture<Map<Address, Response>> remoteInvocation = this.rpcManager.invokeRemotelyAsync(Collections.singletonList(distributionInfo.primary()), command, this.defaultSyncOptions);
        remoteInvocation.handle((responses, throwable) -> {
            if (throwable != null) {
                collector.primaryException(CompletableFutures.extractException(throwable));
            } else {
                WriteResponse response = (WriteResponse)responses.values().iterator().next();
                command.updateStatusFromRemoteResponse(response.getReturnValue());
                collector.primaryResult(response.getReturnValue(), response.isCommandSuccessful());
            }
            return null;
        });
    }

    private void checkTopologyId(int topologyId, Collector<?> collector) {
        int currentTopologyId = this.stateTransferManager.getCacheTopology().getTopologyId();
        if (currentTopologyId != topologyId && topologyId != -1) {
            collector.primaryException((Throwable)((Object)OutdatedTopologyException.getCachedInstance()));
            throw OutdatedTopologyException.getCachedInstance();
        }
    }

    private static class BackupOwnerClassifier {
        private final Map<Integer, Map<Object, Object>> perSegmentKeyValue;
        private final LocalizedCacheTopology cacheTopology;
        private final int entryCount;

        private BackupOwnerClassifier(LocalizedCacheTopology cacheTopology, int entryCount) {
            this.cacheTopology = cacheTopology;
            this.perSegmentKeyValue = new HashMap<Integer, Map<Object, Object>>(cacheTopology.getReadConsistentHash().getNumSegments());
            this.entryCount = entryCount;
        }

        public void add(Map.Entry<Object, Object> entry) {
            this.perSegmentKeyValue.computeIfAbsent(this.cacheTopology.getSegment(entry.getKey()), address -> new HashMap(this.entryCount)).put(entry.getKey(), entry.getValue());
        }
    }

    private static class PrimaryOwnerClassifier {
        private final Map<Address, Collection<Integer>> backups;
        private final Map<Address, Map<Object, Object>> primaries;
        private final LocalizedCacheTopology cacheTopology;
        private final int entryCount;

        private PrimaryOwnerClassifier(LocalizedCacheTopology cacheTopology, int entryCount) {
            this.cacheTopology = cacheTopology;
            int memberSize = cacheTopology.getMembers().size();
            this.backups = new HashMap<Address, Collection<Integer>>(memberSize);
            this.primaries = new HashMap<Address, Map<Object, Object>>(memberSize);
            this.entryCount = entryCount;
        }

        public void add(Map.Entry<Object, Object> entry) {
            int segment = this.cacheTopology.getSegment(entry.getKey());
            DistributionInfo distributionInfo = this.cacheTopology.getDistributionForSegment(segment);
            Address primaryOwner = distributionInfo.primary();
            this.primaries.computeIfAbsent(primaryOwner, address -> new HashMap(this.entryCount)).put(entry.getKey(), entry.getValue());
            for (Address backup : distributionInfo.writeBackups()) {
                this.backups.computeIfAbsent(backup, address -> new HashSet(this.entryCount)).add(segment);
            }
        }
    }
}

