/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.SmallIntSet;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateProviderImpl;
import org.infinispan.statetransfer.StateResponseCommand;
import org.infinispan.util.ReadOnlyDataContainerBackedKeySet;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OutboundTransferTask
implements Runnable {
    private static final Log log = LogFactory.getLog(OutboundTransferTask.class);
    private final boolean trace = log.isTraceEnabled();
    private final StateProviderImpl stateProvider;
    private final int topologyId;
    private final Address destination;
    private final Set<Integer> segments = new CopyOnWriteArraySet<Integer>();
    private final int chunkSize;
    private final KeyPartitioner keyPartitioner;
    private final DataContainer<Object, Object> dataContainer;
    private final PersistenceManager persistenceManager;
    private final RpcManager rpcManager;
    private final CommandsFactory commandsFactory;
    private final long timeout;
    private final String cacheName;
    private final Map<Integer, List<InternalCacheEntry>> entriesBySegment = CollectionFactory.makeConcurrentMap();
    private int accumulatedEntries;
    private FutureTask<Void> runnableFuture;
    private final RpcOptions rpcOptions;
    private InternalEntryFactory entryFactory;

    public OutboundTransferTask(Address destination, Set<Integer> segments, int chunkSize, int topologyId, KeyPartitioner keyPartitioner, StateProviderImpl stateProvider, DataContainer dataContainer, PersistenceManager persistenceManager, RpcManager rpcManager, CommandsFactory commandsFactory, InternalEntryFactory ef, long timeout, String cacheName) {
        if (segments == null || segments.isEmpty()) {
            throw new IllegalArgumentException("Segments must not be null or empty");
        }
        if (destination == null) {
            throw new IllegalArgumentException("Destination address cannot be null");
        }
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be greater than 0");
        }
        this.stateProvider = stateProvider;
        this.destination = destination;
        this.segments.addAll(segments);
        this.chunkSize = chunkSize;
        this.topologyId = topologyId;
        this.keyPartitioner = keyPartitioner;
        this.dataContainer = dataContainer;
        this.persistenceManager = persistenceManager;
        this.entryFactory = ef;
        this.rpcManager = rpcManager;
        this.commandsFactory = commandsFactory;
        this.timeout = timeout;
        this.cacheName = cacheName;
        this.rpcOptions = rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS).timeout(timeout, TimeUnit.MILLISECONDS).build();
    }

    public void execute(ExecutorService executorService) {
        if (this.runnableFuture != null) {
            throw new IllegalStateException("This task was already submitted");
        }
        this.runnableFuture = new FutureTask<Void>((Runnable)this, null){

            @Override
            protected void done() {
                OutboundTransferTask.this.stateProvider.onTaskCompletion(OutboundTransferTask.this);
            }
        };
        executorService.submit(this.runnableFuture);
    }

    public Address getDestination() {
        return this.destination;
    }

    public Set<Integer> getSegments() {
        return this.segments;
    }

    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void run() {
        try {
            for (InternalCacheEntry<Object, Object> internalCacheEntry : this.dataContainer) {
                Object key = internalCacheEntry.getKey();
                int segmentId = this.keyPartitioner.getSegment(key);
                if (!this.segments.contains(segmentId) || internalCacheEntry.isL1Entry()) continue;
                this.sendEntry(internalCacheEntry, segmentId);
            }
            AdvancedCacheLoader stProvider = this.persistenceManager.getStateTransferProvider();
            if (stProvider != null) {
                try {
                    CollectionKeyFilter<Object> collectionKeyFilter = new CollectionKeyFilter<Object>(new ReadOnlyDataContainerBackedKeySet(this.dataContainer));
                    AdvancedCacheLoader.CacheLoaderTask task = (me, taskContext) -> {
                        int segmentId = this.keyPartitioner.getSegment(me.getKey());
                        if (this.segments.contains(segmentId)) {
                            try {
                                InternalCacheEntry icv = this.entryFactory.create(me.getKey(), me.getValue(), me.getMetadata());
                                this.sendEntry(icv, segmentId);
                            }
                            catch (CacheException e) {
                                log.failedLoadingValueFromCacheStore(me.getKey(), (Exception)((Object)e));
                            }
                        }
                    };
                    stProvider.process(collectionKeyFilter, task, new WithinThreadExecutor(), true, true);
                }
                catch (CacheException cacheException) {
                    log.failedLoadingKeysFromCacheStore((Exception)((Object)cacheException));
                }
            }
            this.sendEntries(true);
        }
        catch (Throwable t) {
            if (this.isCancelled()) {
                if (this.trace) {
                    log.tracef("Ignoring error in already cancelled transfer to node %s, segments %s", this.destination, this.segments);
                }
            }
            log.failedOutBoundTransferExecution(t);
        }
        if (this.trace) {
            log.tracef("Completed outbound transfer to node %s, segments %s", this.destination, this.segments);
        }
    }

    private void sendEntry(InternalCacheEntry ice, int segmentId) {
        if (this.accumulatedEntries >= this.chunkSize) {
            this.sendEntries(false);
            this.accumulatedEntries = 0;
        }
        List entries = this.entriesBySegment.computeIfAbsent(segmentId, k -> new ArrayList());
        entries.add(ice);
        ++this.accumulatedEntries;
    }

    private void sendEntries(boolean isLast) {
        List<InternalCacheEntry> entries;
        ArrayList<StateChunk> chunks = new ArrayList<StateChunk>();
        for (Map.Entry<Integer, List<InternalCacheEntry>> e : this.entriesBySegment.entrySet()) {
            entries = e.getValue();
            if (entries.isEmpty() && !isLast) continue;
            chunks.add(new StateChunk(e.getKey(), new ArrayList<InternalCacheEntry>(entries), isLast));
            entries.clear();
        }
        if (isLast) {
            Iterator<Object> iterator = this.segments.iterator();
            while (iterator.hasNext()) {
                int segmentId = (Integer)iterator.next();
                entries = this.entriesBySegment.get(segmentId);
                if (entries != null) continue;
                chunks.add(new StateChunk(segmentId, Collections.emptyList(), true));
            }
        }
        if (!chunks.isEmpty()) {
            if (this.trace) {
                if (isLast) {
                    log.tracef("Sending last chunk to node %s containing %d cache entries from segments %s", this.destination, this.accumulatedEntries, this.segments);
                } else {
                    log.tracef("Sending to node %s %d cache entries from segments %s", this.destination, this.accumulatedEntries, this.entriesBySegment.keySet());
                }
            }
            StateResponseCommand cmd = this.commandsFactory.buildStateResponseCommand(this.rpcManager.getAddress(), this.topologyId, chunks);
            try {
                this.rpcManager.invokeRemotely(Collections.singleton(this.destination), cmd, this.rpcOptions);
            }
            catch (SuspectException e) {
                log.debugf("Node %s left cache %s while we were sending state to it, cancelling transfer.", this.destination, this.cacheName);
                this.cancel();
            }
            catch (Exception e) {
                if (this.isCancelled()) {
                    log.debugf("Stopping cancelled transfer to node %s, segments %s", this.destination, this.segments);
                }
                log.errorf(e, "Failed to send entries to node %s: %s", this.destination, e.getMessage());
            }
        }
    }

    public void cancelSegments(Set<Integer> cancelledSegments) {
        if (this.segments.removeAll(cancelledSegments)) {
            if (this.trace) {
                log.tracef("Cancelling outbound transfer to node %s, segments %s (remaining segments %s)", this.destination, cancelledSegments, this.segments);
            }
            this.entriesBySegment.keySet().removeAll(cancelledSegments);
            if (this.segments.isEmpty()) {
                this.cancel();
            }
        }
    }

    public void cancel() {
        if (this.runnableFuture != null && !this.runnableFuture.isCancelled()) {
            log.debugf("Cancelling outbound transfer to node %s, segments %s", this.destination, this.segments);
            this.runnableFuture.cancel(true);
        }
    }

    public boolean isCancelled() {
        return this.runnableFuture != null && this.runnableFuture.isCancelled();
    }

    public String toString() {
        return "OutboundTransferTask{topologyId=" + this.topologyId + ", destination=" + this.destination + ", segments=" + new SmallIntSet(this.segments) + ", chunkSize=" + this.chunkSize + ", timeout=" + this.timeout + ", cacheName='" + this.cacheName + '\'' + '}';
    }
}

