/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.toJavaPortable;

import com.sun.tools.corba.se.idl.toJavaPortable.NameModifier;
import com.sun.tools.corba.se.idl.toJavaPortable.Util;

public class NameModifierImpl
implements NameModifier {
    private String prefix;
    private String suffix;

    public NameModifierImpl() {
        this.prefix = null;
        this.suffix = null;
    }

    public NameModifierImpl(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public NameModifierImpl(String pattern) {
        int first = pattern.indexOf(37);
        int last = pattern.lastIndexOf(37);
        if (first != last) {
            throw new IllegalArgumentException(Util.getMessage("NameModifier.TooManyPercent"));
        }
        if (first == -1) {
            throw new IllegalArgumentException(Util.getMessage("NameModifier.NoPercent"));
        }
        for (int ctr = 0; ctr < pattern.length(); ++ctr) {
            char ch = pattern.charAt(ctr);
            if (!this.invalidChar(ch, ctr == 0)) continue;
            char[] chars = new char[]{ch};
            throw new IllegalArgumentException(Util.getMessage("NameModifier.InvalidChar", new String(chars)));
        }
        this.prefix = pattern.substring(0, first);
        this.suffix = pattern.substring(first + 1);
    }

    private boolean invalidChar(char ch, boolean isFirst) {
        if ('A' <= ch && ch <= 'Z') {
            return false;
        }
        if ('a' <= ch && ch <= 'z') {
            return false;
        }
        if ('0' <= ch && ch <= '9') {
            return isFirst;
        }
        if (ch == '%') {
            return false;
        }
        if (ch == '$') {
            return false;
        }
        return ch != '_';
    }

    @Override
    public String makeName(String base) {
        StringBuffer sb = new StringBuffer();
        if (this.prefix != null) {
            sb.append(this.prefix);
        }
        sb.append(base);
        if (this.suffix != null) {
            sb.append(this.suffix);
        }
        return sb.toString();
    }
}

