/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.util.Version;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalyzerDefinitionRegistryBuilderImpl;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalyzerDefinitionProvider;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalyzerDefinitionSourceService;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerBuilder;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.NamedLuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.ScopedLuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.SimpleLuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerStrategy;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.cfg.Environment;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.PassThroughAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneEmbeddedAnalyzerStrategy
implements AnalyzerStrategy {
    private static final Log log = LoggerFactory.make();
    private final ServiceManager serviceManager;
    private final SearchConfiguration cfg;
    private final Version luceneMatchVersion;

    public LuceneEmbeddedAnalyzerStrategy(ServiceManager serviceManager, SearchConfiguration cfg) {
        this.serviceManager = serviceManager;
        this.cfg = cfg;
        this.luceneMatchVersion = this.getLuceneMatchVersion(cfg);
    }

    private Version getLuceneMatchVersion(SearchConfiguration cfg) {
        Version version;
        String tmp = cfg.getProperty("hibernate.search.lucene_version");
        if (StringHelper.isEmpty(tmp)) {
            log.recommendConfiguringLuceneVersion();
            version = Environment.DEFAULT_LUCENE_MATCH_VERSION;
        } else {
            try {
                version = Version.parseLeniently((String)tmp);
                if (log.isDebugEnabled()) {
                    log.debug("Setting Lucene compatibility to Version " + version);
                }
            }
            catch (IllegalArgumentException e) {
                throw log.illegalLuceneVersionFormat(tmp, e.getMessage());
            }
            catch (ParseException e) {
                throw log.illegalLuceneVersionFormat(tmp, e.getMessage());
            }
        }
        return version;
    }

    private Map<String, AnalyzerDef> createDefaultAnalyzerDefinitions() {
        LuceneAnalyzerDefinitionProvider definitionsProvider = this.getLuceneAnalyzerDefinitionProvider();
        LuceneAnalyzerDefinitionRegistryBuilderImpl builder = new LuceneAnalyzerDefinitionRegistryBuilderImpl();
        if (definitionsProvider != null) {
            try {
                definitionsProvider.register(builder);
            }
            catch (SearchException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw log.invalidLuceneAnalyzerDefinitionProvider(definitionsProvider.getClass().getName(), e);
            }
        }
        return builder.build();
    }

    private LuceneAnalyzerDefinitionProvider getLuceneAnalyzerDefinitionProvider() {
        try (ServiceReference<LuceneAnalyzerDefinitionSourceService> serviceRef = this.serviceManager.requestReference(LuceneAnalyzerDefinitionSourceService.class);){
            LuceneAnalyzerDefinitionProvider luceneAnalyzerDefinitionProvider = serviceRef.get().getLuceneAnalyzerDefinitionProvider();
            return luceneAnalyzerDefinitionProvider;
        }
    }

    @Override
    public LuceneAnalyzerReference createDefaultAnalyzerReference() {
        Class analyzerClass;
        String analyzerClassName = this.cfg.getProperty("hibernate.search.analyzer");
        if (analyzerClassName != null) {
            try {
                analyzerClass = ClassLoaderHelper.classForName(analyzerClassName, this.serviceManager);
            }
            catch (Exception e) {
                return this.createNamedAnalyzerReference(analyzerClassName);
            }
        } else {
            analyzerClass = StandardAnalyzer.class;
        }
        return this.createLuceneClassAnalyzerReference(analyzerClass);
    }

    @Override
    public LuceneAnalyzerReference createPassThroughAnalyzerReference() {
        return new SimpleLuceneAnalyzerReference(PassThroughAnalyzer.INSTANCE);
    }

    @Override
    public LuceneAnalyzerReference createLuceneClassAnalyzerReference(Class<?> analyzerClass) {
        try {
            Analyzer analyzer = ClassLoaderHelper.analyzerInstanceFromClass(analyzerClass, this.luceneMatchVersion);
            return new SimpleLuceneAnalyzerReference(analyzer);
        }
        catch (ClassCastException e) {
            throw new SearchException("Lucene analyzer does not extend " + Analyzer.class.getName() + ": " + analyzerClass.getName(), e);
        }
        catch (Exception e) {
            throw new SearchException("Failed to instantiate lucene analyzer with type " + analyzerClass.getName(), e);
        }
    }

    @Override
    public NamedLuceneAnalyzerReference createNamedAnalyzerReference(String name) {
        return new NamedLuceneAnalyzerReference(name);
    }

    @Override
    public Map<String, AnalyzerReference> initializeAnalyzerReferences(Collection<AnalyzerReference> references, Map<String, AnalyzerDef> mappingAnalyzerDefinitions) {
        Map<String, AnalyzerDef> defaultAnalyzerDefinitions = this.createDefaultAnalyzerDefinitions();
        HashMap<String, AnalyzerDef> analyzerDefinitions = new HashMap<String, AnalyzerDef>(defaultAnalyzerDefinitions);
        analyzerDefinitions.putAll(mappingAnalyzerDefinitions);
        HashSet<String> existingNamedReferences = new HashSet<String>();
        for (AnalyzerReference reference : references) {
            ScopedLuceneAnalyzerReference scopedReference;
            if (reference.is(NamedLuceneAnalyzerReference.class)) {
                NamedLuceneAnalyzerReference namedReference = reference.unwrap(NamedLuceneAnalyzerReference.class);
                if (!namedReference.isInitialized()) {
                    this.initializeReference(namedReference, analyzerDefinitions);
                }
                existingNamedReferences.add(namedReference.getAnalyzerName());
                continue;
            }
            if (!reference.is(ScopedLuceneAnalyzerReference.class) || (scopedReference = reference.unwrap(ScopedLuceneAnalyzerReference.class)).isInitialized()) continue;
            scopedReference.initialize();
        }
        HashMap<String, AnalyzerReference> additionalNamedReferences = new HashMap<String, AnalyzerReference>();
        for (String defaultAnalyzerName : defaultAnalyzerDefinitions.keySet()) {
            if (existingNamedReferences.contains(defaultAnalyzerName)) continue;
            NamedLuceneAnalyzerReference reference = this.createNamedAnalyzerReference(defaultAnalyzerName);
            this.initializeReference(reference, analyzerDefinitions);
            additionalNamedReferences.put(defaultAnalyzerName, reference);
        }
        return additionalNamedReferences;
    }

    private void initializeReference(NamedLuceneAnalyzerReference analyzerReference, Map<String, AnalyzerDef> analyzerDefinitions) {
        String name = analyzerReference.getAnalyzerName();
        AnalyzerDef analyzerDefinition = analyzerDefinitions.get(name);
        if (analyzerDefinition == null) {
            throw new SearchException("Lucene analyzer found with an unknown definition: " + name);
        }
        Analyzer analyzer = this.buildAnalyzer(analyzerDefinition);
        analyzerReference.initialize(analyzer);
    }

    private Analyzer buildAnalyzer(AnalyzerDef analyzerDefinition) {
        try {
            return LuceneAnalyzerBuilder.buildAnalyzer(analyzerDefinition, this.luceneMatchVersion, this.serviceManager);
        }
        catch (IOException e) {
            throw new SearchException("Could not initialize Analyzer definition " + analyzerDefinition, e);
        }
    }

    @Override
    public ScopedAnalyzerReference.Builder buildScopedAnalyzerReference(AnalyzerReference initialGlobalAnalyzerReference) {
        return new ScopedLuceneAnalyzerReference.DeferredInitializationBuilder(initialGlobalAnalyzerReference.unwrap(LuceneAnalyzerReference.class), Collections.emptyMap());
    }
}

