/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.infinispan.util.BeginInvalidationCommand;
import org.hibernate.cache.infinispan.util.EndInvalidationCommand;
import org.hibernate.cache.infinispan.util.EvictAllCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.module.ExtendedModuleCommandFactory;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commands.remote.CacheRpcCommand;

public class CacheCommandFactory
implements ExtendedModuleCommandFactory {
    private ConcurrentMap<String, BaseRegion> allRegions = new ConcurrentHashMap<String, BaseRegion>();

    public void addRegion(BaseRegion region) {
        this.allRegions.put(region.getName(), region);
    }

    public void clearRegions(Collection<BaseRegion> regions) {
        for (BaseRegion region : regions) {
            this.allRegions.remove(region.getName());
        }
    }

    public Map<Byte, Class<? extends ReplicableCommand>> getModuleCommands() {
        HashMap<Byte, Class<? extends ReplicableCommand>> map = new HashMap<Byte, Class<? extends ReplicableCommand>>(3);
        map.put((byte)120, EvictAllCommand.class);
        map.put((byte)121, EndInvalidationCommand.class);
        map.put((byte)122, BeginInvalidationCommand.class);
        return map;
    }

    public CacheRpcCommand fromStream(byte commandId, Object[] args, String cacheName) {
        BaseRpcCommand c;
        switch (commandId) {
            case 120: {
                c = new EvictAllCommand(cacheName, (BaseRegion)this.allRegions.get(cacheName));
                break;
            }
            case 121: {
                c = new EndInvalidationCommand(cacheName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not registered to handle command id " + commandId);
            }
        }
        c.setParameters((int)commandId, args);
        return c;
    }

    public ReplicableCommand fromStream(byte commandId, Object[] args) {
        BeginInvalidationCommand c;
        switch (commandId) {
            case 122: {
                c = new BeginInvalidationCommand();
                break;
            }
            default: {
                throw new IllegalArgumentException("Not registered to handle command id " + commandId);
            }
        }
        c.setParameters(commandId, args);
        return c;
    }
}

