/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container;

import org.infinispan.atomic.Delta;
import org.infinispan.atomic.DeltaAware;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.container.DataContainer;
import org.infinispan.container.EntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.DeltaAwareCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.container.entries.ReadCommittedEntry;
import org.infinispan.container.entries.RepeatableReadEntry;
import org.infinispan.container.entries.VersionedRepeatableReadEntry;
import org.infinispan.container.versioning.VersionGenerator;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EntryFactoryImpl
implements EntryFactory {
    protected static final Log log = LogFactory.getLog(EntryFactoryImpl.class);
    protected static final boolean trace = log.isTraceEnabled();
    private boolean useRepeatableRead;
    private DataContainer container;
    private boolean isL1Enabled;
    private Configuration configuration;
    private PersistenceManager persistenceManager;
    private TimeService timeService;
    private VersionGenerator versionGenerator;
    private boolean useVersioning;

    @Inject
    public void injectDependencies(DataContainer dataContainer, Configuration configuration, TimeService timeService, PersistenceManager persistenceManager, VersionGenerator versionGenerator) {
        this.container = dataContainer;
        this.configuration = configuration;
        this.timeService = timeService;
        this.persistenceManager = persistenceManager;
        this.versionGenerator = versionGenerator;
    }

    @Start(priority=8)
    public void init() {
        this.useRepeatableRead = this.configuration.transaction().transactionMode().isTransactional() && this.configuration.locking().isolationLevel() == IsolationLevel.REPEATABLE_READ;
        this.isL1Enabled = this.configuration.clustering().l1().enabled();
        this.useVersioning = Configurations.isTxVersioned(this.configuration);
    }

    @Override
    public final void wrapEntryForReading(InvocationContext ctx, Object key, boolean isOwner) {
        if (!isOwner && !this.isL1Enabled) {
            return;
        }
        CacheEntry cacheEntry = this.getFromContext(ctx, key);
        if (cacheEntry == null && (cacheEntry = this.getFromContainerForRead(key, isOwner)) != null) {
            if (this.useRepeatableRead) {
                MVCCEntry mvccEntry = this.createWrappedEntry(key, cacheEntry);
                mvccEntry.setRead();
                cacheEntry = mvccEntry;
            }
            ctx.putLookedUpEntry(key, cacheEntry);
        }
        if (trace) {
            log.tracef("Wrap %s for read. Entry=%s", Util.toStr((Object)key), cacheEntry);
        }
    }

    @Override
    public void wrapEntryForWriting(InvocationContext ctx, Object key, boolean isOwner, boolean isRead) {
        CacheEntry contextEntry = this.getFromContext(ctx, key);
        if (!(contextEntry instanceof MVCCEntry)) {
            if (contextEntry != null) {
                MVCCEntry mvccEntry = this.createWrappedEntry(key, contextEntry);
                ctx.putLookedUpEntry(key, mvccEntry);
                if (trace) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, mvccEntry);
                }
            } else {
                CacheEntry cacheEntry = this.getFromContainer(key, isOwner, true);
                if (cacheEntry == null) {
                    return;
                }
                MVCCEntry mvccEntry = this.createWrappedEntry(key, cacheEntry);
                if (cacheEntry.isNull()) {
                    mvccEntry.setCreated(true);
                }
                if (isRead) {
                    mvccEntry.setRead();
                }
                ctx.putLookedUpEntry(key, mvccEntry);
                if (trace) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, mvccEntry);
                }
            }
        }
    }

    @Override
    public void wrapExternalEntry(InvocationContext ctx, Object key, CacheEntry externalEntry, boolean isRead, boolean isWrite) {
        CacheEntry contextEntry = this.getFromContext(ctx, key);
        if (contextEntry instanceof MVCCEntry) {
            MVCCEntry mvccEntry = (MVCCEntry)contextEntry;
            if (mvccEntry.skipLookup()) {
                if (trace) {
                    log.tracef("Ignored update for context entry %s", contextEntry);
                }
                return;
            }
            mvccEntry.setValue(externalEntry.getValue());
            mvccEntry.setCreated(externalEntry.getCreated());
            mvccEntry.setLastUsed(externalEntry.getLastUsed());
            mvccEntry.setMetadata(externalEntry.getMetadata());
            mvccEntry.updatePreviousValue();
            if (trace) {
                log.tracef("Updated context entry %s", contextEntry);
            }
        } else if (contextEntry == null || contextEntry.isNull()) {
            if (isWrite || this.useRepeatableRead) {
                MVCCEntry mvccEntry = this.createWrappedEntry(key, externalEntry);
                if (isRead) {
                    mvccEntry.setRead();
                }
                ctx.putLookedUpEntry(key, mvccEntry);
                if (trace) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, mvccEntry);
                }
            } else {
                ctx.putLookedUpEntry(key, externalEntry);
                if (trace) {
                    log.tracef("Updated context entry %s -> %s", contextEntry, externalEntry);
                }
            }
        } else if (this.useRepeatableRead) {
            if (trace) {
                log.tracef("Ignored update %s -> %s as we do repeatable reads", contextEntry, externalEntry);
            }
        } else {
            ctx.putLookedUpEntry(key, externalEntry);
            if (trace) {
                log.tracef("Updated context entry %s -> %s", contextEntry, externalEntry);
            }
        }
    }

    @Override
    public void wrapEntryForDelta(InvocationContext ctx, Object deltaKey, Delta delta, boolean isOwner) {
        DeltaAwareCacheEntry deltaAwareEntry;
        CacheEntry cacheEntry = this.getFromContext(ctx, deltaKey);
        if (cacheEntry instanceof DeltaAwareCacheEntry) {
            deltaAwareEntry = (DeltaAwareCacheEntry)cacheEntry;
        } else if (cacheEntry != null) {
            deltaAwareEntry = this.createWrappedDeltaEntry(deltaKey, (DeltaAware)cacheEntry.getValue(), cacheEntry, ctx);
            if (cacheEntry instanceof MVCCEntry && ((MVCCEntry)cacheEntry).isRead()) {
                deltaAwareEntry.setRead();
            }
            ctx.putLookedUpEntry(deltaKey, deltaAwareEntry);
        } else {
            cacheEntry = this.getFromContainer(deltaKey, isOwner, false);
            DeltaAwareCacheEntry deltaEntry = this.createWrappedDeltaEntry(deltaKey, cacheEntry != null ? (DeltaAware)cacheEntry.getValue() : null, null, ctx);
            deltaEntry.setRead();
            ctx.putLookedUpEntry(deltaKey, deltaEntry);
            deltaAwareEntry = deltaEntry;
        }
        if (trace) {
            log.tracef("Wrap %s for delta. Entry=%s", deltaKey, deltaAwareEntry);
        }
    }

    private CacheEntry getFromContext(InvocationContext ctx, Object key) {
        CacheEntry cacheEntry = ctx.lookupEntry(key);
        if (trace) {
            log.tracef("Exists in context? %s ", cacheEntry);
        }
        return cacheEntry;
    }

    private CacheEntry getFromContainer(Object key, boolean isOwner, boolean writeOperation) {
        if (isOwner) {
            InternalCacheEntry ice = this.innerGetFromContainer(key, writeOperation);
            if (trace) {
                log.tracef("Retrieved from container %s", ice);
            }
            if (ice == null) {
                return NullCacheEntry.getInstance();
            }
            return ice;
        }
        if (this.isL1Enabled) {
            InternalCacheEntry ice = this.innerGetFromContainer(key, writeOperation);
            if (trace) {
                log.tracef("Retrieved from container %s", ice);
            }
            if (ice == null || !ice.isL1Entry()) {
                return null;
            }
            return ice;
        }
        return null;
    }

    private CacheEntry getFromContainerForRead(Object key, boolean isOwner) {
        InternalCacheEntry ice = this.container.get(key);
        if (trace) {
            log.tracef("Retrieved from container %s", ice);
        }
        if (isOwner) {
            return ice == null ? NullCacheEntry.getInstance() : ice;
        }
        return ice == null || !ice.isL1Entry() ? null : ice;
    }

    private InternalCacheEntry innerGetFromContainer(Object key, boolean writeOperation) {
        InternalCacheEntry ice;
        if (writeOperation) {
            ice = this.container.peek(key);
            if (ice != null && ice.canExpire()) {
                long wallClockTime = this.timeService.wallClockTime();
                if (ice.isExpired(wallClockTime)) {
                    ice = null;
                } else {
                    ice.touch(wallClockTime);
                }
            }
        } else {
            ice = this.container.get(key);
        }
        return ice;
    }

    protected MVCCEntry createWrappedEntry(Object key, CacheEntry cacheEntry) {
        Object value = null;
        Metadata metadata = null;
        if (cacheEntry != null) {
            value = cacheEntry.getValue();
            metadata = cacheEntry.getMetadata();
        }
        if (trace) {
            log.tracef("Creating new entry for key %s", Util.toStr((Object)key));
        }
        if (this.useRepeatableRead) {
            RepeatableReadEntry mvccEntry;
            if (this.useVersioning) {
                if (metadata == null) {
                    metadata = new EmbeddedMetadata.Builder().version(this.versionGenerator.nonExistingVersion()).build();
                }
                mvccEntry = new VersionedRepeatableReadEntry(key, value, metadata);
            } else {
                mvccEntry = new RepeatableReadEntry(key, value, metadata);
            }
            return mvccEntry;
        }
        return new ReadCommittedEntry(key, value, metadata);
    }

    private DeltaAwareCacheEntry createWrappedDeltaEntry(Object key, DeltaAware deltaAware, CacheEntry entry, InvocationContext ctx) {
        DeltaAwareCacheEntry<Object> deltaAwareCacheEntry = new DeltaAwareCacheEntry<Object>(key, deltaAware, entry, ctx, this.persistenceManager, this.timeService);
        if (entry != null && entry.isCreated()) {
            deltaAwareCacheEntry.setCreated(true);
        }
        return deltaAwareCacheEntry;
    }
}

