/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.InvalidationInterceptor;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.stats.ClusterCacheStats;
import org.infinispan.stats.Stats;
import org.infinispan.stats.impl.AbstractClusterStats;
import org.infinispan.stats.impl.SecurityActions;
import org.infinispan.util.concurrent.locks.LockManager;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="ClusterCacheStats", description="General cluster statistics such as timings, hit/miss ratio, etc.")
public class ClusterCacheStatsImpl
extends AbstractClusterStats
implements ClusterCacheStats {
    private static final String TIME_SINCE_START = "timeSinceStart";
    private static final String REMOVE_MISSES = "removeMisses";
    private static final String REMOVE_HITS = "removeHits";
    private static final String AVERAGE_WRITE_TIME = "averageWriteTime";
    private static final String AVERAGE_READ_TIME = "averageReadTime";
    private static final String AVERAGE_REMOVE_TIME = "averageRemoveTime";
    private static final String EVICTIONS = "evictions";
    private static final String HITS = "hits";
    private static final String MISSES = "misses";
    private static final String NUMBER_OF_ENTRIES = "numberOfEntries";
    private static final String OFF_HEAP_MEMORY_USED = "offHeapMemoryUsed";
    private static final String STORES = "stores";
    private static final String NUMBER_OF_LOCKS_HELD = "numberOfLocksHeld";
    private static final String NUMBER_OF_LOCKS_AVAILABLE = "numberOfLocksAvailable";
    private static final String INVALIDATIONS = "invalidations";
    private static final String PASSIVATIONS = "passivations";
    private static final String ACTIVATIONS = "activations";
    private static final String CACHE_LOADER_LOADS = "cacheLoaderLoads";
    private static final String CACHE_LOADER_MISSES = "cacheLoaderMisses";
    private static final String CACHE_WRITER_STORES = "cacheWriterStores";
    private static String[] LONG_ATTRIBUTES = new String[]{"evictions", "hits", "misses", "offHeapMemoryUsed", "removeHits", "removeMisses", "invalidations", "passivations", "activations", "cacheLoaderLoads", "cacheLoaderMisses", "cacheWriterStores", "stores"};
    private static final Log log = LogFactory.getLog(ClusterCacheStatsImpl.class);
    private DefaultExecutorService des;
    private AdvancedCache cache;
    private double readWriteRatio;
    private double hitRatio;

    public ClusterCacheStatsImpl() {
        super(log);
    }

    @Inject
    public void injectDependencies(Cache<?, ?> cache, Configuration configuration) {
        this.cache = cache.getAdvancedCache();
        this.statisticsEnabled = configuration.jmxStatistics().enabled();
    }

    @Override
    @Start
    public void start() {
        this.des = SecurityActions.getDefaultExecutorService(this.cache);
    }

    @Stop
    public void stop() {
        if (this.des != null && !this.des.isShutdown()) {
            this.des.shutdownNow();
        }
    }

    @Override
    void updateStats() throws Exception {
        ArrayList<Map<String, Number>> responseList = new ArrayList<Map<String, Number>>();
        List<CompletableFuture<Map<String, Number>>> responseFutures = this.des.submitEverywhere(new DistributedCacheStatsCallable());
        for (CompletableFuture<Map<String, Number>> cf : responseFutures) {
            responseList.add(cf.get());
        }
        for (String att : LONG_ATTRIBUTES) {
            this.putLongAttributes(responseList, att);
        }
        this.putLongAttributesAverage(responseList, AVERAGE_WRITE_TIME);
        this.putLongAttributesAverage(responseList, AVERAGE_READ_TIME);
        this.putLongAttributesAverage(responseList, AVERAGE_REMOVE_TIME);
        this.putIntAttributes(responseList, NUMBER_OF_LOCKS_HELD);
        this.putIntAttributes(responseList, NUMBER_OF_LOCKS_AVAILABLE);
        long numberOfEntries = ClusterCacheStatsImpl.getCacheMode(this.cache).isReplicated() ? (long)this.cache.getStats().getCurrentNumberOfEntries() : this.addLongAttributes(responseList, NUMBER_OF_ENTRIES);
        this.statsMap.put(NUMBER_OF_ENTRIES, numberOfEntries);
        this.updateTimeSinceStart(responseList);
        this.updateRatios(responseList);
    }

    @Override
    @ManagedAttribute(description="Cluster wide total average number of milliseconds for a read operation on the cache", displayName="Cluster wide total average read time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageReadTime() {
        return this.getStatAsLong(AVERAGE_READ_TIME);
    }

    @Override
    @ManagedAttribute(description="Cluster wide total average number of milliseconds for a remove operation in the cache", displayName="Cluster wide total average remove time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageRemoveTime() {
        return this.getStatAsLong(AVERAGE_REMOVE_TIME);
    }

    @Override
    @ManagedAttribute(description="Cluster wide average number of milliseconds for a write operation in the cache", displayName="Cluster wide average write time", units=Units.MILLISECONDS, displayType=DisplayType.SUMMARY)
    public long getAverageWriteTime() {
        return this.getStatAsLong(AVERAGE_WRITE_TIME);
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache eviction operations", displayName="Cluster wide total number of cache evictions", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getEvictions() {
        return this.getStatAsLong(EVICTIONS);
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache attribute hits", displayName="Cluster wide total number of cache hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getHits() {
        return this.getStatAsLong(HITS);
    }

    @Override
    @ManagedAttribute(description="Cluster wide total percentage hit/(hit+miss) ratio for this cache", displayName="Cluster wide total hit ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getHitRatio() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.hitRatio;
        }
        return -1.0;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache attribute misses", displayName="Cluster wide total number of cache misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getMisses() {
        return this.getStatAsLong(MISSES);
    }

    @ManagedAttribute(description="Cluster wide total number of entries currently in the cache", displayName="Cluster wide total number of current cache entries", displayType=DisplayType.SUMMARY)
    public int getNumberOfEntries() {
        return this.getStatAsInt(NUMBER_OF_ENTRIES);
    }

    @Override
    @ManagedAttribute(description="Cluster wide read/writes ratio for the cache", displayName="Cluster wide read/write ratio", units=Units.PERCENTAGE, displayType=DisplayType.SUMMARY)
    public double getReadWriteRatio() {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.readWriteRatio;
        }
        return -1.0;
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache removal hits", displayName="Cluster wide total number of cache removal hits", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveHits() {
        return this.getStatAsLong(REMOVE_HITS);
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache removals where keys were not found", displayName="Cluster wide total number of cache removal misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getRemoveMisses() {
        return this.getStatAsLong(REMOVE_MISSES);
    }

    @Override
    @ManagedAttribute(description="Cluster wide total number of cache attribute put operations", displayName="Cluster wide total number of cache puts", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStores() {
        return this.getStatAsLong(STORES);
    }

    @Override
    @ManagedAttribute(description="Number of seconds since the first cache node started", displayName="Number of seconds since the first cache node started", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getTimeSinceStart() {
        return this.getStatAsLong(TIME_SINCE_START);
    }

    @Override
    public int getCurrentNumberOfEntries() {
        return this.getNumberOfEntries();
    }

    @Override
    public long getTotalNumberOfEntries() {
        return this.getStores();
    }

    @Override
    @ManagedAttribute(description="Amount in bytes of off-heap memory used across the cluster for this cache", displayName="Cluster wide off-sheap memory used", displayType=DisplayType.SUMMARY)
    public long getOffHeapMemoryUsed() {
        return this.getStatAsLong(OFF_HEAP_MEMORY_USED);
    }

    @Override
    public long getRetrievals() {
        return this.getHits() + this.getMisses();
    }

    @Override
    public void reset() {
        super.reset();
        this.readWriteRatio = 0.0;
        this.hitRatio = 0.0;
    }

    @Override
    @ManagedAttribute(description="Total number of exclusive locks available in the cluster", displayName="Cluster wide total number of locks", measurementType=MeasurementType.DYNAMIC, displayType=DisplayType.SUMMARY)
    public int getNumberOfLocksAvailable() {
        return this.getStatAsInt(NUMBER_OF_LOCKS_AVAILABLE);
    }

    @Override
    @ManagedAttribute(description="Total number of locks held in the cluster", displayName="Cluster wide total number of locks held", measurementType=MeasurementType.DYNAMIC, displayType=DisplayType.SUMMARY)
    public int getNumberOfLocksHeld() {
        return this.getStatAsInt(NUMBER_OF_LOCKS_HELD);
    }

    @Override
    @ManagedAttribute(description="The total number of invalidations in the cluster", displayName="Cluster wide total number of invalidations", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getInvalidations() {
        return this.getStatAsLong(INVALIDATIONS);
    }

    @Override
    @ManagedAttribute(description="The total number of activations in the cluster", displayName="Cluster wide total number of activations", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getActivations() {
        return this.getStatAsLong(ACTIVATIONS);
    }

    @Override
    @ManagedAttribute(description="The total number of passivations in the cluster", displayName="Cluster wide total number of passivations", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getPassivations() {
        return this.getStatAsLong(PASSIVATIONS);
    }

    @Override
    @ManagedAttribute(description="The total number of cacheloader load operations in the cluster", displayName="Cluster wide total number of cacheloader loads", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getCacheLoaderLoads() {
        return this.getStatAsLong(CACHE_LOADER_LOADS);
    }

    @Override
    @ManagedAttribute(description="The total number of cacheloader load misses in the cluster", displayName="Cluster wide total number of cacheloader misses", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getCacheLoaderMisses() {
        return this.getStatAsLong(CACHE_LOADER_MISSES);
    }

    @Override
    @ManagedAttribute(description="The total number of cachestore store operations in the cluster", displayName="Cluster wide total number of cachestore stores", measurementType=MeasurementType.TRENDSUP, displayType=DisplayType.SUMMARY)
    public long getStoreWrites() {
        return this.getStatAsLong(CACHE_WRITER_STORES);
    }

    private void updateTimeSinceStart(List<Map<String, Number>> responseList) {
        long timeSinceStartMax = 0L;
        for (Map<String, Number> m : responseList) {
            Number timeSinceStart = m.get(TIME_SINCE_START);
            if (timeSinceStart.longValue() <= timeSinceStartMax) continue;
            timeSinceStartMax = timeSinceStart.longValue();
        }
        this.statsMap.put(TIME_SINCE_START, timeSinceStartMax);
    }

    private void updateRatios(List<Map<String, Number>> responseList) {
        long totalHits = 0L;
        long sumOfAllReads = 0L;
        long sumOfAllWrites = 0L;
        double hitRatio = 0.0;
        double rwRatio = 0.0;
        for (Map<String, Number> m : responseList) {
            sumOfAllReads += (totalHits += m.get(HITS).longValue()) + m.get(MISSES).longValue();
            sumOfAllWrites += m.get(STORES).longValue();
        }
        if (sumOfAllWrites > 0L) {
            rwRatio = (double)sumOfAllReads / (double)sumOfAllWrites;
            hitRatio = (double)totalHits / (double)sumOfAllReads;
        }
        this.hitRatio = hitRatio;
        this.readWriteRatio = rwRatio;
    }

    private static <T extends AsyncInterceptor> T getFirstInterceptorWhichExtends(AdvancedCache<?, ?> cache, Class<T> interceptorClass) {
        return (T)((AsyncInterceptor)interceptorClass.cast(cache.getAsyncInterceptorChain().findInterceptorExtending(interceptorClass)));
    }

    private static CacheMode getCacheMode(Cache cache) {
        return cache.getCacheConfiguration().clustering().cacheMode();
    }

    private static class DistributedCacheStatsCallable
    implements DistributedCallable<Object, Object, Map<String, Number>>,
    Serializable {
        private static final long serialVersionUID = -8400973931071456798L;
        private transient AdvancedCache<Object, Object> remoteCache;

        private DistributedCacheStatsCallable() {
        }

        @Override
        public Map<String, Number> call() throws Exception {
            HashMap<String, Number> map = new HashMap<String, Number>();
            Stats stats = this.remoteCache.getStats();
            map.put(ClusterCacheStatsImpl.AVERAGE_READ_TIME, stats.getAverageReadTime());
            map.put(ClusterCacheStatsImpl.AVERAGE_WRITE_TIME, stats.getAverageWriteTime());
            map.put(ClusterCacheStatsImpl.AVERAGE_REMOVE_TIME, stats.getAverageRemoveTime());
            map.put(ClusterCacheStatsImpl.EVICTIONS, stats.getEvictions());
            map.put(ClusterCacheStatsImpl.HITS, stats.getHits());
            map.put(ClusterCacheStatsImpl.MISSES, stats.getMisses());
            CacheMode cacheMode = ClusterCacheStatsImpl.getCacheMode(this.remoteCache);
            if (cacheMode.isDistributed()) {
                map.put(ClusterCacheStatsImpl.NUMBER_OF_ENTRIES, stats.getCurrentNumberOfEntries() / this.numOwners());
            } else if (!cacheMode.isReplicated()) {
                map.put(ClusterCacheStatsImpl.NUMBER_OF_ENTRIES, stats.getCurrentNumberOfEntries());
            }
            map.put(ClusterCacheStatsImpl.OFF_HEAP_MEMORY_USED, stats.getOffHeapMemoryUsed());
            map.put(ClusterCacheStatsImpl.STORES, stats.getStores());
            map.put(ClusterCacheStatsImpl.REMOVE_HITS, stats.getRemoveHits());
            map.put(ClusterCacheStatsImpl.REMOVE_MISSES, stats.getRemoveMisses());
            map.put(ClusterCacheStatsImpl.TIME_SINCE_START, stats.getTimeSinceStart());
            LockManager lockManager = this.remoteCache.getLockManager();
            map.put(ClusterCacheStatsImpl.NUMBER_OF_LOCKS_HELD, lockManager.getNumberOfLocksHeld());
            map.put(ClusterCacheStatsImpl.NUMBER_OF_LOCKS_AVAILABLE, 0);
            InvalidationInterceptor invalidationInterceptor = (InvalidationInterceptor)ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(this.remoteCache, InvalidationInterceptor.class);
            if (invalidationInterceptor != null) {
                map.put(ClusterCacheStatsImpl.INVALIDATIONS, invalidationInterceptor.getInvalidations());
            } else {
                map.put(ClusterCacheStatsImpl.INVALIDATIONS, 0);
            }
            PassivationManager pManager = this.remoteCache.getComponentRegistry().getComponent(PassivationManager.class);
            if (pManager != null) {
                map.put(ClusterCacheStatsImpl.PASSIVATIONS, pManager.getPassivations());
            } else {
                map.put(ClusterCacheStatsImpl.PASSIVATIONS, 0);
            }
            ActivationManager aManager = this.remoteCache.getComponentRegistry().getComponent(ActivationManager.class);
            if (aManager != null) {
                map.put(ClusterCacheStatsImpl.ACTIVATIONS, aManager.getActivationCount());
            } else {
                map.put(ClusterCacheStatsImpl.ACTIVATIONS, 0);
            }
            CacheLoaderInterceptor aInterceptor = (CacheLoaderInterceptor)ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(this.remoteCache, CacheLoaderInterceptor.class);
            if (aInterceptor != null) {
                map.put(ClusterCacheStatsImpl.CACHE_LOADER_LOADS, aInterceptor.getCacheLoaderLoads());
                map.put(ClusterCacheStatsImpl.CACHE_LOADER_MISSES, aInterceptor.getCacheLoaderMisses());
            } else {
                map.put(ClusterCacheStatsImpl.CACHE_LOADER_LOADS, 0);
                map.put(ClusterCacheStatsImpl.CACHE_LOADER_MISSES, 0);
            }
            CacheWriterInterceptor interceptor = (CacheWriterInterceptor)ClusterCacheStatsImpl.getFirstInterceptorWhichExtends(this.remoteCache, CacheWriterInterceptor.class);
            if (interceptor != null) {
                map.put(ClusterCacheStatsImpl.CACHE_WRITER_STORES, interceptor.getWritesToTheStores());
            } else {
                map.put(ClusterCacheStatsImpl.CACHE_WRITER_STORES, 0);
            }
            return map;
        }

        @Override
        public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
            this.remoteCache = cache.getAdvancedCache();
        }

        private int numOwners() {
            return this.remoteCache.getCacheConfiguration().clustering().hash().numOwners();
        }
    }
}

