/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.UnicastHeader3;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.AverageMinMax;
import org.jgroups.util.ExpiryCache;
import org.jgroups.util.LongTuple;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SeqnoList;
import org.jgroups.util.Table;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.TimeService;
import org.jgroups.util.Util;

@MBean(description="Reliable unicast layer")
public class UNICAST3
extends Protocol
implements AgeOutCache.Handler<Address> {
    protected static final long DEFAULT_FIRST_SEQNO = 1L;
    @Property(description="Time (in milliseconds) after which an idle incoming or outgoing connection is closed. The connection will get re-established when used again. 0 disables connection reaping")
    protected long conn_expiry_timeout = 120000L;
    @Property(description="Time (in ms) until a connection marked to be closed will get removed. 0 disables this")
    protected long conn_close_timeout = 240000L;
    @Property(description="Number of rows of the matrix in the retransmission table (only for experts)", writable=false)
    protected int xmit_table_num_rows = 100;
    @Property(description="Number of elements of a row of the matrix in the retransmission table; gets rounded to the next power of 2 (only for experts). The capacity of the matrix is xmit_table_num_rows * xmit_table_msgs_per_row", writable=false)
    protected int xmit_table_msgs_per_row = 1024;
    @Property(description="Resize factor of the matrix in the retransmission table (only for experts)", writable=false)
    protected double xmit_table_resize_factor = 1.2;
    @Property(description="Number of milliseconds after which the matrix in the retransmission table is compacted (only for experts)", writable=false)
    protected long xmit_table_max_compaction_time = 600000L;
    protected long max_retransmit_time = 60000L;
    @Property(description="Interval (in milliseconds) at which messages in the send windows are resent")
    protected long xmit_interval = 500L;
    @Property(description="If true, trashes warnings about retransmission messages not found in the xmit_table (used for testing)")
    protected boolean log_not_found_msgs = true;
    @Property(description="Send an ack immediately when a batch of ack_threshold (or more) messages is received. Otherwise send delayed acks. If 1, ack single messages (similar to UNICAST)")
    protected int ack_threshold = 5;
    @Property(description="Min time (in ms) to elapse for successive SEND_FIRST_SEQNO messages to be sent to the same sender")
    protected long sync_min_interval = 2000L;
    @Property(description="Max number of messages to ask for in a retransmit request. 0 disables this and uses the max bundle size in the transport")
    protected int max_xmit_req_size;
    protected long num_msgs_sent = 0L;
    protected long num_msgs_received = 0L;
    protected long num_acks_sent = 0L;
    protected long num_acks_received = 0L;
    protected long num_xmits = 0L;
    @ManagedAttribute(description="Number of retransmit requests received")
    protected final LongAdder xmit_reqs_received = new LongAdder();
    @ManagedAttribute(description="Number of retransmit requests sent")
    protected final LongAdder xmit_reqs_sent = new LongAdder();
    @ManagedAttribute(description="Number of retransmit responses sent")
    protected final LongAdder xmit_rsps_sent = new LongAdder();
    protected final AverageMinMax avg_delivery_batch_size = new AverageMinMax();
    @ManagedAttribute(description="True if sending a message can block at the transport level")
    protected boolean sends_can_block = true;
    @ManagedAttribute(description="tracing is enabled or disabled for the given log", writable=true)
    protected boolean is_trace = this.log.isTraceEnabled();
    protected final ConcurrentMap<Address, SenderEntry> send_table = Util.createConcurrentMap();
    protected final ConcurrentMap<Address, ReceiverEntry> recv_table = Util.createConcurrentMap();
    protected final ReentrantLock recv_table_lock = new ReentrantLock();
    protected final Map<Address, Long> xmit_task_map = new HashMap<Address, Long>();
    protected Future<?> xmit_task;
    protected volatile List<Address> members = new ArrayList<Address>(11);
    protected Address local_addr;
    protected TimeScheduler timer;
    protected volatile boolean running = false;
    protected short last_conn_id;
    protected AgeOutCache<Address> cache;
    protected TimeService time_service;
    protected final AtomicInteger timestamper = new AtomicInteger(0);
    protected ExpiryCache<Address> last_sync_sent = null;
    protected static final Message DUMMY_OOB_MSG = new Message().setFlag(Message.Flag.OOB);
    protected final Predicate<Message> drop_oob_and_dont_loopback_msgs_filter = msg -> !(msg == null || msg == DUMMY_OOB_MSG || msg.isFlagSet(Message.Flag.OOB) && !msg.setTransientFlagIfAbsent(Message.TransientFlag.OOB_DELIVERED) || msg.isTransientFlagSet(Message.TransientFlag.DONT_LOOPBACK) && this.local_addr != null && this.local_addr.equals(msg.src()));
    protected static final Predicate<Message> dont_loopback_filter = msg -> msg != null && msg.isTransientFlagSet(Message.TransientFlag.DONT_LOOPBACK);
    protected static final BiConsumer<MessageBatch, Message> BATCH_ACCUMULATOR = MessageBatch::add;

    @ManagedAttribute
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getMembers() {
        return Util.printListWithDelimiter(this.members, ",");
    }

    @ManagedAttribute(description="Returns the number of outgoing (send) connections")
    public int getNumSendConnections() {
        return this.send_table.size();
    }

    @ManagedAttribute(description="Returns the number of incoming (receive) connections")
    public int getNumReceiveConnections() {
        return this.recv_table.size();
    }

    @ManagedAttribute(description="Returns the total number of outgoing (send) and incoming (receive) connections")
    public int getNumConnections() {
        return this.getNumReceiveConnections() + this.getNumSendConnections();
    }

    @ManagedAttribute(description="Next seqno issued by the timestamper")
    public int getTimestamper() {
        return this.timestamper.get();
    }

    @ManagedAttribute(description="Average batch size of messages removed from the table and delivered to the application")
    public String getAvgBatchDeliverySize() {
        return this.avg_delivery_batch_size != null ? this.avg_delivery_batch_size.toString() : "n/a";
    }

    @Override
    public <T extends Protocol> T setLevel(String level) {
        Object retval = super.setLevel(level);
        this.is_trace = this.log.isTraceEnabled();
        return retval;
    }

    @ManagedOperation
    public String printConnections() {
        StringBuilder sb = new StringBuilder();
        if (!this.send_table.isEmpty()) {
            sb.append("\nsend connections:\n");
            for (Map.Entry entry : this.send_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        if (!this.recv_table.isEmpty()) {
            sb.append("\nreceive connections:\n");
            for (Map.Entry entry : this.recv_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    @ManagedAttribute
    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    @ManagedAttribute
    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    @ManagedAttribute
    public long getNumAcksSent() {
        return this.num_acks_sent;
    }

    @ManagedAttribute
    public long getNumAcksReceived() {
        return this.num_acks_received;
    }

    @ManagedAttribute
    public long getNumXmits() {
        return this.num_xmits;
    }

    public long getMaxRetransmitTime() {
        return this.max_retransmit_time;
    }

    @Property(description="Max number of milliseconds we try to retransmit a message to any given member. After that, the connection is removed. Any new connection to that member will start with seqno #1 again. 0 disables this")
    public void setMaxRetransmitTime(long max_retransmit_time) {
        this.max_retransmit_time = max_retransmit_time;
        if (this.cache != null && max_retransmit_time > 0L) {
            this.cache.setTimeout(max_retransmit_time);
        }
    }

    @ManagedAttribute(description="Is the retransmit task running")
    public boolean isXmitTaskRunning() {
        return this.xmit_task != null && !this.xmit_task.isDone();
    }

    @ManagedAttribute
    public int getAgeOutCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    @ManagedOperation
    public String printAgeOutCache() {
        return this.cache != null ? this.cache.toString() : "n/a";
    }

    public AgeOutCache<Address> getAgeOutCache() {
        return this.cache;
    }

    public boolean hasSendConnectionTo(Address dest) {
        Entry entry = (Entry)this.send_table.get(dest);
        return entry != null && entry.state() == State.OPEN;
    }

    @ManagedAttribute
    public int getNumUnackedMessages() {
        int num = 0;
        for (Entry entry : this.send_table.values()) {
            if (entry.msgs == null) continue;
            num += entry.msgs.size();
        }
        return num;
    }

    @ManagedAttribute(description="Total number of undelivered messages in all receive windows")
    public long getXmitTableUndeliveredMessages() {
        long retval = 0L;
        for (Entry entry : this.recv_table.values()) {
            if (entry.msgs == null) continue;
            retval += (long)entry.msgs.size();
        }
        return retval;
    }

    @ManagedAttribute(description="Total number of missing messages in all receive windows")
    public long getXmitTableMissingMessages() {
        long retval = 0L;
        for (Entry entry : this.recv_table.values()) {
            if (entry.msgs == null) continue;
            retval += (long)entry.msgs.getNumMissing();
        }
        return retval;
    }

    @ManagedAttribute(description="Total number of deliverable messages in all receive windows")
    public int getXmitTableDeliverableMessages() {
        int retval = 0;
        for (Entry entry : this.recv_table.values()) {
            if (entry.msgs == null) continue;
            retval += entry.msgs.getNumDeliverable();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of compactions in all (receive and send) windows")
    public int getXmitTableNumCompactions() {
        int retval = 0;
        for (Entry entry : this.recv_table.values()) {
            if (entry.msgs == null) continue;
            retval += entry.msgs.getNumCompactions();
        }
        for (Entry entry : this.send_table.values()) {
            if (entry.msgs == null) continue;
            retval += entry.msgs.getNumCompactions();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of moves in all (receive and send) windows")
    public int getXmitTableNumMoves() {
        int retval = 0;
        for (Entry entry : this.recv_table.values()) {
            if (entry.msgs == null) continue;
            retval += entry.msgs.getNumMoves();
        }
        for (Entry entry : this.send_table.values()) {
            if (entry.msgs == null) continue;
            retval += entry.msgs.getNumMoves();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of resizes in all (receive and send) windows")
    public int getXmitTableNumResizes() {
        int retval = 0;
        for (Entry entry : this.recv_table.values()) {
            if (entry.msgs == null) continue;
            retval += entry.msgs.getNumResizes();
        }
        for (Entry entry : this.send_table.values()) {
            if (entry.msgs == null) continue;
            retval += entry.msgs.getNumResizes();
        }
        return retval;
    }

    @ManagedAttribute(description="Number of purges in all (receive and send) windows")
    public int getXmitTableNumPurges() {
        int retval = 0;
        for (Entry entry : this.recv_table.values()) {
            if (entry.msgs == null) continue;
            retval += entry.msgs.getNumPurges();
        }
        for (Entry entry : this.send_table.values()) {
            if (entry.msgs == null) continue;
            retval += entry.msgs.getNumPurges();
        }
        return retval;
    }

    @ManagedOperation(description="Prints the contents of the receive windows for all members")
    public String printReceiveWindowMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.recv_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            Table buf = ((ReceiverEntry)entry.getValue()).msgs;
            ret.append(addr).append(": ").append(buf.toString()).append('\n');
        }
        return ret.toString();
    }

    @ManagedOperation(description="Prints the contents of the send windows for all members")
    public String printSendWindowMessages() {
        StringBuilder ret = new StringBuilder(this.local_addr + ":\n");
        for (Map.Entry entry : this.send_table.entrySet()) {
            Address addr = (Address)entry.getKey();
            Table buf = ((SenderEntry)entry.getValue()).msgs;
            ret.append(addr).append(": ").append(buf.toString()).append('\n');
        }
        return ret.toString();
    }

    @Override
    public void resetStats() {
        this.num_xmits = 0L;
        this.num_acks_received = 0L;
        this.num_acks_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.avg_delivery_batch_size.clear();
    }

    @Override
    public void init() throws Exception {
        boolean regular_pool_enabled;
        super.init();
        TP transport = this.getTransport();
        this.sends_can_block = transport instanceof TCP;
        this.time_service = transport.getTimeService();
        if (this.time_service == null) {
            throw new IllegalStateException("time service from transport is null");
        }
        this.last_sync_sent = new ExpiryCache(this.sync_min_interval);
        int estimated_max_msgs_in_xmit_req = (transport.getMaxBundleSize() - 50) * 8;
        int old_max_xmit_size = this.max_xmit_req_size;
        this.max_xmit_req_size = this.max_xmit_req_size <= 0 ? estimated_max_msgs_in_xmit_req : Math.min(this.max_xmit_req_size, estimated_max_msgs_in_xmit_req);
        if (old_max_xmit_size != this.max_xmit_req_size) {
            this.log.trace("%s: set max_xmit_req_size from %d to %d", this.local_addr, old_max_xmit_size, this.max_xmit_req_size);
        }
        if (!(regular_pool_enabled = ((Boolean)transport.getValue("thread_pool_enabled")).booleanValue())) {
            this.log.info("the thread pool is disabled; %s could be removed (JGRP-2069)", this.getClass().getSimpleName());
        }
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.max_retransmit_time > 0L) {
            this.cache = new AgeOutCache(this.timer, this.max_retransmit_time, this);
        }
        this.running = true;
        this.startRetransmitTask();
    }

    @Override
    public void stop() {
        this.sendPendingAcks();
        this.running = false;
        this.stopRetransmitTask();
        this.xmit_task_map.clear();
        this.removeAllConnections();
    }

    @Override
    public Object up(Message msg) {
        if (msg.getDest() == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY)) {
            return this.up_prot.up(msg);
        }
        UnicastHeader3 hdr = (UnicastHeader3)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        Address sender = msg.getSrc();
        switch (hdr.type) {
            case 0: {
                if (this.is_trace) {
                    this.log.trace("%s <-- DATA(%s: #%d, conn_id=%d%s)", this.local_addr, sender, hdr.seqno, hdr.conn_id, hdr.first ? ", first" : "");
                }
                if (Objects.equals(this.local_addr, sender)) {
                    this.handleDataReceivedFromSelf(sender, hdr.seqno, msg);
                    break;
                }
                this.handleDataReceived(sender, hdr.seqno, hdr.conn_id, hdr.first, msg);
                break;
            }
            default: {
                this.handleUpEvent(sender, msg, hdr);
            }
        }
        return null;
    }

    protected void handleUpEvent(Address sender, Message msg, UnicastHeader3 hdr) {
        try {
            switch (hdr.type) {
                case 0: {
                    throw new IllegalStateException("header of type DATA is not supposed to be handled by this method");
                }
                case 1: {
                    this.handleAckReceived(sender, hdr.seqno, hdr.conn_id, hdr.timestamp());
                    break;
                }
                case 2: {
                    this.handleResendingOfFirstMessage(sender, hdr.timestamp());
                    break;
                }
                case 3: {
                    this.handleXmitRequest(sender, Util.streamableFromBuffer(SeqnoList.class, msg.getRawBuffer(), msg.getOffset(), msg.getLength()));
                    break;
                }
                case 4: {
                    this.log.trace(this.local_addr + "%s <-- CLOSE(%s: conn-id=%s)", this.local_addr, sender, hdr.conn_id);
                    ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(sender);
                    if (entry != null && entry.connId() == hdr.conn_id) {
                        this.recv_table.remove(sender, entry);
                        this.log.trace("%s: removed receive connection for %s", this.local_addr, sender);
                    }
                    break;
                }
                default: {
                    this.log.error(Util.getMessage("TypeNotKnown"), this.local_addr, hdr.type);
                    break;
                }
            }
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedHandlingEvent"), this.local_addr, t);
        }
    }

    @Override
    public void up(MessageBatch batch) {
        if (batch.dest() == null) {
            this.up_prot.up(batch);
            return;
        }
        if (this.local_addr == null || this.local_addr.equals(batch.sender())) {
            Entry entry;
            Entry entry2 = entry = this.local_addr != null ? (Entry)this.send_table.get(this.local_addr) : null;
            if (entry != null) {
                this.handleBatchFromSelf(batch, entry);
            }
            return;
        }
        int size = batch.size();
        LinkedHashMap<Short, ArrayList<LongTuple<Message>>> msgs = new LinkedHashMap<Short, ArrayList<LongTuple<Message>>>();
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(batch.sender());
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            UnicastHeader3 hdr;
            Message msg = it.next();
            if (msg == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY) || (hdr = (UnicastHeader3)msg.getHeader(this.id)) == null) continue;
            it.remove();
            if (hdr.type != 0) {
                this.handleUpEvent(msg.getSrc(), msg, hdr);
                continue;
            }
            ArrayList<LongTuple<Message>> list = (ArrayList<LongTuple<Message>>)msgs.get(hdr.conn_id);
            if (list == null) {
                list = new ArrayList<LongTuple<Message>>(size);
                msgs.put(hdr.conn_id, list);
            }
            list.add(new LongTuple<Message>(hdr.seqno(), msg));
            if (!hdr.first) continue;
            entry = this.getReceiverEntry(batch.sender(), hdr.seqno(), hdr.first, hdr.connId());
        }
        if (!msgs.isEmpty()) {
            if (entry == null) {
                this.sendRequestForFirstSeqno(batch.sender());
            } else {
                List list;
                if (msgs.keySet().retainAll(Collections.singletonList(entry.connId()))) {
                    this.sendRequestForFirstSeqno(batch.sender());
                }
                if ((list = (List)msgs.get(entry.connId())) != null && !list.isEmpty()) {
                    this.handleBatchReceived(entry, batch.sender(), list, batch.mode() == MessageBatch.Mode.OOB);
                }
            }
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    protected void handleBatchFromSelf(MessageBatch batch, Entry entry) {
        ArrayList<LongTuple<Message>> list = new ArrayList<LongTuple<Message>>(batch.size());
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            UnicastHeader3 hdr;
            Message msg = it.next();
            if (msg == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY) || (hdr = (UnicastHeader3)msg.getHeader(this.id)) == null) continue;
            it.remove();
            if (hdr.type != 0) {
                this.handleUpEvent(msg.getSrc(), msg, hdr);
                continue;
            }
            if (entry.conn_id != hdr.conn_id) {
                it.remove();
                continue;
            }
            list.add(new LongTuple<Message>(hdr.seqno(), msg));
        }
        if (!list.isEmpty()) {
            if (this.is_trace) {
                this.log.trace("%s <-- DATA(%s: %s)", this.local_addr, batch.sender(), this.printMessageList(list));
            }
            int len = list.size();
            Table<Message> win = entry.msgs;
            this.update(entry, len);
            if (batch.mode() == MessageBatch.Mode.OOB) {
                MessageBatch oob_batch = new MessageBatch(this.local_addr, batch.sender(), batch.clusterName(), batch.multicast(), MessageBatch.Mode.OOB, len);
                for (LongTuple longTuple : list) {
                    long seq = longTuple.getVal1();
                    Message msg = win.get(seq);
                    if (msg == null || !msg.isFlagSet(Message.Flag.OOB) || !msg.setTransientFlagIfAbsent(Message.TransientFlag.OOB_DELIVERED)) continue;
                    oob_batch.add(msg);
                }
                this.deliverBatch(oob_batch);
            }
            this.removeAndDeliver(win, batch.sender());
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View view = (View)evt.getArg();
                List<Address> new_members = view.getMembers();
                HashSet non_members = new HashSet(this.send_table.keySet());
                non_members.addAll(this.recv_table.keySet());
                this.members = new_members;
                non_members.removeAll(new_members);
                if (this.cache != null) {
                    this.cache.removeAll(new_members);
                }
                if (!non_members.isEmpty()) {
                    this.log.trace("%s: closing connections of non members %s", this.local_addr, non_members);
                    non_members.forEach(this::closeConnection);
                }
                if (!new_members.isEmpty()) {
                    for (Address mbr : new_members) {
                        Entry e = (Entry)this.send_table.get(mbr);
                        if (e != null && e.state() == State.CLOSING) {
                            e.state(State.OPEN);
                        }
                        if ((e = (Entry)this.recv_table.get(mbr)) == null || e.state() != State.CLOSING) continue;
                        e.state(State.OPEN);
                    }
                }
                this.xmit_task_map.keySet().retainAll(new_members);
                this.last_sync_sent.removeExpiredElements();
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object down(Message msg) {
        Address dst = msg.getDest();
        if (dst == null || msg.isFlagSet(Message.Flag.NO_RELIABILITY)) {
            return this.down_prot.down(msg);
        }
        if (!this.running) {
            this.log.trace("%s: discarded message as start() has not yet been called, message: %s", this.local_addr, msg);
            return null;
        }
        if (msg.src() == null) {
            msg.src(this.local_addr);
        }
        SenderEntry entry = this.getSenderEntry(dst);
        boolean dont_loopback_set = msg.isTransientFlagSet(Message.TransientFlag.DONT_LOOPBACK) && dst.equals(this.local_addr);
        short send_conn_id = entry.connId();
        long seqno = entry.sent_msgs_seqno.getAndIncrement();
        long sleep = 10L;
        while (true) {
            try {
                msg.putHeader(this.id, UnicastHeader3.createDataHeader(seqno, send_conn_id, seqno == 1L));
                entry.msgs.add(seqno, msg, dont_loopback_set ? dont_loopback_filter : null);
                if (this.conn_expiry_timeout > 0L) {
                    entry.update();
                }
                if (!dont_loopback_set) break;
                entry.msgs.purge(entry.msgs.getHighestDeliverable());
            }
            catch (Throwable t) {
                if (!this.running) continue;
                Util.sleep(sleep);
                sleep = Math.min(5000L, sleep * 2L);
                if (this.running) continue;
            }
            break;
        }
        if (this.is_trace) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(" --> DATA(").append(dst).append(": #").append(seqno).append(", conn_id=").append(send_conn_id);
            if (seqno == 1L) {
                sb.append(", first");
            }
            sb.append(')');
            this.log.trace(sb);
        }
        ++this.num_msgs_sent;
        return this.down_prot.down(msg);
    }

    public void closeConnection(Address mbr) {
        this.closeSendConnection(mbr);
        this.closeReceiveConnection(mbr);
    }

    public void closeSendConnection(Address mbr) {
        SenderEntry entry = (SenderEntry)this.send_table.get(mbr);
        if (entry != null) {
            entry.state(State.CLOSING);
        }
    }

    public void closeReceiveConnection(Address mbr) {
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(mbr);
        if (entry != null) {
            entry.state(State.CLOSING);
        }
    }

    protected void removeSendConnection(Address mbr) {
        SenderEntry entry = (SenderEntry)this.send_table.remove(mbr);
        if (entry != null) {
            entry.state(State.CLOSED);
            if (this.members.contains(mbr)) {
                this.sendClose(mbr, entry.connId());
            }
        }
    }

    protected void removeReceiveConnection(Address mbr) {
        this.sendPendingAcks();
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.remove(mbr);
        if (entry != null) {
            entry.state(State.CLOSED);
        }
    }

    @ManagedOperation(description="Trashes all connections to other nodes. This is only used for testing")
    public void removeAllConnections() {
        this.send_table.clear();
        this.recv_table.clear();
    }

    protected void retransmit(SeqnoList missing, Address sender) {
        Message xmit_msg = new Message(sender).setBuffer(Util.streamableToBuffer(missing)).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.id, UnicastHeader3.createXmitReqHeader());
        if (this.is_trace) {
            this.log.trace("%s: sending XMIT_REQ (%s) to %s", this.local_addr, missing, sender);
        }
        this.down_prot.down(xmit_msg);
        this.xmit_reqs_sent.add(missing.size());
    }

    protected void retransmit(Message msg) {
        if (this.is_trace) {
            UnicastHeader3 hdr = (UnicastHeader3)msg.getHeader(this.id);
            long seqno = hdr != null ? hdr.seqno : -1L;
            this.log.trace("%s --> XMIT(%s: #%d)", this.local_addr, msg.getDest(), seqno);
        }
        this.down_prot.down(msg);
        ++this.num_xmits;
    }

    @Override
    public void expired(Address key) {
        if (key != null) {
            this.log.debug("%s: removing connection to %s because it expired", this.local_addr, key);
            this.closeConnection(key);
        }
    }

    protected void handleDataReceived(Address sender, long seqno, short conn_id, boolean first, Message msg) {
        ReceiverEntry entry = this.getReceiverEntry(sender, seqno, first, conn_id);
        if (entry == null) {
            return;
        }
        this.update(entry, 1);
        boolean oob = msg.isFlagSet(Message.Flag.OOB);
        Table win = entry.msgs;
        boolean added = win.add(seqno, oob ? DUMMY_OOB_MSG : msg);
        if (this.ack_threshold <= 1) {
            this.sendAck(sender, win.getHighestDeliverable(), entry.connId());
        } else {
            entry.sendAck(true);
        }
        if (oob) {
            if (added) {
                this.deliverMessage(msg, sender, seqno);
            }
            if (msg.isFlagSet(Message.Flag.INTERNAL)) {
                this.processInternalMessage(win, sender);
                return;
            }
        }
        this.removeAndDeliver(win, sender);
    }

    protected void handleDataReceivedFromSelf(Address sender, long seqno, Message msg) {
        Entry entry = (Entry)this.send_table.get(sender);
        if (entry == null || entry.state() == State.CLOSED) {
            this.log.warn("%s: entry not found for %s; dropping message", this.local_addr, sender);
            return;
        }
        this.update(entry, 1);
        Table<Message> win = entry.msgs;
        if (msg.isFlagSet(Message.Flag.OOB)) {
            msg = win.get(seqno);
            if (msg != null && msg.isFlagSet(Message.Flag.OOB) && msg.setTransientFlagIfAbsent(Message.TransientFlag.OOB_DELIVERED)) {
                this.deliverMessage(msg, sender, seqno);
            }
            if (msg != null && msg.isFlagSet(Message.Flag.INTERNAL)) {
                this.processInternalMessage(win, sender);
                return;
            }
        }
        this.removeAndDeliver(win, sender);
    }

    protected void processInternalMessage(Table<Message> win, Address sender) {
        if (!win.isEmpty() && win.getAdders().get() == 0) {
            this.getTransport().submitToThreadPool(() -> this.removeAndDeliver(win, sender), true);
        }
    }

    protected void handleBatchReceived(ReceiverEntry entry, Address sender, List<LongTuple<Message>> msgs, boolean oob) {
        if (this.is_trace) {
            this.log.trace("%s <-- DATA(%s: %s)", this.local_addr, sender, this.printMessageList(msgs));
        }
        int batch_size = msgs.size();
        Table win = entry.msgs;
        boolean added = win.add(msgs, oob, oob ? DUMMY_OOB_MSG : null);
        this.update(entry, batch_size);
        if (batch_size >= this.ack_threshold) {
            this.sendAck(sender, win.getHighestDeliverable(), entry.connId());
        } else {
            entry.sendAck(true);
        }
        if (added && oob) {
            MessageBatch oob_batch = new MessageBatch(this.local_addr, sender, null, false, MessageBatch.Mode.OOB, msgs.size());
            for (LongTuple<Message> tuple : msgs) {
                oob_batch.add(tuple.getVal2());
            }
            this.deliverBatch(oob_batch);
        }
        this.removeAndDeliver(win, sender);
    }

    protected void removeAndDeliver(Table<Message> win, Address sender) {
        AtomicInteger adders = win.getAdders();
        if (adders.getAndIncrement() != 0) {
            return;
        }
        MessageBatch batch = new MessageBatch(win.getNumDeliverable()).dest(this.local_addr).sender(sender).multicast(false);
        Supplier<MessageBatch> batch_creator = () -> batch;
        do {
            try {
                batch.reset();
                win.removeMany(true, 0, this.drop_oob_and_dont_loopback_msgs_filter, batch_creator, BATCH_ACCUMULATOR);
            }
            catch (Throwable t) {
                this.log.error("failed removing messages from table for " + sender, t);
            }
            if (batch.isEmpty()) continue;
            if (this.stats) {
                this.avg_delivery_batch_size.add(batch.size());
            }
            this.deliverBatch(batch);
        } while (adders.decrementAndGet() != 0);
    }

    protected String printMessageList(List<LongTuple<Message>> list) {
        UnicastHeader3 hdr;
        Message second;
        StringBuilder sb = new StringBuilder();
        int size = list.size();
        Message first = size > 0 ? list.get(0).getVal2() : null;
        Message message = second = size > 1 ? list.get(size - 1).getVal2() : first;
        if (first != null && (hdr = (UnicastHeader3)first.getHeader(this.id)) != null) {
            sb.append("#" + hdr.seqno);
        }
        if (second != null && (hdr = (UnicastHeader3)second.getHeader(this.id)) != null) {
            sb.append(" - #" + hdr.seqno);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReceiverEntry getReceiverEntry(Address sender, long seqno, boolean first, short conn_id) {
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(sender);
        if (entry != null && entry.connId() == conn_id) {
            return entry;
        }
        this.recv_table_lock.lock();
        try {
            entry = (ReceiverEntry)this.recv_table.get(sender);
            if (first) {
                if (entry == null) {
                    entry = this.createReceiverEntry(sender, seqno, conn_id);
                } else if (conn_id != entry.connId()) {
                    this.log.trace("%s: conn_id=%d != %d; resetting receiver window", this.local_addr, conn_id, entry.connId());
                    this.recv_table.remove(sender);
                    entry = this.createReceiverEntry(sender, seqno, conn_id);
                }
            } else if (entry == null || entry.connId() != conn_id) {
                this.recv_table_lock.unlock();
                this.sendRequestForFirstSeqno(sender);
                ReceiverEntry receiverEntry = null;
                return receiverEntry;
            }
            ReceiverEntry receiverEntry = entry;
            return receiverEntry;
        }
        finally {
            if (this.recv_table_lock.isHeldByCurrentThread()) {
                this.recv_table_lock.unlock();
            }
        }
    }

    protected SenderEntry getSenderEntry(Address dst) {
        SenderEntry entry = (SenderEntry)this.send_table.get(dst);
        if (entry == null || entry.state() == State.CLOSED) {
            SenderEntry existing;
            if (entry != null) {
                this.send_table.remove(dst, entry);
            }
            if ((existing = this.send_table.putIfAbsent(dst, entry = new SenderEntry(this.getNewConnectionId()))) != null) {
                entry = existing;
            } else {
                this.log.trace("%s: created sender window for %s (conn-id=%s)", this.local_addr, dst, entry.connId());
                if (this.cache != null && !this.members.contains(dst)) {
                    this.cache.add(dst);
                }
            }
        }
        if (entry.state() == State.CLOSING) {
            entry.state(State.OPEN);
        }
        return entry;
    }

    protected ReceiverEntry createReceiverEntry(Address sender, long seqno, short conn_id) {
        Table<Message> table = new Table<Message>(this.xmit_table_num_rows, this.xmit_table_msgs_per_row, seqno - 1L, this.xmit_table_resize_factor, this.xmit_table_max_compaction_time);
        ReceiverEntry entry = new ReceiverEntry(table, conn_id);
        ReceiverEntry entry2 = this.recv_table.putIfAbsent(sender, entry);
        if (entry2 != null) {
            return entry2;
        }
        this.log.trace("%s: created receiver window for %s at seqno=#%d for conn-id=%d", this.local_addr, sender, seqno, conn_id);
        return entry;
    }

    protected void handleAckReceived(Address sender, long seqno, short conn_id, int timestamp) {
        Table win;
        SenderEntry entry;
        if (this.is_trace) {
            this.log.trace("%s <-- ACK(%s: #%d, conn-id=%d, ts=%d)", this.local_addr, sender, seqno, conn_id, timestamp);
        }
        if ((entry = (SenderEntry)this.send_table.get(sender)) != null && entry.connId() != conn_id) {
            this.log.trace("%s: my conn_id (%d) != received conn_id (%d); discarding ACK", this.local_addr, entry.connId(), conn_id);
            return;
        }
        Table table = win = entry != null ? entry.msgs : null;
        if (win != null && entry.updateLastTimestamp(timestamp)) {
            win.purge(seqno, true);
            ++this.num_acks_received;
        }
    }

    protected void handleResendingOfFirstMessage(Address sender, int timestamp) {
        Table win;
        this.log.trace("%s <-- SEND_FIRST_SEQNO(%s)", this.local_addr, sender);
        SenderEntry entry = (SenderEntry)this.send_table.get(sender);
        Table table = win = entry != null ? entry.msgs : null;
        if (win == null) {
            this.log.warn(Util.getMessage("SenderNotFound"), this.local_addr, sender);
            return;
        }
        if (!entry.updateLastTimestamp(timestamp)) {
            return;
        }
        Message rsp = (Message)win.get(win.getLow() + 1L);
        if (rsp != null) {
            Message copy = rsp.copy();
            UnicastHeader3 hdr = (UnicastHeader3)copy.getHeader(this.id);
            UnicastHeader3 newhdr = hdr.copy();
            newhdr.first = true;
            copy.putHeader(this.id, newhdr);
            this.down_prot.down(copy);
        }
    }

    protected void handleXmitRequest(Address sender, SeqnoList missing) {
        Table win;
        if (this.is_trace) {
            this.log.trace("%s <-- XMIT(%s: #%s)", this.local_addr, sender, missing);
        }
        SenderEntry entry = (SenderEntry)this.send_table.get(sender);
        this.xmit_reqs_received.add(missing.size());
        Table table = win = entry != null ? entry.msgs : null;
        if (win != null) {
            for (long seqno : missing) {
                Message msg = (Message)win.get(seqno);
                if (msg == null) {
                    if (!this.log.isWarnEnabled() || !this.log_not_found_msgs || this.local_addr.equals(sender) || seqno <= win.getLow()) continue;
                    this.log.warn(Util.getMessage("MessageNotFound"), this.local_addr, sender, seqno);
                    continue;
                }
                this.down_prot.down(msg);
                this.xmit_rsps_sent.increment();
            }
        }
    }

    protected void deliverMessage(Message msg, Address sender, long seqno) {
        if (this.is_trace) {
            this.log.trace("%s: delivering %s#%s", this.local_addr, sender, seqno);
        }
        try {
            this.up_prot.up(msg);
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedToDeliverMsg"), this.local_addr, msg.isFlagSet(Message.Flag.OOB) ? "OOB message" : "message", msg, t);
        }
    }

    protected void deliverBatch(MessageBatch batch) {
        try {
            if (batch.isEmpty()) {
                return;
            }
            if (this.is_trace) {
                Message first = batch.first();
                Message last = batch.last();
                StringBuilder sb = new StringBuilder(this.local_addr + ": delivering");
                if (first != null && last != null) {
                    UnicastHeader3 hdr1 = (UnicastHeader3)first.getHeader(this.id);
                    UnicastHeader3 hdr2 = (UnicastHeader3)last.getHeader(this.id);
                    sb.append(" #").append(hdr1.seqno).append(" - #").append(hdr2.seqno);
                }
                sb.append(" (" + batch.size()).append(" messages)");
                this.log.trace(sb);
            }
            this.up_prot.up(batch);
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedToDeliverMsg"), this.local_addr, "batch", batch, t);
        }
    }

    protected long getTimestamp() {
        return this.time_service.timestamp();
    }

    protected void startRetransmitTask() {
        if (this.xmit_task == null || this.xmit_task.isDone()) {
            this.xmit_task = this.timer.scheduleWithFixedDelay(new RetransmitTask(), 0L, this.xmit_interval, TimeUnit.MILLISECONDS, this.sends_can_block);
        }
    }

    protected void stopRetransmitTask() {
        if (this.xmit_task != null) {
            this.xmit_task.cancel(true);
            this.xmit_task = null;
        }
    }

    protected void sendAck(Address dst, long seqno, short conn_id) {
        if (!this.running) {
            return;
        }
        Message ack = new Message(dst).setFlag(Message.Flag.INTERNAL).putHeader(this.id, UnicastHeader3.createAckHeader(seqno, conn_id, this.timestamper.incrementAndGet()));
        if (this.is_trace) {
            this.log.trace("%s --> ACK(%s: #%d)", this.local_addr, dst, seqno);
        }
        try {
            this.down_prot.down(ack);
            ++this.num_acks_sent;
        }
        catch (Throwable t) {
            this.log.error(Util.getMessage("FailedSendingAck"), this.local_addr, seqno, dst, t);
        }
    }

    protected synchronized short getNewConnectionId() {
        short retval = this.last_conn_id;
        this.last_conn_id = this.last_conn_id >= Short.MAX_VALUE || this.last_conn_id < 0 ? (short)0 : (short)(this.last_conn_id + 1);
        return retval;
    }

    protected void sendRequestForFirstSeqno(Address dest) {
        if (this.last_sync_sent.addIfAbsentOrExpired(dest)) {
            Message msg = new Message(dest).setFlag(Message.Flag.OOB).putHeader(this.id, UnicastHeader3.createSendFirstSeqnoHeader(this.timestamper.incrementAndGet()));
            this.log.trace("%s --> SEND_FIRST_SEQNO(%s)", this.local_addr, dest);
            this.down_prot.down(msg);
        }
    }

    public void sendClose(Address dest, short conn_id) {
        Message msg = new Message(dest).setFlag(Message.Flag.INTERNAL).putHeader(this.id, UnicastHeader3.createCloseHeader(conn_id));
        this.log.trace("%s --> CLOSE(%s, conn-id=%d)", this.local_addr, dest, conn_id);
        this.down_prot.down(msg);
    }

    @ManagedOperation(description="Closes connections that have been idle for more than conn_expiry_timeout ms")
    public void closeIdleConnections() {
        long age;
        Entry val;
        for (Map.Entry entry : this.send_table.entrySet()) {
            val = (SenderEntry)entry.getValue();
            if (val.state() != State.OPEN || (age = val.age()) < this.conn_expiry_timeout) continue;
            this.log.debug("%s: closing expired connection for %s (%d ms old) in send_table", this.local_addr, entry.getKey(), age);
            this.closeSendConnection((Address)entry.getKey());
        }
        for (Map.Entry entry : this.recv_table.entrySet()) {
            val = (ReceiverEntry)entry.getValue();
            if (val.state() != State.OPEN || (age = val.age()) < this.conn_expiry_timeout) continue;
            this.log.debug("%s: closing expired connection for %s (%d ms old) in recv_table", this.local_addr, entry.getKey(), age);
            this.closeReceiveConnection((Address)entry.getKey());
        }
    }

    @ManagedOperation(description="Removes connections that have been closed for more than conn_close_timeout ms")
    public int removeExpiredConnections() {
        long age;
        Entry val;
        int num_removed = 0;
        for (Map.Entry entry : this.send_table.entrySet()) {
            val = (SenderEntry)entry.getValue();
            if (val.state() == State.OPEN || (age = val.age()) < this.conn_close_timeout) continue;
            this.log.debug("%s: removing expired connection for %s (%d ms old) from send_table", this.local_addr, entry.getKey(), age);
            this.removeSendConnection((Address)entry.getKey());
            ++num_removed;
        }
        for (Map.Entry entry : this.recv_table.entrySet()) {
            val = (ReceiverEntry)entry.getValue();
            if (val.state() == State.OPEN || (age = val.age()) < this.conn_close_timeout) continue;
            this.log.debug("%s: removing expired connection for %s (%d ms old) from recv_table", this.local_addr, entry.getKey(), age);
            this.removeReceiveConnection((Address)entry.getKey());
            ++num_removed;
        }
        return num_removed;
    }

    protected void update(Entry entry, int num_received) {
        if (this.conn_expiry_timeout > 0L) {
            entry.update();
        }
        if (entry.state() == State.CLOSING) {
            entry.state(State.OPEN);
        }
        this.num_msgs_received += (long)num_received;
    }

    protected static int compare(int ts1, int ts2) {
        int diff = ts1 - ts2;
        return diff < 0 ? -1 : (diff > 0 ? 1 : 0);
    }

    @ManagedOperation(description="Triggers the retransmission task")
    public void triggerXmit() {
        for (Map.Entry entry : this.recv_table.entrySet()) {
            SeqnoList missing;
            Table win;
            Address target = (Address)entry.getKey();
            ReceiverEntry val = (ReceiverEntry)entry.getValue();
            Table table = win = val != null ? val.msgs : null;
            if (win != null && val.sendAck()) {
                this.sendAck(target, win.getHighestDeliverable(), val.connId());
            }
            if (win != null && win.getNumMissing() > 0 && (missing = win.getMissing(this.max_xmit_req_size)) != null) {
                long highest = missing.getLast();
                Long prev_seqno = this.xmit_task_map.get(target);
                if (prev_seqno == null) {
                    this.xmit_task_map.put(target, highest);
                    continue;
                }
                missing.removeHigherThan(prev_seqno);
                if (highest > prev_seqno) {
                    this.xmit_task_map.put(target, highest);
                }
                if (missing.isEmpty()) continue;
                this.retransmit(missing, target);
                continue;
            }
            if (this.xmit_task_map.isEmpty()) continue;
            this.xmit_task_map.remove(target);
        }
        for (SenderEntry val : this.send_table.values()) {
            long highest_sent;
            Table win = val != null ? val.msgs : null;
            if (win == null) continue;
            long highest_acked = win.getHighestDelivered();
            if (highest_acked < (highest_sent = win.getHighestReceived()) && val.watermark[0] == highest_acked && val.watermark[1] == highest_sent) {
                Message highest_sent_msg = (Message)win.get(highest_sent);
                if (highest_sent_msg == null) continue;
                this.retransmit(highest_sent_msg);
                continue;
            }
            val.watermark(highest_acked, highest_sent);
        }
        if (this.conn_expiry_timeout > 0L) {
            this.closeIdleConnections();
        }
        if (this.conn_close_timeout > 0L) {
            this.removeExpiredConnections();
        }
    }

    @ManagedOperation(description="Sends ACKs immediately for entries which are marked as pending (ACK hasn't been sent yet)")
    public void sendPendingAcks() {
        for (Map.Entry entry : this.recv_table.entrySet()) {
            Address target = (Address)entry.getKey();
            ReceiverEntry val = (ReceiverEntry)entry.getValue();
            Table win = val != null ? val.msgs : null;
            if (win == null || !val.sendAck()) continue;
            this.sendAck(target, win.getHighestDeliverable(), val.connId());
        }
    }

    protected class RetransmitTask
    implements Runnable {
        protected RetransmitTask() {
        }

        @Override
        public void run() {
            UNICAST3.this.triggerXmit();
        }

        public String toString() {
            return UNICAST3.class.getSimpleName() + ": RetransmitTask (interval=" + UNICAST3.this.xmit_interval + " ms)";
        }
    }

    protected final class ReceiverEntry
    extends Entry {
        protected volatile boolean send_ack;

        public ReceiverEntry(Table<Message> received_msgs, short recv_conn_id) {
            super(recv_conn_id, received_msgs);
        }

        ReceiverEntry sendAck(boolean flag) {
            this.send_ack = flag;
            return this;
        }

        boolean sendAck() {
            boolean retval = this.send_ack;
            this.send_ack = false;
            return retval;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.msgs != null) {
                sb.append(this.msgs).append(", ");
            }
            sb.append("recv_conn_id=" + this.conn_id).append(" (" + this.age() / 1000L + " secs old) - " + (Object)((Object)this.state));
            if (this.send_ack) {
                sb.append(" [ack pending]");
            }
            return sb.toString();
        }
    }

    protected final class SenderEntry
    extends Entry {
        final AtomicLong sent_msgs_seqno;
        protected final long[] watermark;
        protected int last_timestamp;

        public SenderEntry(short send_conn_id) {
            super(send_conn_id, new Table<Message>(UNICAST3.this.xmit_table_num_rows, UNICAST3.this.xmit_table_msgs_per_row, 0L, UNICAST3.this.xmit_table_resize_factor, UNICAST3.this.xmit_table_max_compaction_time));
            this.sent_msgs_seqno = new AtomicLong(1L);
            this.watermark = new long[]{0L, 0L};
        }

        long[] watermark() {
            return this.watermark;
        }

        SenderEntry watermark(long ha, long hs) {
            this.watermark[0] = ha;
            this.watermark[1] = hs;
            return this;
        }

        protected synchronized boolean updateLastTimestamp(int ts) {
            boolean success;
            if (this.last_timestamp == 0) {
                this.last_timestamp = ts;
                return true;
            }
            boolean bl = success = UNICAST3.compare(ts, this.last_timestamp) > 0;
            if (success) {
                this.last_timestamp = ts;
            }
            return success;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.msgs != null) {
                sb.append(this.msgs).append(", ");
            }
            sb.append("send_conn_id=" + this.conn_id).append(" (" + this.age() / 1000L + " secs old) - " + (Object)((Object)this.state));
            if (this.last_timestamp != 0) {
                sb.append(", last-ts: ").append(this.last_timestamp);
            }
            return sb.toString();
        }
    }

    protected abstract class Entry {
        protected final Table<Message> msgs;
        protected final short conn_id;
        protected final AtomicLong timestamp = new AtomicLong(0L);
        protected volatile State state = State.OPEN;

        protected Entry(short conn_id, Table<Message> msgs) {
            this.conn_id = conn_id;
            this.msgs = msgs;
            this.update();
        }

        short connId() {
            return this.conn_id;
        }

        void update() {
            this.timestamp.set(UNICAST3.this.getTimestamp());
        }

        State state() {
            return this.state;
        }

        Entry state(State state) {
            if (this.state != state) {
                this.state = state;
                this.update();
            }
            return this;
        }

        long age() {
            return TimeUnit.MILLISECONDS.convert(UNICAST3.this.getTimestamp() - this.timestamp.longValue(), TimeUnit.NANOSECONDS);
        }
    }

    protected static enum State {
        OPEN,
        CLOSING,
        CLOSED;

    }
}

