/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.List;
import org.jgroups.Message;
import org.jgroups.util.Util;

public class ParseMessages {
    public static List<Message> parse(byte[] buf, int offset, int length) {
        return Util.parse(new ByteArrayInputStream(buf, offset, length));
    }

    public static List<Message> parse(String filename) throws FileNotFoundException {
        return Util.parse(new FileInputStream(filename));
    }

    public static void main(String[] args) throws FileNotFoundException {
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-file")) {
                ParseMessages.help();
                return;
            }
            file = args[++i];
        }
        List<Message> msgs = ParseMessages.parse(file);
        int cnt = 1;
        for (Message msg : msgs) {
            System.out.println(cnt++ + ": " + msg + ", hdrs: " + msg.printHeaders());
        }
    }

    private static void help() {
        System.out.println("ParseMessages [-file <filename>]");
    }
}

