/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenizerDefinition;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class SimpleElasticsearchAnalysisDefinitionRegistry
implements ElasticsearchAnalysisDefinitionRegistry {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final Map<String, AnalyzerDefinition> analyzerDefinitions = new TreeMap<String, AnalyzerDefinition>();
    private final Map<String, TokenizerDefinition> tokenizerDefinitions = new TreeMap<String, TokenizerDefinition>();
    private final Map<String, TokenFilterDefinition> tokenFilterDefinitions = new TreeMap<String, TokenFilterDefinition>();
    private final Map<String, CharFilterDefinition> charFilterDefinitions = new TreeMap<String, CharFilterDefinition>();

    @Override
    public void register(String name, AnalyzerDefinition definition) {
        AnalyzerDefinition previous = this.analyzerDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw LOG.analyzerNamingConflict(name);
        }
    }

    @Override
    public void register(String name, TokenizerDefinition definition) {
        TokenizerDefinition previous = this.tokenizerDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw LOG.tokenizerNamingConflict(name);
        }
    }

    @Override
    public void register(String name, TokenFilterDefinition definition) {
        TokenFilterDefinition previous = this.tokenFilterDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw LOG.tokenFilterNamingConflict(name);
        }
    }

    @Override
    public void register(String name, CharFilterDefinition definition) {
        CharFilterDefinition previous = this.charFilterDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw LOG.charFilterNamingConflict(name);
        }
    }

    @Override
    public AnalyzerDefinition getAnalyzerDefinition(String name) {
        return this.analyzerDefinitions.get(name);
    }

    @Override
    public TokenizerDefinition getTokenizerDefinition(String name) {
        return this.tokenizerDefinitions.get(name);
    }

    @Override
    public TokenFilterDefinition getTokenFilterDefinition(String name) {
        return this.tokenFilterDefinitions.get(name);
    }

    @Override
    public CharFilterDefinition getCharFilterDefinition(String name) {
        return this.charFilterDefinitions.get(name);
    }

    public Map<String, AnalyzerDefinition> getAnalyzerDefinitions() {
        return Collections.unmodifiableMap(this.analyzerDefinitions);
    }

    public Map<String, TokenizerDefinition> getTokenizerDefinitions() {
        return Collections.unmodifiableMap(this.tokenizerDefinitions);
    }

    public Map<String, TokenFilterDefinition> getTokenFilterDefinitions() {
        return Collections.unmodifiableMap(this.tokenFilterDefinitions);
    }

    public Map<String, CharFilterDefinition> getCharFilterDefinitions() {
        return Collections.unmodifiableMap(this.charFilterDefinitions);
    }
}

