/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.sort.Sort;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.spatial.Coordinates;

public class DistanceSort
extends Sort {
    private static final String GEO_DISTANCE_FIELD = "_geo_distance";
    private Coordinates center;
    private String fieldName;

    public DistanceSort(String fieldName, Coordinates center, Sort.Sorting order) {
        super(GEO_DISTANCE_FIELD, order);
        this.fieldName = fieldName;
        this.center = center;
    }

    public JsonObject toJsonObject() {
        JsonObject rootObject = super.toJsonObject();
        JsonObject gsonDistanceFieldObject = rootObject.getAsJsonObject(GEO_DISTANCE_FIELD);
        JsonBuilder.object(gsonDistanceFieldObject).add(this.fieldName, (JsonElement)JsonBuilder.object().addProperty("lat", this.center.getLatitude()).addProperty("lon", this.center.getLongitude()).build()).addProperty("unit", "km").addProperty("distance_type", "arc");
        return rootObject;
    }
}

