/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.settings.impl.model;

import com.google.gson.GsonBuilder;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalysisDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinitionJsonAdapterFactory;

@JsonAdapter(value=AnalyzerDefinitionJsonAdapterFactory.class)
public class AnalyzerDefinition
extends AnalysisDefinition {
    private String tokenizer;
    @SerializedName(value="filter")
    private List<String> tokenFilters;
    @SerializedName(value="char_filter")
    private List<String> charFilters;

    public String getTokenizer() {
        return this.tokenizer;
    }

    public void setTokenizer(String tokenizer) {
        this.tokenizer = tokenizer;
    }

    public List<String> getTokenFilters() {
        return this.tokenFilters;
    }

    public void setTokenFilters(List<String> tokenFilters) {
        this.tokenFilters = tokenFilters;
    }

    public void addTokenFilter(String tokenFilter) {
        this.getInitializedTokenFilters().add(tokenFilter);
    }

    private List<String> getInitializedTokenFilters() {
        if (this.tokenFilters == null) {
            this.tokenFilters = new ArrayList<String>();
        }
        return this.tokenFilters;
    }

    public List<String> getCharFilters() {
        return this.charFilters;
    }

    public void setCharFilters(List<String> charFilters) {
        this.charFilters = charFilters;
    }

    public void addCharFilter(String charFilter) {
        this.getInitializedCharFilters().add(charFilter);
    }

    private List<String> getInitializedCharFilters() {
        if (this.charFilters == null) {
            this.charFilters = new ArrayList<String>();
        }
        return this.charFilters;
    }

    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }
}

