/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl;

import java.util.Map;
import java.util.Properties;
import org.hibernate.search.backend.impl.PerTransactionWorker;
import org.hibernate.search.backend.impl.QueueingProcessor;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public abstract class WorkerFactory {
    public static Worker createWorker(SearchConfiguration searchConfiguration, WorkerBuildContext buildContext, QueueingProcessor queueingProcessor) {
        Properties properties = WorkerFactory.getProperties(searchConfiguration);
        String workerImplClassName = properties.getProperty("hibernate.search.worker.scope");
        Worker worker = StringHelper.isEmpty(workerImplClassName) || "transaction".equalsIgnoreCase(workerImplClassName) ? new PerTransactionWorker() : WorkerFactory.instantiateExplicitlyConfiguredWorker(buildContext, workerImplClassName);
        worker.initialize(properties, buildContext, queueingProcessor);
        return worker;
    }

    private static Worker instantiateExplicitlyConfiguredWorker(WorkerBuildContext buildContext, String workerImplClassName) {
        ServiceManager serviceManager = buildContext.getServiceManager();
        return ClassLoaderHelper.instanceFromName(Worker.class, workerImplClassName, "worker", serviceManager);
    }

    private static Properties getProperties(SearchConfiguration searchConfiguration) {
        Properties props = searchConfiguration.getProperties();
        Properties workerProperties = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("hibernate.search.worker")) continue;
            workerProperties.setProperty(key, (String)entry.getValue());
        }
        return workerProperties;
    }
}

