/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spi;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesFacetField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.annotations.FieldCacheType;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingCalendarBridge;
import org.hibernate.search.bridge.builtin.NumericEncodingDateBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.StringEncodingDateBridge;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.bridge.util.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.impl.FacetHandling;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.DocumentFieldPath;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.FacetMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.nesting.impl.DefaultNestingContextFactory;
import org.hibernate.search.engine.nesting.impl.NestingContext;
import org.hibernate.search.engine.nesting.impl.NestingContextFactory;
import org.hibernate.search.engine.nesting.impl.NestingContextFactoryProvider;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.EntityState;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.impl.InternalAnalyzerUtils;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DocumentBuilderIndexedEntity
extends AbstractDocumentBuilder {
    public static final String TENANT_ID_FIELDNAME = "__HSearch_TenantId";
    private static final Log log = LoggerFactory.make();
    private static final LuceneOptions NULL_EMBEDDED_MARKER_OPTIONS;
    private static final FieldType TENANT_ID_FIELDTYPE;
    private boolean allowFieldSelectionInProjection = false;
    private boolean idProvided;
    private final String idPropertyName;
    private final String idFieldName;
    private PropertyMetadata idPropertyMetadata;
    private NestingContextFactory nestingContextFactory;

    public DocumentBuilderIndexedEntity(XClass clazz, TypeMetadata typeMetadata, ConfigContext context, ReflectionManager reflectionManager, Set<XClass> optimizationBlackList, InstanceInitializer instanceInitializer) {
        super(clazz, typeMetadata, reflectionManager, optimizationBlackList, instanceInitializer);
        ProvidedId providedIdAnnotation = this.findProvidedId(clazz, reflectionManager);
        if (providedIdAnnotation != null || context.isProvidedIdImplicit()) {
            this.idProvided = true;
        }
        if (this.idPropertyMetadata == null) {
            this.idPropertyMetadata = this.getTypeMetadata().getIdPropertyMetadata();
        }
        if (this.idPropertyMetadata == null) {
            throw log.noDocumentIdFoundException(clazz.getName());
        }
        this.idFieldName = this.idPropertyMetadata.getFieldMetadataSet().iterator().next().getAbsoluteName();
        this.checkAllowFieldSelection();
        if (log.isDebugEnabled()) {
            log.debugf("Field selection in projections is set to %b for entity %s.", this.allowFieldSelectionInProjection, clazz);
        }
        this.entityState = EntityState.INDEXED;
        this.idPropertyName = this.idProvided ? null : this.idPropertyMetadata.getPropertyAccessor().getName();
        this.nestingContextFactory = DocumentBuilderIndexedEntity.getNestingContextFactory(context);
    }

    private static NestingContextFactory getNestingContextFactory(ConfigContext context) {
        try {
            NestingContextFactoryProvider nestingContextFactoryProvider = context.getServiceManager().requestService(NestingContextFactoryProvider.class);
            NestingContextFactory nestingContextFactory = nestingContextFactoryProvider.getNestingContextFactory();
            return nestingContextFactory;
        }
        catch (Exception e) {
            NestingContextFactory nestingContextFactory = DefaultNestingContextFactory.INSTANCE;
            return nestingContextFactory;
        }
        finally {
            context.getServiceManager().releaseService(NestingContextFactoryProvider.class);
        }
    }

    public XMember getIdGetter() {
        return this.idPropertyMetadata.getPropertyAccessor();
    }

    private ProvidedId findProvidedId(XClass clazz, ReflectionManager reflectionManager) {
        ProvidedId id = null;
        XClass currentClass = clazz;
        while (id == null && !reflectionManager.equals(currentClass, Object.class)) {
            id = (ProvidedId)currentClass.getAnnotation(ProvidedId.class);
            currentClass = currentClass.getSuperclass();
        }
        return id;
    }

    @Override
    public void addWorkToQueue(String tenantId, Class<?> entityClass, Object entity, Serializable id, boolean delete, boolean add, List<LuceneWork> queue, ConversionContext contextualBridge) {
        DocumentFieldMetadata idFieldMetadata = this.idPropertyMetadata.getFieldMetadata(this.idFieldName);
        String idInString = this.objectToString(this.getIdBridge(), idFieldMetadata.getAbsoluteName(), (Object)id, contextualBridge);
        if (delete && !add) {
            queue.add(new DeleteLuceneWork(tenantId, id, idInString, entityClass));
        } else if (add && !delete) {
            queue.add(this.createAddWork(tenantId, entityClass, entity, id, idInString, this.getInstanceInitializer(), contextualBridge));
        } else if (add && delete) {
            queue.add(this.createUpdateWork(tenantId, entityClass, entity, id, idInString, this.getInstanceInitializer(), contextualBridge));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String objectToString(TwoWayFieldBridge bridge, String fieldName, Object value, ConversionContext conversionContext) {
        String stringValue;
        conversionContext.pushProperty(fieldName);
        try {
            stringValue = conversionContext.setClass(this.getBeanClass()).twoWayConversionContext(bridge).objectToString(value);
        }
        finally {
            conversionContext.popProperty();
        }
        return stringValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String objectToString(StringBridge bridge, String fieldName, Object value, ConversionContext conversionContext) {
        String stringValue;
        conversionContext.pushProperty(fieldName);
        try {
            stringValue = conversionContext.setClass(this.getBeanClass()).stringConversionContext(bridge).objectToString(value);
        }
        finally {
            conversionContext.popProperty();
        }
        return stringValue;
    }

    public AddLuceneWork createAddWork(String tenantId, Class<?> entityClass, Object entity, Serializable id, String idInString, InstanceInitializer sessionInitializer, ConversionContext conversionContext) {
        HashMap<String, String> fieldToAnalyzerMap = new HashMap<String, String>();
        Document doc = this.getDocument(tenantId, entity, id, fieldToAnalyzerMap, sessionInitializer, conversionContext, null);
        AddLuceneWork addWork = fieldToAnalyzerMap.isEmpty() ? new AddLuceneWork(tenantId, id, idInString, entityClass, doc) : new AddLuceneWork(tenantId, id, idInString, entityClass, doc, fieldToAnalyzerMap);
        return addWork;
    }

    public UpdateLuceneWork createUpdateWork(String tenantId, Class entityClass, Object entity, Serializable id, String idInString, InstanceInitializer sessionInitializer, ConversionContext contextualBridge) {
        HashMap<String, String> fieldToAnalyzerMap = new HashMap<String, String>();
        Document doc = this.getDocument(tenantId, entity, id, fieldToAnalyzerMap, sessionInitializer, contextualBridge, null);
        UpdateLuceneWork addWork = fieldToAnalyzerMap.isEmpty() ? new UpdateLuceneWork(tenantId, id, idInString, entityClass, doc) : new UpdateLuceneWork(tenantId, id, idInString, entityClass, doc, fieldToAnalyzerMap);
        return addWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(String tenantId, Object instance, Serializable id, Map<String, String> fieldToAnalyzerMap, InstanceInitializer objectInitializer, ConversionContext conversionContext, String[] includedFieldNames) {
        if (fieldToAnalyzerMap == null) {
            throw new IllegalArgumentException("fieldToAnalyzerMap cannot be null");
        }
        if (objectInitializer == null) {
            objectInitializer = this.getInstanceInitializer();
        }
        Document doc = new Document();
        FacetHandling faceting = new FacetHandling();
        Class<Object> entityType = objectInitializer.getClass(instance);
        float documentLevelBoost = this.getMetadata().getClassBoost(instance);
        if (this.containsFieldName("_hibernate_class", includedFieldNames)) {
            Field classField = new Field("_hibernate_class", entityType.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO);
            doc.add((IndexableField)classField);
        }
        this.addTenantIdIfRequired(tenantId, doc);
        if (this.containsFieldName(this.idFieldName, includedFieldNames)) {
            DocumentFieldMetadata idFieldMetaData = this.idPropertyMetadata.getFieldMetadata(this.idFieldName);
            LuceneOptionsImpl luceneOptions = new LuceneOptionsImpl(idFieldMetaData, idFieldMetaData.getBoost().floatValue(), documentLevelBoost);
            FieldBridge contextualizedBridge = conversionContext.oneWayConversionContext(this.getIdBridge());
            conversionContext.setClass(entityType);
            if (this.idPropertyName != null) {
                conversionContext.pushProperty(this.idPropertyName);
            }
            try {
                contextualizedBridge.set(idFieldMetaData.getAbsoluteName(), id, doc, luceneOptions);
                this.addSortFieldDocValues(doc, this.idPropertyMetadata, documentLevelBoost, id);
            }
            finally {
                if (this.idPropertyName != null) {
                    conversionContext.popProperty();
                }
            }
        }
        HashSet<String> processedFieldNames = new HashSet<String>();
        this.buildDocumentFields(instance, doc, faceting, this.getMetadata(), fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, documentLevelBoost, false, this.nestingContextFactory.createNestingContext(this.getTypeMetadata().getType()));
        doc = faceting.build(doc);
        return doc;
    }

    private void addTenantIdIfRequired(String tenantId, Document doc) {
        if (tenantId != null) {
            Field tenantIdField = new Field(TENANT_ID_FIELDNAME, tenantId, TENANT_ID_FIELDTYPE);
            doc.add((IndexableField)tenantIdField);
        }
    }

    private static FieldType createTenantIdFieldType() {
        FieldType type = new FieldType();
        type.setStored(false);
        type.setOmitNorms(true);
        type.setIndexOptions(IndexOptions.DOCS);
        type.setTokenized(false);
        type.setStoreTermVectorOffsets(false);
        type.setStoreTermVectorPayloads(false);
        type.setStoreTermVectorPositions(false);
        type.setStoreTermVectors(false);
        type.freeze();
        return type;
    }

    private void buildDocumentFields(Object instance, Document doc, FacetHandling faceting, TypeMetadata typeMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames, ConversionContext conversionContext, InstanceInitializer objectInitializer, float inheritedBoost, boolean isParentPropertyMultiValued, NestingContext nestingContext) {
        Object unproxiedInstance = this.unproxy(instance, objectInitializer);
        this.buildDocumentFieldForClassBridges(doc, typeMetadata, conversionContext, inheritedBoost, unproxiedInstance);
        this.buildDocumentFieldsForProperties(doc, faceting, typeMetadata, conversionContext, objectInitializer, inheritedBoost, unproxiedInstance, isParentPropertyMultiValued);
        this.allowAnalyzerDiscriminatorOverride(doc, typeMetadata, fieldToAnalyzerMap, processedFieldNames, unproxiedInstance);
        this.buildDocumentFieldsForEmbeddedObjects(doc, faceting, typeMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, inheritedBoost, unproxiedInstance, isParentPropertyMultiValued, nestingContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Iterators could be improved
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void buildDocumentFieldsForEmbeddedObjects(Document doc, FacetHandling faceting, TypeMetadata typeMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames, ConversionContext conversionContext, InstanceInitializer objectInitializer, float inheritedBoost, Object unproxiedInstance, boolean isParentPropertyMultiValued, NestingContext nestingContext) {
lbl1:
        // 7 sources

        block10: for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            member = embeddedTypeMetadata.getEmbeddedGetter();
            embeddedBoost = inheritedBoost * embeddedTypeMetadata.getStaticBoost();
            conversionContext.pushProperty(embeddedTypeMetadata.getEmbeddedPropertyName());
            nestingContext.push(embeddedTypeMetadata);
            try {
                value = ReflectionHelper.getMemberValue(unproxiedInstance, member);
                if (value == null) {
                    nestingContext.mark(doc);
                    this.processEmbeddedNullValue(doc, embeddedTypeMetadata, conversionContext);
                    continue;
                }
                switch (1.$SwitchMap$org$hibernate$search$engine$metadata$impl$EmbeddedTypeMetadata$Container[embeddedTypeMetadata.getEmbeddedContainer().ordinal()]) {
                    case 1: {
                        if (value instanceof Object[]) {
                            objectInitializer.initializeArray((Object[])value);
                        }
                        for (Iterator<T> arrayValue : CollectionHelper.iterableFromArray(value)) {
                            nestingContext.mark(doc);
                            this.buildDocumentFields(arrayValue /* !! */ , doc, faceting, embeddedTypeMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, embeddedBoost, true, nestingContext);
                            nestingContext.incrementCollectionIndex();
                        }
                        continue block10;
                    }
                    case 2: {
                        collection = objectInitializer.initializeCollection((Collection)value);
                        arrayValue /* !! */  = collection.iterator();
                        while (arrayValue /* !! */ .hasNext()) {
                            collectionValue = arrayValue /* !! */ .next();
                            nestingContext.mark(doc);
                            this.buildDocumentFields(collectionValue, doc, faceting, embeddedTypeMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, embeddedBoost, true, nestingContext);
                            nestingContext.incrementCollectionIndex();
                        }
                        continue block10;
                    }
                    case 3: {
                        map = objectInitializer.initializeMap((Map)value);
                        for (V collectionValue : map.values()) {
                            nestingContext.mark(doc);
                            this.buildDocumentFields(collectionValue, doc, faceting, embeddedTypeMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, embeddedBoost, true, nestingContext);
                            nestingContext.incrementCollectionIndex();
                        }
                        continue block10;
                    }
                    case 4: {
                        nestingContext.mark(doc);
                        this.buildDocumentFields(value, doc, faceting, embeddedTypeMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer, embeddedBoost, isParentPropertyMultiValued, nestingContext);
                        ** break;
                    }
                    default: {
                        throw new AssertionFailure("Unknown embedded container: " + (Object)embeddedTypeMetadata.getEmbeddedContainer());
                    }
                }
            }
            finally {
                conversionContext.popProperty();
                nestingContext.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildDocumentFieldsForProperties(Document document, FacetHandling faceting, TypeMetadata typeMetadata, ConversionContext conversionContext, InstanceInitializer objectInitializer, float documentBoost, Object unproxiedInstance, boolean isParentPropertyMultiValued) {
        XProperty previousMember = null;
        Object currentFieldValue = null;
        for (PropertyMetadata propertyMetadata : typeMetadata.getAllPropertyMetadata()) {
            XProperty member = propertyMetadata.getPropertyAccessor();
            if (previousMember != member) {
                currentFieldValue = this.unproxy(ReflectionHelper.getMemberValue(unproxiedInstance, (XMember)member), objectInitializer);
                previousMember = member;
                if (member.isCollection()) {
                    if (currentFieldValue instanceof Collection) {
                        objectInitializer.initializeCollection((Collection)currentFieldValue);
                    } else if (currentFieldValue instanceof Map) {
                        objectInitializer.initializeMap((Map)currentFieldValue);
                    }
                } else if (member.isArray() && currentFieldValue instanceof Object[]) {
                    objectInitializer.initializeArray((Object[])currentFieldValue);
                }
            }
            try {
                conversionContext.pushProperty(propertyMetadata.getPropertyAccessorName());
                for (DocumentFieldMetadata fieldMetadata : propertyMetadata.getFieldMetadataSet()) {
                    FieldBridge fieldBridge = fieldMetadata.getFieldBridge();
                    String fieldName = fieldMetadata.getAbsoluteName();
                    FieldBridge oneWayConversionContext = conversionContext.oneWayConversionContext(fieldBridge);
                    oneWayConversionContext.set(fieldName, currentFieldValue, document, typeMetadata.getFieldLuceneOptions(propertyMetadata, fieldMetadata, currentFieldValue, documentBoost));
                    if (!fieldMetadata.hasFacets()) continue;
                    faceting.enableFacetProcessing();
                    for (FacetMetadata facetMetadata : fieldMetadata.getFacetMetadata()) {
                        boolean multiValued = isParentPropertyMultiValued;
                        if (member.isCollection() && currentFieldValue instanceof Collection) {
                            multiValued = true;
                            for (Object element : (Collection)currentFieldValue) {
                                this.addFacetDocValues(document, fieldMetadata, facetMetadata, element);
                            }
                        } else if (member.isCollection() && currentFieldValue instanceof Map) {
                            multiValued = true;
                            for (Object element : ((Map)currentFieldValue).values()) {
                                this.addFacetDocValues(document, fieldMetadata, facetMetadata, element);
                            }
                        } else if (member.isArray()) {
                            multiValued = true;
                            for (Object element : CollectionHelper.iterableFromArray(currentFieldValue)) {
                                this.addFacetDocValues(document, fieldMetadata, facetMetadata, element);
                            }
                        } else {
                            this.addFacetDocValues(document, fieldMetadata, facetMetadata, currentFieldValue);
                        }
                        if (!multiValued) continue;
                        faceting.setMultiValued(facetMetadata.getAbsoluteName());
                    }
                }
                if (isParentPropertyMultiValued) continue;
                this.addSortFieldDocValues(document, propertyMetadata, documentBoost, currentFieldValue);
            }
            finally {
                conversionContext.popProperty();
            }
        }
    }

    private void addFacetDocValues(Document document, DocumentFieldMetadata fieldMetadata, FacetMetadata facetMetadata, Object value) {
        NumericDocValuesField facetField;
        if (value == null) {
            return;
        }
        switch (facetMetadata.getEncoding()) {
            case STRING: {
                String stringValue = value.toString();
                if (stringValue.isEmpty()) {
                    return;
                }
                facetField = new SortedSetDocValuesFacetField(facetMetadata.getAbsoluteName(), stringValue);
                break;
            }
            case LONG: {
                if (value instanceof Number) {
                    facetField = new NumericDocValuesField(facetMetadata.getAbsoluteName(), ((Number)value).longValue());
                    break;
                }
                if (Date.class.isAssignableFrom(value.getClass())) {
                    Date date = (Date)value;
                    FieldBridge fieldBridge = fieldMetadata.getFieldBridge();
                    if (fieldBridge instanceof NumericEncodingDateBridge) {
                        NumericEncodingDateBridge dateBridge = (NumericEncodingDateBridge)fieldBridge;
                        long numericDateValue = DateTools.round((long)date.getTime(), (DateTools.Resolution)dateBridge.getResolution());
                        facetField = new NumericDocValuesField(facetMetadata.getAbsoluteName(), numericDateValue);
                        break;
                    }
                    if (fieldBridge instanceof TwoWayFieldBridge) {
                        facetField = new SortedSetDocValuesFacetField(facetMetadata.getAbsoluteName(), ((TwoWayFieldBridge)fieldBridge).objectToString(value));
                        break;
                    }
                    throw log.numericDateFacetForNonNumericField(facetMetadata.getAbsoluteName(), fieldMetadata.getAbsoluteName());
                }
                if (Calendar.class.isAssignableFrom(value.getClass())) {
                    Calendar calendar = (Calendar)value;
                    facetField = new NumericDocValuesField(facetMetadata.getAbsoluteName(), calendar.getTime().getTime());
                    break;
                }
                throw new AssertionFailure("Unexpected value type for faceting: " + value.getClass().getName());
            }
            case DOUBLE: {
                if (value instanceof Number) {
                    facetField = new DoubleDocValuesField(facetMetadata.getAbsoluteName(), ((Number)value).doubleValue());
                    break;
                }
                throw new AssertionFailure("Unexpected value type for faceting: " + value.getClass().getName());
            }
            case AUTO: {
                throw new AssertionFailure("The facet type should have been resolved during bootstrapping");
            }
            default: {
                throw new AssertionFailure("Unexpected facet encoding type '" + (Object)((Object)facetMetadata.getEncoding()) + "' Has the enum been modified?");
            }
        }
        document.add((IndexableField)facetField);
    }

    private void addSortFieldDocValues(Document document, PropertyMetadata propertyMetadata, float documentBoost, Object propertyValue) {
        for (SortableFieldMetadata sortField : propertyMetadata.getSortableFieldMetadata()) {
            IndexableField field;
            if (propertyMetadata.getDeclaringType().getBridgeDefinedFieldMetadataFor(sortField.getAbsoluteName()) != null) continue;
            DocumentFieldMetadata fieldMetaData = propertyMetadata.getFieldMetadata(sortField.getAbsoluteName());
            if (fieldMetaData == null) {
                throw new AssertionFailure("A sortable field did not match neither an @Field nor a bridge-defined field");
            }
            if (fieldMetaData.getIndex() == Field.Index.NO && fieldMetaData.getStore() == Store.NO) {
                FieldBridge fieldBridge = fieldMetaData.getFieldBridge();
                NullMarker nullMarker = fieldMetaData.getNullMarkerCodec().getNullMarker();
                LuceneOptionsImpl luceneOptions = new LuceneOptionsImpl(Field.Index.NOT_ANALYZED, fieldMetaData.getTermVector(), fieldMetaData.getStore(), nullMarker == null ? null : nullMarker.nullRepresentedAsString(), fieldMetaData.getBoost().floatValue() * propertyMetadata.getDynamicBoostStrategy().defineBoost(propertyValue), documentBoost);
                Document dummy = new Document();
                fieldBridge.set("dummy", propertyValue, dummy, luceneOptions);
                field = dummy.getField("dummy");
            } else {
                field = document.getField(sortField.getAbsoluteName());
            }
            if (field == null) continue;
            Number numericValue = field.numericValue();
            if (numericValue != null) {
                if (numericValue instanceof Double) {
                    document.add((IndexableField)new DoubleDocValuesField(sortField.getAbsoluteName(), ((Double)numericValue).doubleValue()));
                    continue;
                }
                if (numericValue instanceof Float) {
                    document.add((IndexableField)new FloatDocValuesField(sortField.getAbsoluteName(), ((Float)numericValue).floatValue()));
                    continue;
                }
                document.add((IndexableField)new NumericDocValuesField(sortField.getAbsoluteName(), numericValue.longValue()));
                continue;
            }
            String value = field.stringValue();
            AnalyzerReference analyzerReference = fieldMetaData.getAnalyzerReference();
            if (fieldMetaData.getIndex().isAnalyzed() && analyzerReference.is(LuceneAnalyzerReference.class)) {
                Analyzer analyzer = analyzerReference.unwrap(LuceneAnalyzerReference.class).getAnalyzer();
                value = InternalAnalyzerUtils.analyzeSortableValue(analyzer, sortField.getAbsoluteName(), value);
            }
            if (value == null) continue;
            document.add((IndexableField)new SortedDocValuesField(sortField.getAbsoluteName(), new BytesRef((CharSequence)value)));
        }
    }

    private void buildDocumentFieldForClassBridges(Document doc, TypeMetadata typeMetadata, ConversionContext conversionContext, float documentBoost, Object unproxiedInstance) {
        for (DocumentFieldMetadata fieldMetadata : typeMetadata.getClassBridgeMetadata()) {
            FieldBridge fieldBridge = fieldMetadata.getFieldBridge();
            String fieldName = fieldMetadata.getAbsoluteName();
            FieldBridge oneWayConversionContext = conversionContext.oneWayConversionContext(fieldBridge);
            oneWayConversionContext.set(fieldName, unproxiedInstance, doc, typeMetadata.getClassLuceneOptions(fieldMetadata, documentBoost));
        }
    }

    private boolean containsFieldName(String value, String[] array) {
        if (array == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        for (String containedValue : array) {
            if (!value.equals(containedValue)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEmbeddedNullValue(Document doc, EmbeddedTypeMetadata embeddedTypeMetadata, ConversionContext conversionContext) {
        String nullMarker = embeddedTypeMetadata.getEmbeddedNullToken();
        if (nullMarker != null) {
            String fieldName = embeddedTypeMetadata.getEmbeddedNullFieldName();
            FieldBridge fieldBridge = embeddedTypeMetadata.getEmbeddedNullFieldBridge();
            FieldBridge contextualizedBridge = conversionContext.oneWayConversionContext(fieldBridge);
            conversionContext.pushProperty(fieldName);
            try {
                contextualizedBridge.set(fieldName, null, doc, NULL_EMBEDDED_MARKER_OPTIONS);
            }
            finally {
                conversionContext.popProperty();
            }
        }
    }

    private Object unproxy(Object instance, InstanceInitializer objectInitializer) {
        if (instance == null) {
            return null;
        }
        return objectInitializer.unproxy(instance);
    }

    private void allowAnalyzerDiscriminatorOverride(Document doc, TypeMetadata typeMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames, Object unproxiedInstance) {
        Discriminator discriminator = typeMetadata.getDiscriminator();
        if (discriminator == null) {
            return;
        }
        Object value = null;
        if (typeMetadata.getDiscriminatorGetter() != null) {
            value = ReflectionHelper.getMemberValue(unproxiedInstance, typeMetadata.getDiscriminatorGetter());
        }
        for (IndexableField field : doc.getFields()) {
            if (processedFieldNames.contains(field.name())) continue;
            String analyzerName = discriminator.getAnalyzerDefinitionName(value, unproxiedInstance, field.name());
            if (analyzerName != null) {
                fieldToAnalyzerMap.put(field.name(), analyzerName);
            }
            processedFieldNames.add(field.name());
        }
    }

    public String getIdPropertyName() {
        return this.idPropertyName;
    }

    public boolean allowFieldSelectionInProjection() {
        return this.allowFieldSelectionInProjection;
    }

    @Deprecated
    public Set<FieldCacheType> getFieldCacheOption() {
        return Collections.emptySet();
    }

    public TwoWayFieldBridge getIdBridge() {
        return (TwoWayFieldBridge)this.idPropertyMetadata.getFieldMetadata(this.idFieldName).getFieldBridge();
    }

    public String getIdFieldName() {
        return this.idPropertyMetadata.getFieldMetadata(this.idFieldName).getAbsoluteName();
    }

    @Override
    public Serializable getId(Object entity) {
        if (entity == null || this.idPropertyMetadata.getPropertyAccessorName() == null || this.idProvided) {
            throw new IllegalStateException("Cannot guess id from entity");
        }
        Object unproxiedEntity = this.getInstanceInitializer().unproxy(entity);
        return (Serializable)ReflectionHelper.getMemberValue(unproxiedEntity, (XMember)this.idPropertyMetadata.getPropertyAccessor());
    }

    public String objectToString(String fieldName, Object value, ConversionContext conversionContext) {
        TwoWayFieldBridge bridge;
        if (fieldName == null) {
            throw new AssertionFailure("Field name should not be null");
        }
        FieldBridge fieldBridge = bridge = fieldName.equals(this.getIdFieldName()) ? this.getIdBridge() : this.getBridge(this.getMetadata(), fieldName);
        if (bridge != null) {
            return this.objectToString(fieldName, bridge, value, conversionContext);
        }
        throw new SearchException("Unable to find field " + fieldName + " in " + this.getBeanXClass());
    }

    public String objectToString(String fieldName, FieldBridge bridge, Object value, ConversionContext conversionContext) {
        if (fieldName == null) {
            throw new AssertionFailure("Field name should not be null");
        }
        if (bridge == null) {
            throw new AssertionFailure("Field bridge should not be null");
        }
        Class<?> bridgeClass = bridge.getClass();
        if (TwoWayFieldBridge.class.isAssignableFrom(bridgeClass)) {
            return this.objectToString((TwoWayFieldBridge)bridge, fieldName, value, conversionContext);
        }
        if (StringBridge.class.isAssignableFrom(bridgeClass)) {
            return this.objectToString((StringBridge)((Object)bridge), fieldName, value, conversionContext);
        }
        throw log.fieldBridgeNotTwoWay(bridgeClass, fieldName, this.getBeanXClass());
    }

    private FieldBridge getNullBridge(EmbeddedTypeMetadata embeddedTypeMetadata, String fieldName) {
        if (fieldName.equals(embeddedTypeMetadata.getEmbeddedNullFieldName())) {
            return embeddedTypeMetadata.getEmbeddedNullFieldBridge();
        }
        return null;
    }

    public FieldBridge getBridge(String fieldName) {
        return this.getBridge(this.getMetadata(), fieldName);
    }

    private FieldBridge getBridge(TypeMetadata typeMetadata, String fieldName) {
        FieldBridge fieldBridge;
        DocumentFieldMetadata documentFieldMetadata = typeMetadata.getDocumentFieldMetadataFor(fieldName);
        if (documentFieldMetadata != null && documentFieldMetadata.getFieldBridge() != null) {
            return documentFieldMetadata.getFieldBridge();
        }
        for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            fieldBridge = this.getBridge(embeddedTypeMetadata, fieldName);
            if (fieldBridge == null) continue;
            return fieldBridge;
        }
        for (EmbeddedTypeMetadata embeddedTypeMetadata : typeMetadata.getEmbeddedTypeMetadata()) {
            fieldBridge = this.getNullBridge(embeddedTypeMetadata, fieldName);
            if (fieldBridge == null) continue;
            return fieldBridge;
        }
        DocumentFieldMetadata fieldMetadata = typeMetadata.getFieldMetadataForClassBridgeField(fieldName);
        fieldBridge = fieldMetadata == null ? null : fieldMetadata.getFieldBridge();
        return fieldBridge;
    }

    private void checkAllowFieldSelection() {
        this.allowFieldSelectionInProjection = true;
        if (this.fieldBridgeProhibitsFieldSelectionInProjection(this.getIdBridge())) {
            this.allowFieldSelectionInProjection = false;
            return;
        }
        for (PropertyMetadata propertyMetadata : this.getMetadata().getAllPropertyMetadata()) {
            for (DocumentFieldMetadata documentFieldMetadata : propertyMetadata.getFieldMetadataSet()) {
                FieldBridge bridge = documentFieldMetadata.getFieldBridge();
                if (!this.fieldBridgeProhibitsFieldSelectionInProjection(bridge)) continue;
                this.allowFieldSelectionInProjection = false;
                return;
            }
        }
        for (DocumentFieldMetadata fieldMetadata : this.getMetadata().getClassBridgeMetadata()) {
            FieldBridge bridge = fieldMetadata.getFieldBridge();
            if (!this.fieldBridgeProhibitsFieldSelectionInProjection(bridge)) continue;
            this.allowFieldSelectionInProjection = false;
            return;
        }
    }

    private boolean fieldBridgeProhibitsFieldSelectionInProjection(FieldBridge bridge) {
        return !(bridge instanceof TwoWayStringBridge) && !(bridge instanceof TwoWayString2FieldBridgeAdaptor) && !(bridge instanceof NumericFieldBridge) && !(bridge instanceof NumericEncodingCalendarBridge) && !(bridge instanceof NumericEncodingDateBridge) && !(bridge instanceof StringEncodingDateBridge);
    }

    @Override
    public boolean requiresProvidedId() {
        return this.idProvided;
    }

    @Override
    public boolean isIdMatchingJpaId() {
        return !this.idProvided && this.getTypeMetadata().isJpaIdUsedAsDocumentId();
    }

    static {
        DocumentFieldMetadata fieldMetadata = new DocumentFieldMetadata.Builder(BackReference.empty(), BackReference.empty(), new DocumentFieldPath("", ""), Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO).boost(Float.valueOf(1.0f)).build();
        NULL_EMBEDDED_MARKER_OPTIONS = new LuceneOptionsImpl(fieldMetadata, 1.0f, 1.0f);
        TENANT_ID_FIELDTYPE = DocumentBuilderIndexedEntity.createTenantIdFieldType();
    }
}

