/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.dsl.PhraseTermination;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.PhraseQueryContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.RemotePhraseQuery;

public class ConnectedMultiFieldsPhraseQueryBuilder
implements PhraseTermination {
    private final PhraseQueryContext phraseContext;
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final List<FieldContext> fieldContexts;

    public ConnectedMultiFieldsPhraseQueryBuilder(PhraseQueryContext phraseContext, QueryCustomizer queryCustomizer, List<FieldContext> fieldContexts, QueryBuildingContext queryContext) {
        this.phraseContext = phraseContext;
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.fieldContexts = fieldContexts;
    }

    @Override
    public Query createQuery() {
        int size = this.fieldContexts.size();
        if (size == 1) {
            return this.queryCustomizer.setWrappedQuery(this.createQuery(this.fieldContexts.get(0))).createQuery();
        }
        BooleanQuery.Builder aggregatedFieldsQueryBuilder = new BooleanQuery.Builder();
        for (FieldContext fieldContext : this.fieldContexts) {
            aggregatedFieldsQueryBuilder.add(this.createQuery(fieldContext), BooleanClause.Occur.SHOULD);
        }
        BooleanQuery aggregatedFieldsQuery = aggregatedFieldsQueryBuilder.build();
        return this.queryCustomizer.setWrappedQuery((Query)aggregatedFieldsQuery).createQuery();
    }

    public Query createQuery(FieldContext fieldContext) {
        RemotePhraseQuery perFieldQuery;
        String fieldName = fieldContext.getField();
        String sentence = this.phraseContext.getSentence();
        if (this.queryContext.getQueryAnalyzerReference().is(RemoteAnalyzerReference.class)) {
            perFieldQuery = new RemotePhraseQuery(fieldName, this.phraseContext.getSlop(), sentence, this.queryContext.getQueryAnalyzerReference().unwrap(RemoteAnalyzerReference.class));
        } else {
            List value;
            MultiPhraseQuery query;
            Analyzer analyzer = this.queryContext.getQueryAnalyzerReference().unwrap(LuceneAnalyzerReference.class).getAnalyzer();
            TokenStream stream = null;
            boolean isMultiPhrase = false;
            TreeMap termsPerPosition = new TreeMap();
            try {
                StringReader reader = new StringReader(sentence);
                stream = analyzer.tokenStream(fieldName, (Reader)reader);
                CharTermAttribute termAttribute = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
                PositionIncrementAttribute positionAttribute = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
                stream.reset();
                int position = -1;
                List<Term> termsAtSamePosition = null;
                while (stream.incrementToken()) {
                    int positionIncrement = 1;
                    if (positionAttribute != null) {
                        positionIncrement = positionAttribute.getPositionIncrement();
                    }
                    if (positionIncrement > 0) {
                        termsAtSamePosition = (List)termsPerPosition.get(position += positionIncrement);
                    }
                    if (termsAtSamePosition == null) {
                        termsAtSamePosition = new ArrayList();
                        termsPerPosition.put(position, termsAtSamePosition);
                    }
                    String termString = new String(termAttribute.buffer(), 0, termAttribute.length());
                    termsAtSamePosition.add(new Term(fieldName, termString));
                    if (termsAtSamePosition.size() <= 1) continue;
                    isMultiPhrase = true;
                }
            }
            catch (IOException e) {
                throw new AssertionFailure("IOException while reading a string. Doh!", e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.end();
                        stream.close();
                    }
                    catch (IOException e) {
                        throw new AssertionFailure("IOException while reading a string. Doh!", e);
                    }
                }
            }
            int size = termsPerPosition.size();
            if (size == 0) {
                perFieldQuery = new BooleanQuery.Builder().build();
            } else if (size <= 1) {
                List terms = (List)termsPerPosition.values().iterator().next();
                if (terms.size() == 1) {
                    perFieldQuery = new TermQuery((Term)terms.get(0));
                } else {
                    BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
                    for (Term term : terms) {
                        booleanQueryBuilder.add((Query)new TermQuery(term), BooleanClause.Occur.SHOULD);
                    }
                    perFieldQuery = booleanQueryBuilder.build();
                }
            } else if (isMultiPhrase) {
                query = new MultiPhraseQuery();
                query.setSlop(this.phraseContext.getSlop());
                for (Map.Entry entry : termsPerPosition.entrySet()) {
                    value = (List)entry.getValue();
                    query.add(value.toArray(new Term[value.size()]), ((Integer)entry.getKey()).intValue());
                }
                perFieldQuery = query;
            } else {
                query = new PhraseQuery();
                query.setSlop(this.phraseContext.getSlop());
                for (Map.Entry entry : termsPerPosition.entrySet()) {
                    value = (List)entry.getValue();
                    query.add((Term)value.get(0), ((Integer)entry.getKey()).intValue());
                }
                perFieldQuery = query;
            }
        }
        return fieldContext.getFieldCustomizer().setWrappedQuery(perFieldQuery).createQuery();
    }
}

