/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedSubgraph;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.LoadState;
import javax.persistence.spi.PersistenceUnitTransactionType;
import org.hibernate.Cache;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.annotations.NamedEntityGraphDefinition;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedQueryDefinitionBuilder;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinitionBuilder;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jpa.HibernateQuery;
import org.hibernate.jpa.boot.internal.SettingsImpl;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.graph.internal.AbstractGraphNode;
import org.hibernate.jpa.graph.internal.AttributeNodeImpl;
import org.hibernate.jpa.graph.internal.EntityGraphImpl;
import org.hibernate.jpa.graph.internal.SubgraphImpl;
import org.hibernate.jpa.internal.EntityManagerFactoryRegistry;
import org.hibernate.jpa.internal.EntityManagerImpl;
import org.hibernate.jpa.internal.StoredProcedureQueryImpl;
import org.hibernate.jpa.internal.metamodel.EntityTypeImpl;
import org.hibernate.jpa.internal.metamodel.MetamodelImpl;
import org.hibernate.jpa.internal.util.PersistenceUtilHelper;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.procedure.ProcedureCall;
import org.jboss.logging.Logger;

public class EntityManagerFactoryImpl
implements HibernateEntityManagerFactory {
    private static final long serialVersionUID = 5423543L;
    private static final IdentifierGenerator UUID_GENERATOR = UUIDGenerator.buildSessionFactoryUniqueIdentifierGenerator();
    private static final Logger log = Logger.getLogger(EntityManagerFactoryImpl.class);
    private final transient SessionFactoryImplementor sessionFactory;
    private final transient PersistenceUnitTransactionType transactionType;
    private final transient boolean discardOnClose;
    private final transient Class sessionInterceptorClass;
    private final transient CriteriaBuilderImpl criteriaBuilder;
    private final transient MetamodelImpl metamodel;
    private final transient HibernatePersistenceUnitUtil util;
    private final transient Map<String, Object> properties;
    private final String entityManagerFactoryName;
    private final transient PersistenceUtilHelper.MetadataCache cache = new PersistenceUtilHelper.MetadataCache();
    private final transient Map<String, EntityGraphImpl> entityGraphs = new ConcurrentHashMap<String, EntityGraphImpl>();

    public EntityManagerFactoryImpl(String persistenceUnitName, SessionFactoryImplementor sessionFactory, MetadataImplementor metadata, SettingsImpl settings, Map<?, ?> configurationValues) {
        this.sessionFactory = sessionFactory;
        this.transactionType = settings.getTransactionType();
        this.discardOnClose = settings.isReleaseResourcesOnCloseEnabled();
        this.sessionInterceptorClass = settings.getSessionInterceptorClass();
        JpaMetaModelPopulationSetting jpaMetaModelPopulationSetting = this.determineJpaMetaModelPopulationSetting(configurationValues);
        this.metamodel = JpaMetaModelPopulationSetting.DISABLED == jpaMetaModelPopulationSetting ? null : MetamodelImpl.buildMetamodel(metadata.getEntityBindings().iterator(), metadata.getMappedSuperclassMappingsCopy(), sessionFactory, JpaMetaModelPopulationSetting.IGNORE_UNSUPPORTED == jpaMetaModelPopulationSetting);
        this.criteriaBuilder = new CriteriaBuilderImpl(this);
        this.util = new HibernatePersistenceUnitUtil(this);
        HashMap<String, Object> props = new HashMap<String, Object>();
        EntityManagerFactoryImpl.addAll(props, sessionFactory.getProperties());
        EntityManagerFactoryImpl.addAll(props, configurationValues);
        if (!props.containsKey("javax.persistence.validation.factory") && sessionFactory.getSessionFactoryOptions().getValidatorFactoryReference() != null) {
            props.put("javax.persistence.validation.factory", sessionFactory.getSessionFactoryOptions().getValidatorFactoryReference());
        }
        this.maskOutSensitiveInformation(props);
        this.properties = Collections.unmodifiableMap(props);
        String entityManagerFactoryName = (String)this.properties.get("hibernate.ejb.entitymanager_factory_name");
        if (entityManagerFactoryName == null) {
            entityManagerFactoryName = persistenceUnitName;
        }
        if (entityManagerFactoryName == null) {
            entityManagerFactoryName = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        this.entityManagerFactoryName = entityManagerFactoryName;
        this.applyNamedEntityGraphs(metadata.getNamedEntityGraphs().values());
        EntityManagerFactoryRegistry.INSTANCE.addEntityManagerFactory(entityManagerFactoryName, this);
    }

    protected JpaMetaModelPopulationSetting determineJpaMetaModelPopulationSetting(Map configurationValues) {
        String setting = ConfigurationHelper.getString((String)"hibernate.ejb.metamodel.population", (Map)configurationValues, null);
        if (setting == null && (setting = ConfigurationHelper.getString((String)"hibernate.ejb.metamodel.generation", (Map)configurationValues, null)) != null) {
            log.infof("Encountered deprecated setting [%s], use [%s] instead", (Object)"hibernate.ejb.metamodel.generation", (Object)"hibernate.ejb.metamodel.population");
        }
        return JpaMetaModelPopulationSetting.parse(setting);
    }

    private static void addAll(HashMap<String, Object> destination, Map<?, ?> source) {
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            if (!String.class.isInstance(entry.getKey())) continue;
            destination.put((String)entry.getKey(), entry.getValue());
        }
    }

    private void maskOutSensitiveInformation(HashMap<String, Object> props) {
        this.maskOutIfSet(props, "javax.persistence.jdbc.password");
        this.maskOutIfSet(props, "hibernate.connection.password");
    }

    private void maskOutIfSet(HashMap<String, Object> props, String setting) {
        if (props.containsKey(setting)) {
            props.put(setting, "****");
        }
    }

    private void applyNamedEntityGraphs(Collection<NamedEntityGraphDefinition> namedEntityGraphs) {
        for (NamedEntityGraphDefinition definition : namedEntityGraphs) {
            log.debugf("Applying named entity graph [name=%s, entity-name=%s, jpa-entity-name=%s", (Object)definition.getRegisteredName(), (Object)definition.getEntityName(), (Object)definition.getJpaEntityName());
            EntityTypeImpl entityType = this.metamodel.getEntityTypeByName(definition.getEntityName());
            if (entityType == null) {
                throw new IllegalArgumentException("Attempted to register named entity graph [" + definition.getRegisteredName() + "] for unknown entity [" + definition.getEntityName() + "]");
            }
            EntityGraphImpl entityGraph = new EntityGraphImpl(definition.getRegisteredName(), entityType, this);
            NamedEntityGraph namedEntityGraph = definition.getAnnotation();
            if (namedEntityGraph.includeAllAttributes()) {
                for (Object attributeObject : entityType.getAttributes()) {
                    entityGraph.addAttributeNodes((Attribute)attributeObject);
                }
            }
            if (namedEntityGraph.attributeNodes() != null) {
                this.applyNamedAttributeNodes(namedEntityGraph.attributeNodes(), namedEntityGraph, entityGraph);
            }
            this.entityGraphs.put(definition.getRegisteredName(), entityGraph);
        }
    }

    private void applyNamedAttributeNodes(NamedAttributeNode[] namedAttributeNodes, NamedEntityGraph namedEntityGraph, AbstractGraphNode graphNode) {
        for (NamedAttributeNode namedAttributeNode : namedAttributeNodes) {
            SubgraphImpl subgraph;
            String value = namedAttributeNode.value();
            AttributeNodeImpl attributeNode = graphNode.addAttribute(value);
            if (StringHelper.isNotEmpty((String)namedAttributeNode.subgraph())) {
                subgraph = attributeNode.makeSubgraph();
                this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.subgraph(), subgraph);
            }
            if (!StringHelper.isNotEmpty((String)namedAttributeNode.keySubgraph())) continue;
            subgraph = attributeNode.makeKeySubgraph();
            this.applyNamedSubgraphs(namedEntityGraph, namedAttributeNode.keySubgraph(), subgraph);
        }
    }

    private void applyNamedSubgraphs(NamedEntityGraph namedEntityGraph, String subgraphName, SubgraphImpl subgraph) {
        for (NamedSubgraph namedSubgraph : namedEntityGraph.subgraphs()) {
            if (!subgraphName.equals(namedSubgraph.name())) continue;
            this.applyNamedAttributeNodes(namedSubgraph.attributeNodes(), namedEntityGraph, subgraph);
        }
    }

    public EntityManager createEntityManager() {
        return this.internalCreateEntityManager(SynchronizationType.SYNCHRONIZED, Collections.EMPTY_MAP);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        this.errorIfResourceLocalDueToExplicitSynchronizationType();
        return this.internalCreateEntityManager(synchronizationType, Collections.EMPTY_MAP);
    }

    private void errorIfResourceLocalDueToExplicitSynchronizationType() {
        if (this.transactionType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            throw new IllegalStateException("Illegal attempt to specify a SynchronizationType when building an EntityManager from a EntityManagerFactory defined as RESOURCE_LOCAL ");
        }
    }

    public EntityManager createEntityManager(Map map) {
        return this.internalCreateEntityManager(SynchronizationType.SYNCHRONIZED, map);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        this.errorIfResourceLocalDueToExplicitSynchronizationType();
        return this.internalCreateEntityManager(synchronizationType, map);
    }

    private EntityManager internalCreateEntityManager(SynchronizationType synchronizationType, Map map) {
        this.validateNotClosed();
        return new EntityManagerImpl(this, PersistenceContextType.EXTENDED, synchronizationType, this.transactionType, this.discardOnClose, this.sessionInterceptorClass, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        this.validateNotClosed();
        return this.criteriaBuilder;
    }

    public Metamodel getMetamodel() {
        this.validateNotClosed();
        return this.metamodel;
    }

    public void close() {
        this.validateNotClosed();
        this.sessionFactory.close();
        EntityManagerFactoryRegistry.INSTANCE.removeEntityManagerFactory(this.entityManagerFactoryName, this);
    }

    public Map<String, Object> getProperties() {
        this.validateNotClosed();
        return this.properties;
    }

    public javax.persistence.Cache getCache() {
        this.validateNotClosed();
        return new JPACache(this.sessionFactory);
    }

    protected void validateNotClosed() {
        if (!this.isOpen()) {
            throw new IllegalStateException("EntityManagerFactory is closed");
        }
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        this.validateNotClosed();
        return this.util;
    }

    public void addNamedQuery(String name, javax.persistence.Query query) {
        Object unwrapped2;
        this.validateNotClosed();
        try {
            unwrapped2 = (StoredProcedureQueryImpl)query.unwrap(StoredProcedureQueryImpl.class);
            if (unwrapped2 != null) {
                this.addNamedStoredProcedureQuery(name, (StoredProcedureQueryImpl)unwrapped2);
                return;
            }
        }
        catch (PersistenceException unwrapped2) {
            // empty catch block
        }
        try {
            unwrapped2 = (HibernateQuery)query.unwrap(HibernateQuery.class);
            if (unwrapped2 != null) {
                Query hibernateQuery = unwrapped2.getHibernateQuery();
                if (SQLQuery.class.isInstance(hibernateQuery)) {
                    this.sessionFactory.registerNamedSQLQueryDefinition(name, this.extractSqlQueryDefinition((SQLQuery)hibernateQuery, name));
                } else {
                    this.sessionFactory.registerNamedQueryDefinition(name, this.extractHqlQueryDefinition(hibernateQuery, name));
                }
                return;
            }
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
        throw new PersistenceException(String.format("Unsure how to how to properly unwrap given Query [%s] as basis for named query", query));
    }

    private void addNamedStoredProcedureQuery(String name, StoredProcedureQueryImpl query) {
        ProcedureCall procedureCall = query.getHibernateProcedureCall();
        this.sessionFactory.getNamedQueryRepository().registerNamedProcedureCallMemento(name, procedureCall.extractMemento(query.getHints()));
    }

    private NamedSQLQueryDefinition extractSqlQueryDefinition(SQLQuery nativeSqlQuery, String name) {
        NamedSQLQueryDefinitionBuilder builder = new NamedSQLQueryDefinitionBuilder(name);
        this.fillInNamedQueryBuilder((NamedQueryDefinitionBuilder)builder, (Query)nativeSqlQuery);
        builder.setCallable(nativeSqlQuery.isCallable()).setQuerySpaces(nativeSqlQuery.getSynchronizedQuerySpaces()).setQueryReturns(nativeSqlQuery.getQueryReturns());
        return builder.createNamedQueryDefinition();
    }

    private NamedQueryDefinition extractHqlQueryDefinition(Query hqlQuery, String name) {
        NamedQueryDefinitionBuilder builder = new NamedQueryDefinitionBuilder(name);
        this.fillInNamedQueryBuilder(builder, hqlQuery);
        builder.setLockOptions(hqlQuery.getLockOptions().makeCopy());
        return builder.createNamedQueryDefinition();
    }

    private void fillInNamedQueryBuilder(NamedQueryDefinitionBuilder builder, Query query) {
        builder.setQuery(query.getQueryString()).setComment(query.getComment()).setCacheable(query.isCacheable()).setCacheRegion(query.getCacheRegion()).setCacheMode(query.getCacheMode()).setTimeout(query.getTimeout()).setFetchSize(query.getFetchSize()).setFirstResult(query.getFirstResult()).setMaxResults(query.getMaxResults()).setReadOnly(query.isReadOnly()).setFlushMode(query.getFlushMode());
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(SessionFactory.class)) {
            return type.cast(this.sessionFactory);
        }
        if (type.isAssignableFrom(SessionFactoryImplementor.class)) {
            return type.cast(this.sessionFactory);
        }
        if (type.isAssignableFrom(SessionFactoryImpl.class)) {
            return type.cast(this.sessionFactory);
        }
        if (type.isAssignableFrom(HibernateEntityManagerFactory.class)) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(EntityManagerFactoryImpl.class)) {
            return type.cast(this);
        }
        throw new PersistenceException("Hibernate cannot unwrap EntityManagerFactory as '" + type.getName() + "'");
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        if (!EntityGraphImpl.class.isInstance(entityGraph)) {
            throw new IllegalArgumentException("Unknown type of EntityGraph for making named : " + entityGraph.getClass().getName());
        }
        EntityGraphImpl copy = ((EntityGraphImpl)entityGraph).makeImmutableCopy(graphName);
        EntityGraphImpl old = this.entityGraphs.put(graphName, copy);
        if (old != null) {
            log.debugf("EntityGraph being replaced on EntityManagerFactory for name %s", (Object)graphName);
        }
    }

    public EntityGraphImpl findEntityGraphByName(String name) {
        return this.entityGraphs.get(name);
    }

    @Override
    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        EntityType entityType = this.getMetamodel().entity(entityClass);
        if (entityType == null) {
            throw new IllegalArgumentException("Given class is not an entity : " + entityClass.getName());
        }
        ArrayList<EntityGraph<T>> results = new ArrayList<EntityGraph<T>>();
        for (EntityGraphImpl entityGraph : this.entityGraphs.values()) {
            if (!entityGraph.appliesTo(entityType)) continue;
            results.add(entityGraph);
        }
        return results;
    }

    public boolean isOpen() {
        return !this.sessionFactory.isClosed();
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public EntityType getEntityTypeByName(String entityName) {
        EntityTypeImpl entityType = this.metamodel.getEntityTypeByName(entityName);
        if (entityType == null) {
            throw new IllegalArgumentException("[" + entityName + "] did not refer to EntityType");
        }
        return entityType;
    }

    @Override
    public String getEntityManagerFactoryName() {
        return this.entityManagerFactoryName;
    }

    private static EntityManagerFactory getNamedEntityManagerFactory(String entityManagerFactoryName) throws InvalidObjectException {
        EntityManagerFactory result = EntityManagerFactoryRegistry.INSTANCE.getNamedEntityManagerFactory(entityManagerFactoryName);
        if (result == null) {
            throw new InvalidObjectException("could not resolve entity manager factory during entity manager deserialization [name=" + entityManagerFactoryName + "]");
        }
        return result;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.entityManagerFactoryName == null) {
            throw new InvalidObjectException("could not serialize entity manager factory with null entityManagerFactoryName");
        }
        oos.defaultWriteObject();
    }

    private Object readResolve() throws InvalidObjectException {
        return EntityManagerFactoryImpl.getNamedEntityManagerFactory(this.entityManagerFactoryName);
    }

    private static class HibernatePersistenceUnitUtil
    implements PersistenceUnitUtil,
    Serializable {
        private final HibernateEntityManagerFactory emf;
        private transient PersistenceUtilHelper.MetadataCache cache;

        private HibernatePersistenceUnitUtil(EntityManagerFactoryImpl emf) {
            this.emf = emf;
            this.cache = emf.cache;
        }

        public boolean isLoaded(Object entity, String attributeName) {
            log.debug((Object)"PersistenceUnitUtil#isLoaded is not always accurate; consider using EntityManager#contains instead");
            LoadState state = PersistenceUtilHelper.isLoadedWithoutReference(entity, attributeName, this.cache);
            if (state == LoadState.LOADED) {
                return true;
            }
            if (state == LoadState.NOT_LOADED) {
                return false;
            }
            return PersistenceUtilHelper.isLoadedWithReference(entity, attributeName, this.cache) != LoadState.NOT_LOADED;
        }

        public boolean isLoaded(Object entity) {
            log.debug((Object)"PersistenceUnitUtil#isLoaded is not always accurate; consider using EntityManager#contains instead");
            return PersistenceUtilHelper.isLoaded(entity) != LoadState.NOT_LOADED;
        }

        public Object getIdentifier(Object entity) {
            Class entityClass = Hibernate.getClass((Object)entity);
            ClassMetadata classMetadata = this.emf.getSessionFactory().getClassMetadata(entityClass);
            if (classMetadata == null) {
                throw new IllegalArgumentException(entityClass + " is not an entity");
            }
            return classMetadata.getIdentifier(entity);
        }
    }

    private static class JPACache
    implements javax.persistence.Cache {
        private SessionFactoryImplementor sessionFactory;

        private JPACache(SessionFactoryImplementor sessionFactory) {
            this.sessionFactory = sessionFactory;
        }

        public boolean contains(Class entityClass, Object identifier) {
            return this.sessionFactory.getCache().containsEntity(entityClass, (Serializable)identifier);
        }

        public void evict(Class entityClass, Object identifier) {
            this.sessionFactory.getCache().evictEntity(entityClass, (Serializable)identifier);
        }

        public void evict(Class entityClass) {
            this.sessionFactory.getCache().evictEntityRegion(entityClass);
        }

        public void evictAll() {
            this.sessionFactory.getCache().evictEntityRegions();
        }

        public <T> T unwrap(Class<T> cls) {
            if (RegionFactory.class.isAssignableFrom(cls)) {
                return (T)this.sessionFactory.getSettings().getRegionFactory();
            }
            if (Cache.class.isAssignableFrom(cls)) {
                return (T)this.sessionFactory.getCache();
            }
            throw new PersistenceException("Hibernate cannot unwrap Cache as " + cls.getName());
        }
    }

    private static enum JpaMetaModelPopulationSetting {
        ENABLED,
        DISABLED,
        IGNORE_UNSUPPORTED;


        private static JpaMetaModelPopulationSetting parse(String setting) {
            if ("enabled".equalsIgnoreCase(setting)) {
                return ENABLED;
            }
            if ("disabled".equalsIgnoreCase(setting)) {
                return DISABLED;
            }
            return IGNORE_UNSUPPORTED;
        }
    }
}

