/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.rest.configuration;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    APPEND_CACHE_NAME_TO_PATH("append-cache-name-to-path"),
    BUFFER_SIZE("buffer-size"),
    CONNECTION_TIMEOUT("connection-timeout"),
    HOST("host"),
    KEY_TO_STRING_MAPPER("key-to-string-mapper"),
    MAX_CONNECTIONS_PER_HOST("max-connections-per-host"),
    MAX_TOTAL_CONNECTIONS("max-total-connections"),
    OUTBOUND_SOCKET_BINDING("outbound-socket-binding"),
    PATH("path"),
    PORT("port"),
    RAW_VALUES("raw-values"),
    SOCKET_TIMEOUT("socket-timeout"),
    TCP_NO_DELAY("tcp-no-delay");

    private final String name;
    private static final Map<String, Attribute> attributes;

    private Attribute(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Attribute forName(String localName) {
        Attribute attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

