/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.NullEncodingTwoWayFieldBridge;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.BooleanJunction;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.query.dsl.FieldCustomization;
import org.hibernate.search.query.dsl.PhraseContext;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.RangeMatchingContext;
import org.hibernate.search.query.dsl.RangeTerminationExcludable;
import org.hibernate.search.query.dsl.impl.FieldBridgeCustomization;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.objectfilter.SortField;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.AggregationExpr;
import org.infinispan.objectfilter.impl.syntax.AndExpr;
import org.infinispan.objectfilter.impl.syntax.BetweenExpr;
import org.infinispan.objectfilter.impl.syntax.BooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ComparisonExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.ConstantValueExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextBoostExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextOccurExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextRangeExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextRegexpExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextTermExpr;
import org.infinispan.objectfilter.impl.syntax.IsNullExpr;
import org.infinispan.objectfilter.impl.syntax.LikeExpr;
import org.infinispan.objectfilter.impl.syntax.NotExpr;
import org.infinispan.objectfilter.impl.syntax.OrExpr;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.dsl.embedded.impl.LuceneQueryParsingResult;
import org.infinispan.query.logging.Log;
import org.jboss.logging.Logger;

public final class LuceneQueryMaker<TypeMetadata>
implements Visitor<Query, Query> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)LuceneQueryMaker.class.getName());
    private static final char LUCENE_SINGLE_CHARACTER_WILDCARD = '?';
    private static final char LUCENE_MULTIPLE_CHARACTERS_WILDCARD = '*';
    private static final char LUCENE_WILDCARD_ESCAPE_CHARACTER = '\\';
    private final QueryContextBuilder queryContextBuilder;
    private final FieldBridgeAndAnalyzerProvider<TypeMetadata> fieldBridgeAndAnalyzerProvider;
    private final SearchIntegrator searchFactory;
    private Map<String, Object> namedParameters;
    private QueryBuilder queryBuilder;
    private TypeMetadata entityType;
    private Analyzer entityAnalyzer;

    LuceneQueryMaker(SearchIntegrator searchFactory, FieldBridgeAndAnalyzerProvider<TypeMetadata> fieldBridgeAndAnalyzerProvider) {
        if (searchFactory == null) {
            throw new IllegalArgumentException("searchFactory argument cannot be null");
        }
        this.fieldBridgeAndAnalyzerProvider = fieldBridgeAndAnalyzerProvider;
        this.queryContextBuilder = searchFactory.buildQueryBuilder();
        this.searchFactory = searchFactory;
    }

    public LuceneQueryParsingResult<TypeMetadata> transform(IckleParsingResult<TypeMetadata> parsingResult, Map<String, Object> namedParameters, Class<?> targetedType) {
        BooleanQuery booleanQuery;
        boolean allClausesAreMustNot;
        Query query;
        this.namedParameters = namedParameters;
        EntityContext entityContext = this.queryContextBuilder.forEntity(targetedType);
        this.fieldBridgeAndAnalyzerProvider.overrideAnalyzers(parsingResult, entityContext);
        this.queryBuilder = entityContext.get();
        this.entityType = parsingResult.getTargetEntityMetadata();
        ScopedAnalyzerReference analyzerReference = ((ExtendedSearchIntegrator)this.searchFactory).getAnalyzerReference(targetedType);
        if (analyzerReference.is(LuceneAnalyzerReference.class)) {
            this.entityAnalyzer = ((LuceneAnalyzerReference)analyzerReference.unwrap(LuceneAnalyzerReference.class)).getAnalyzer();
        }
        if ((query = this.makeQuery(parsingResult.getWhereClause())) instanceof BooleanQuery && (allClausesAreMustNot = (booleanQuery = (BooleanQuery)query).clauses().stream().allMatch(c -> c.getOccur() == BooleanClause.Occur.MUST_NOT))) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (BooleanClause clause : booleanQuery.clauses()) {
                builder.add(clause.getQuery(), BooleanClause.Occur.MUST_NOT);
            }
            builder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.FILTER);
            query = builder.build();
        }
        Sort sort = this.makeSort(parsingResult.getSortFields());
        return new LuceneQueryParsingResult<Object>(query, parsingResult.getTargetEntityName(), parsingResult.getTargetEntityMetadata(), parsingResult.getProjections(), sort);
    }

    private Query makeQuery(BooleanExpr expr) {
        return expr == null ? this.queryBuilder.all().createQuery() : (Query)expr.acceptVisitor((Visitor)this);
    }

    private Sort makeSort(SortField[] sortFields) {
        if (sortFields == null || sortFields.length == 0) {
            return null;
        }
        org.apache.lucene.search.SortField[] fields = new org.apache.lucene.search.SortField[sortFields.length];
        for (int i = 0; i < fields.length; ++i) {
            SortField sf = sortFields[i];
            SortField.Type sortType = SortField.Type.STRING;
            FieldBridge fieldBridge = this.fieldBridgeAndAnalyzerProvider.getFieldBridge(this.entityType, sf.getPath().asArrayPath());
            if (fieldBridge instanceof NullEncodingTwoWayFieldBridge) {
                fieldBridge = (FieldBridge)((NullEncodingTwoWayFieldBridge)fieldBridge).unwrap(FieldBridge.class);
            }
            if (fieldBridge instanceof NumericFieldBridge) {
                switch ((NumericFieldBridge)fieldBridge) {
                    case INT_FIELD_BRIDGE: {
                        sortType = SortField.Type.INT;
                        break;
                    }
                    case LONG_FIELD_BRIDGE: {
                        sortType = SortField.Type.LONG;
                        break;
                    }
                    case FLOAT_FIELD_BRIDGE: {
                        sortType = SortField.Type.FLOAT;
                        break;
                    }
                    case DOUBLE_FIELD_BRIDGE: {
                        sortType = SortField.Type.DOUBLE;
                    }
                }
            }
            fields[i] = new org.apache.lucene.search.SortField(sf.getPath().asStringPath(), sortType, !sf.isAscending());
        }
        return new Sort(fields);
    }

    public Query visit(FullTextOccurExpr fullTextOccurExpr) {
        Query child = (Query)fullTextOccurExpr.getChild().acceptVisitor((Visitor)this);
        return new BooleanQuery.Builder().add(child, this.convertOccur(fullTextOccurExpr)).build();
    }

    private BooleanClause.Occur convertOccur(FullTextOccurExpr fullTextOccurExpr) {
        switch (fullTextOccurExpr.getOccur()) {
            case SHOULD: {
                return BooleanClause.Occur.SHOULD;
            }
            case MUST: {
                return BooleanClause.Occur.MUST;
            }
            case MUST_NOT: {
                return BooleanClause.Occur.MUST_NOT;
            }
            case FILTER: {
                return BooleanClause.Occur.FILTER;
            }
        }
        throw new IllegalArgumentException("Unknown boolean occur clause: " + fullTextOccurExpr.getOccur());
    }

    public Query visit(FullTextBoostExpr fullTextBoostExpr) {
        Query child = (Query)fullTextBoostExpr.getChild().acceptVisitor((Visitor)this);
        return new BoostQuery(child, fullTextBoostExpr.getBoost());
    }

    private boolean isMultiTermText(PropertyPath<?> propertyPath, String text) {
        Analyzer analyzer = this.fieldBridgeAndAnalyzerProvider.getAnalyzer(this.searchFactory, this.entityType, propertyPath.asArrayPath());
        if (analyzer == null) {
            analyzer = this.entityAnalyzer;
        }
        if (analyzer != null) {
            int terms = 0;
            try (TokenStream tokenStream = analyzer.tokenStream(propertyPath.asStringPathWithoutAlias(), (Reader)new StringReader(text));){
                PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)tokenStream.addAttribute(PositionIncrementAttribute.class);
                tokenStream.reset();
                while (tokenStream.incrementToken() && (posIncAtt.getPositionIncrement() <= 0 || ++terms <= 1)) {
                }
                tokenStream.end();
            }
            catch (IOException e) {
                log.error(e);
            }
            return terms > 1;
        }
        return text.trim().indexOf(32) != -1;
    }

    public Query visit(FullTextTermExpr fullTextTermExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextTermExpr.getChild();
        String text = fullTextTermExpr.getTerm();
        int asteriskPos = text.indexOf(42);
        int questionPos = text.indexOf(63);
        if (asteriskPos == -1 && questionPos == -1) {
            if (this.isMultiTermText(propertyValueExpr.getPropertyPath(), text)) {
                PhraseContext phrase = this.queryBuilder.phrase();
                if (fullTextTermExpr.getFuzzySlop() != null) {
                    phrase = phrase.withSlop(fullTextTermExpr.getFuzzySlop().intValue());
                }
                return phrase.onField(propertyValueExpr.getPropertyPath().asStringPath()).sentence(text).createQuery();
            }
            if (fullTextTermExpr.getFuzzySlop() != null) {
                return this.applyFieldBridge(true, propertyValueExpr.getPropertyPath(), this.queryBuilder.keyword().fuzzy().withEditDistanceUpTo(fullTextTermExpr.getFuzzySlop().intValue()).onField(propertyValueExpr.getPropertyPath().asStringPath())).matching((Object)text).createQuery();
            }
            return this.applyFieldBridge(true, propertyValueExpr.getPropertyPath(), this.queryBuilder.keyword().onField(propertyValueExpr.getPropertyPath().asStringPath())).matching((Object)text).createQuery();
        }
        if (fullTextTermExpr.getFuzzySlop() != null) {
            throw log.getPrefixWildcardOrRegexpQueriesCannotBeFuzzy(fullTextTermExpr.toQueryString());
        }
        if (questionPos == -1 && asteriskPos == text.length() - 1) {
            String prefix = text.substring(0, text.length() - 1);
            return new PrefixQuery(new Term(propertyValueExpr.getPropertyPath().asStringPath(), prefix));
        }
        return this.applyFieldBridge(true, propertyValueExpr.getPropertyPath(), this.queryBuilder.keyword().wildcard().onField(propertyValueExpr.getPropertyPath().asStringPath())).matching((Object)text).createQuery();
    }

    public Query visit(FullTextRegexpExpr fullTextRegexpExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextRegexpExpr.getChild();
        String regexp = fullTextRegexpExpr.getRegexp();
        return new RegexpQuery(new Term(propertyValueExpr.getPropertyPath().asStringPath(), regexp));
    }

    public Query visit(FullTextRangeExpr fullTextRangeExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)fullTextRangeExpr.getChild();
        if (fullTextRangeExpr.getLower() == null && fullTextRangeExpr.getUpper() == null) {
            return new TermRangeQuery(propertyValueExpr.getPropertyPath().asStringPath(), null, null, fullTextRangeExpr.isIncludeLower(), fullTextRangeExpr.isIncludeUpper());
        }
        RangeMatchingContext rangeMatchingContext = this.applyFieldBridge(true, propertyValueExpr.getPropertyPath(), this.queryBuilder.range().onField(propertyValueExpr.getPropertyPath().asStringPath()));
        RangeTerminationExcludable t = null;
        if (fullTextRangeExpr.getLower() != null) {
            t = rangeMatchingContext.above((Object)fullTextRangeExpr.getLower());
            if (!fullTextRangeExpr.isIncludeLower()) {
                t.excludeLimit();
            }
        }
        if (fullTextRangeExpr.getUpper() != null) {
            t = rangeMatchingContext.below((Object)fullTextRangeExpr.getUpper());
            if (!fullTextRangeExpr.isIncludeUpper()) {
                t.excludeLimit();
            }
        }
        return t.createQuery();
    }

    public Query visit(NotExpr notExpr) {
        Query transformedChild = (Query)notExpr.getChild().acceptVisitor((Visitor)this);
        return this.queryBuilder.bool().must(transformedChild).not().createQuery();
    }

    public Query visit(OrExpr orExpr) {
        BooleanJunction booleanJunction = this.queryBuilder.bool();
        for (BooleanExpr c : orExpr.getChildren()) {
            Query transformedChild = (Query)c.acceptVisitor((Visitor)this);
            booleanJunction.should(transformedChild);
        }
        return booleanJunction.createQuery();
    }

    public Query visit(AndExpr andExpr) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (BooleanExpr c : andExpr.getChildren()) {
            Query transformedChild;
            boolean isNegative = c instanceof NotExpr;
            if (isNegative) {
                c = ((NotExpr)c).getChild();
            }
            if ((transformedChild = (Query)c.acceptVisitor((Visitor)this)) instanceof BooleanQuery) {
                BooleanQuery booleanQuery = (BooleanQuery)transformedChild;
                if (booleanQuery.clauses().size() == 1) {
                    BooleanClause clause = (BooleanClause)booleanQuery.clauses().get(0);
                    BooleanClause.Occur occur = clause.getOccur();
                    if (isNegative) {
                        occur = occur == BooleanClause.Occur.MUST_NOT ? BooleanClause.Occur.MUST : BooleanClause.Occur.MUST_NOT;
                    }
                    builder.add(clause.getQuery(), occur);
                    continue;
                }
                builder.add(transformedChild, isNegative ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.MUST);
                continue;
            }
            builder.add(transformedChild, isNegative ? BooleanClause.Occur.MUST_NOT : BooleanClause.Occur.MUST);
        }
        return builder.build();
    }

    public Query visit(IsNullExpr isNullExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)isNullExpr.getChild();
        return this.applyFieldBridge(false, propertyValueExpr.getPropertyPath(), this.queryBuilder.keyword().onField(propertyValueExpr.getPropertyPath().asStringPath())).matching(null).createQuery();
    }

    public Query visit(ComparisonExpr comparisonExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)comparisonExpr.getLeftChild();
        ConstantValueExpr constantValueExpr = (ConstantValueExpr)comparisonExpr.getRightChild();
        Comparable value = constantValueExpr.getConstantValueAs(propertyValueExpr.getPrimitiveType(), this.namedParameters);
        switch (comparisonExpr.getComparisonType()) {
            case NOT_EQUAL: {
                Query q = this.applyFieldBridge(false, propertyValueExpr.getPropertyPath(), this.queryBuilder.keyword().onField(propertyValueExpr.getPropertyPath().asStringPath())).matching((Object)value).createQuery();
                return this.queryBuilder.bool().must(q).not().createQuery();
            }
            case EQUAL: {
                return this.applyFieldBridge(false, propertyValueExpr.getPropertyPath(), this.queryBuilder.keyword().onField(propertyValueExpr.getPropertyPath().asStringPath())).matching((Object)value).createQuery();
            }
            case LESS: {
                return this.applyFieldBridge(false, propertyValueExpr.getPropertyPath(), this.queryBuilder.range().onField(propertyValueExpr.getPropertyPath().asStringPath())).below((Object)value).excludeLimit().createQuery();
            }
            case LESS_OR_EQUAL: {
                return this.applyFieldBridge(false, propertyValueExpr.getPropertyPath(), this.queryBuilder.range().onField(propertyValueExpr.getPropertyPath().asStringPath())).below((Object)value).createQuery();
            }
            case GREATER: {
                return this.applyFieldBridge(false, propertyValueExpr.getPropertyPath(), this.queryBuilder.range().onField(propertyValueExpr.getPropertyPath().asStringPath())).above((Object)value).excludeLimit().createQuery();
            }
            case GREATER_OR_EQUAL: {
                return this.applyFieldBridge(false, propertyValueExpr.getPropertyPath(), this.queryBuilder.range().onField(propertyValueExpr.getPropertyPath().asStringPath())).above((Object)value).createQuery();
            }
        }
        throw new IllegalStateException("Unexpected comparison type: " + comparisonExpr.getComparisonType());
    }

    public Query visit(BetweenExpr betweenExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)betweenExpr.getLeftChild();
        ConstantValueExpr fromValueExpr = (ConstantValueExpr)betweenExpr.getFromChild();
        ConstantValueExpr toValueExpr = (ConstantValueExpr)betweenExpr.getToChild();
        Comparable fromValue = fromValueExpr.getConstantValueAs(propertyValueExpr.getPrimitiveType(), this.namedParameters);
        Comparable toValue = toValueExpr.getConstantValueAs(propertyValueExpr.getPrimitiveType(), this.namedParameters);
        return this.applyFieldBridge(false, propertyValueExpr.getPropertyPath(), this.queryBuilder.range().onField(propertyValueExpr.getPropertyPath().asStringPath())).from((Object)fromValue).to((Object)toValue).createQuery();
    }

    public Query visit(LikeExpr likeExpr) {
        PropertyValueExpr propertyValueExpr = (PropertyValueExpr)likeExpr.getChild();
        StringBuilder lucenePattern = new StringBuilder(likeExpr.getPattern());
        boolean isEscaped = false;
        for (int i = 0; i < lucenePattern.length(); ++i) {
            char c = lucenePattern.charAt(i);
            if (!isEscaped && c == likeExpr.getEscapeChar()) {
                isEscaped = true;
                lucenePattern.deleteCharAt(i);
                continue;
            }
            if (isEscaped) {
                isEscaped = false;
            } else {
                if (c == '%') {
                    lucenePattern.setCharAt(i, '*');
                    continue;
                }
                if (c == '_') {
                    lucenePattern.setCharAt(i, '?');
                    continue;
                }
            }
            if (c != '?' && c != '*') continue;
            lucenePattern.insert(i, '\\');
            ++i;
        }
        return this.applyFieldBridge(false, propertyValueExpr.getPropertyPath(), this.queryBuilder.keyword().wildcard().onField(propertyValueExpr.getPropertyPath().asStringPath())).matching((Object)lucenePattern.toString()).createQuery();
    }

    public Query visit(ConstantBooleanExpr constantBooleanExpr) {
        Query all = this.queryBuilder.all().createQuery();
        return constantBooleanExpr.getValue() ? all : this.queryBuilder.bool().must(all).not().createQuery();
    }

    public Query visit(ConstantValueExpr constantValueExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    public Query visit(PropertyValueExpr propertyValueExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    public Query visit(AggregationExpr aggregationExpr) {
        throw new IllegalStateException("This node type should not be visited");
    }

    private <F extends FieldCustomization> F applyFieldBridge(boolean isAnalyzed, PropertyPath<?> propertyPath, F field) {
        FieldBridge fieldBridge = this.fieldBridgeAndAnalyzerProvider.getFieldBridge(this.entityType, propertyPath.asArrayPath());
        if (fieldBridge != null) {
            ((FieldBridgeCustomization)field).withFieldBridge(fieldBridge);
        }
        if (!isAnalyzed) {
            field.ignoreAnalyzer();
        }
        return field;
    }

    public static interface FieldBridgeAndAnalyzerProvider<TypeMetadata> {
        public FieldBridge getFieldBridge(TypeMetadata var1, String[] var2);

        public Analyzer getAnalyzer(SearchIntegrator var1, TypeMetadata var2, String[] var3);

        public void overrideAnalyzers(IckleParsingResult<TypeMetadata> var1, EntityContext var2);
    }
}

