/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.externalizers;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.query.impl.externalizers.ExternalizerIds;

public class LuceneTopDocsExternalizer
extends AbstractExternalizer<TopDocs> {
    public Set<Class<? extends TopDocs>> getTypeClasses() {
        return Collections.singleton(TopDocs.class);
    }

    public TopDocs readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int totalHits = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        float maxScore = input.readFloat();
        int scoreCount = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
        ScoreDoc[] scoreDocs = new ScoreDoc[scoreCount];
        for (int i = 0; i < scoreCount; ++i) {
            scoreDocs[i] = (ScoreDoc)input.readObject();
        }
        return new TopDocs(totalHits, scoreDocs, maxScore);
    }

    public void writeObject(ObjectOutput output, TopDocs topDocs) throws IOException {
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)topDocs.totalHits);
        output.writeFloat(topDocs.getMaxScore());
        ScoreDoc[] scoreDocs = topDocs.scoreDocs;
        int count = scoreDocs.length;
        UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)count);
        for (ScoreDoc scoreDoc : scoreDocs) {
            output.writeObject(scoreDoc);
        }
    }

    public Integer getId() {
        return ExternalizerIds.LUCENE_TOPDOCS;
    }
}

