/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.core.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Log4J2LoggerFactory;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.jmx.JmxUtil;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.logging.Log;
import org.infinispan.server.core.transport.Transport;

public class NettyTransport
implements Transport {
    private static final Log log;
    private static final boolean isLog4jAvailable;
    private ChannelInitializer<Channel> handler;
    private final InetSocketAddress address;
    private final ProtocolServerConfiguration configuration;
    private final String threadNamePrefix;
    private final EmbeddedCacheManager cacheManager;
    private final ChannelGroup serverChannels;
    final ChannelGroup acceptedChannels;
    private final boolean useNativeEpoll;
    private final EventLoopGroup masterGroup;
    private final EventLoopGroup workerGroup;
    private final AtomicLong totalBytesWritten = new AtomicLong();
    private final AtomicLong totalBytesRead = new AtomicLong();
    private final boolean isGlobalStatsEnabled;
    private Optional<Integer> nettyPort = Optional.empty();

    public NettyTransport(InetSocketAddress address, ProtocolServerConfiguration configuration, String threadNamePrefix, EmbeddedCacheManager cacheManager, boolean useNativeEpoll) {
        this.address = address;
        this.configuration = configuration;
        this.threadNamePrefix = threadNamePrefix;
        this.cacheManager = cacheManager;
        this.useNativeEpoll = useNativeEpoll;
        this.masterGroup = this.buildEventLoop(1, new DefaultThreadFactory(threadNamePrefix + "-ServerMaster"));
        this.workerGroup = this.buildEventLoop(0, new DefaultThreadFactory(threadNamePrefix + "-ServerWorker"));
        this.isGlobalStatsEnabled = cacheManager.getCacheManagerConfiguration().globalJmxStatistics().enabled();
        this.serverChannels = new DefaultChannelGroup(threadNamePrefix + "-Channels", (EventExecutor)ImmediateEventExecutor.INSTANCE);
        this.acceptedChannels = new DefaultChannelGroup(threadNamePrefix + "-Accepted", (EventExecutor)ImmediateEventExecutor.INSTANCE);
    }

    public void initializeHandler(ChannelInitializer<Channel> handler) {
        this.handler = handler;
    }

    @Override
    public void start() {
        Channel ch;
        if (isLog4jAvailable) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Log4J2LoggerFactory.INSTANCE);
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.group(this.masterGroup, this.workerGroup);
        bootstrap.channel(this.getServerSocketChannel());
        bootstrap.childHandler(this.handler);
        bootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)this.configuration.tcpNoDelay());
        if (this.configuration.sendBufSize() > 0) {
            bootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)this.configuration.sendBufSize());
        }
        if (this.configuration.recvBufSize() > 0) {
            bootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)this.configuration.recvBufSize());
        }
        try {
            ch = bootstrap.bind((SocketAddress)this.address).sync().channel();
            this.nettyPort = Optional.of(((InetSocketAddress)ch.localAddress()).getPort());
        }
        catch (InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
        this.serverChannels.add((Object)ch);
    }

    @Override
    public void stop() {
        Future masterTerminationFuture = this.masterGroup.shutdownGracefully(100L, 1000L, TimeUnit.MILLISECONDS);
        Future workerTerminationFuture = this.workerGroup.shutdownGracefully(100L, 1000L, TimeUnit.MILLISECONDS);
        masterTerminationFuture.awaitUninterruptibly();
        workerTerminationFuture.awaitUninterruptibly();
        ChannelGroupFuture serverChannelsTerminationFuture = this.serverChannels.close();
        ChannelGroupFuture acceptedChannelsTerminationFuture = this.acceptedChannels.close();
        ChannelGroupFuture future = serverChannelsTerminationFuture.awaitUninterruptibly();
        if (!future.isSuccess()) {
            log.serverDidNotUnbind();
            future.forEach(fut -> {
                Channel ch = fut.channel();
                if (ch.isActive()) {
                    log.channelStillBound(ch, ch.remoteAddress());
                }
            });
        }
        if (!(future = acceptedChannelsTerminationFuture.awaitUninterruptibly()).isSuccess()) {
            log.serverDidNotClose();
            future.forEach(fut -> {
                Channel ch = fut.channel();
                if (ch.isActive()) {
                    log.channelStillConnected(ch, ch.remoteAddress());
                }
            });
        }
        if (log.isDebugEnabled()) {
            log.debug("Channel group completely closed, external resources released");
        }
        this.nettyPort = Optional.empty();
    }

    @Override
    public String getTotalBytesWritten() {
        return this.totalBytesWritten.toString();
    }

    @Override
    public String getTotalBytesRead() {
        return this.totalBytesRead.toString();
    }

    @Override
    public String getHostName() {
        return this.address.getHostName();
    }

    @Override
    public Integer getPort() {
        return this.nettyPort.orElse(this.address.getPort());
    }

    @Override
    public String getNumberWorkerThreads() {
        return Integer.toString(this.configuration.workerThreads());
    }

    @Override
    public String getIdleTimeout() {
        return Integer.toString(this.configuration.idleTimeout());
    }

    @Override
    public String getTcpNoDelay() {
        return Boolean.toString(this.configuration.tcpNoDelay());
    }

    @Override
    public String getSendBufferSize() {
        return Integer.toString(this.configuration.sendBufSize());
    }

    @Override
    public String getReceiveBufferSize() {
        return Integer.toString(this.configuration.recvBufSize());
    }

    @Override
    public Integer getNumberOfLocalConnections() {
        return this.acceptedChannels.size();
    }

    @Override
    public Integer getNumberOfGlobalConnections() {
        if (this.needDistributedCalculation()) {
            return this.calculateGlobalConnections();
        }
        return this.getNumberOfLocalConnections();
    }

    public void updateTotalBytesWritten(int bytes) {
        if (this.isGlobalStatsEnabled) {
            this.incrementTotalBytes(this.totalBytesWritten, bytes);
        }
    }

    public void updateTotalBytesRead(int bytes) {
        if (this.isGlobalStatsEnabled) {
            this.incrementTotalBytes(this.totalBytesRead, bytes);
        }
    }

    private void incrementTotalBytes(AtomicLong base, int bytes) {
        if (this.isGlobalStatsEnabled) {
            base.addAndGet(bytes);
        }
    }

    private boolean needDistributedCalculation() {
        org.infinispan.remoting.transport.Transport transport = this.cacheManager.getTransport();
        return transport != null && transport.getMembers().size() > 1;
    }

    private Class<? extends ServerChannel> getServerSocketChannel() {
        Class channel = this.useNativeEpoll ? EpollServerSocketChannel.class : NioServerSocketChannel.class;
        log.createdSocketChannel(channel.getName(), this.configuration.toString());
        return channel;
    }

    private EventLoopGroup buildEventLoop(int nThreads, DefaultThreadFactory threadFactory) {
        EpollEventLoopGroup eventLoop = this.useNativeEpoll ? new EpollEventLoopGroup(nThreads, (ThreadFactory)threadFactory) : new NioEventLoopGroup(nThreads, (ThreadFactory)threadFactory);
        log.createdNettyEventLoop(eventLoop.getClass().getName(), this.configuration.toString());
        return eventLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calculateGlobalConnections() {
        Cache cache = this.cacheManager.getCache();
        DefaultExecutorService exec = new DefaultExecutorService(cache);
        try {
            List results = exec.submitEverywhere((Callable)((Object)new ConnectionAdderTask(this.threadNamePrefix)));
            int n = results.stream().mapToInt(f -> {
                try {
                    return (Integer)f.get(30L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    throw new CacheException((Throwable)e);
                }
            }).sum();
            return n;
        }
        finally {
            exec.shutdown();
        }
    }

    static {
        boolean exception;
        log = (Log)LogFactory.getLog(NettyTransport.class, Log.class);
        try {
            Util.loadClassStrict((String)"org.apache.logging.log4j.Logger", (ClassLoader)Thread.currentThread().getContextClassLoader());
            exception = false;
        }
        catch (ClassNotFoundException e) {
            exception = true;
        }
        isLog4jAvailable = !exception;
    }

    static class ConnectionAdderTask
    implements Serializable,
    DistributedCallable<Object, Object, Integer> {
        private final String serverName;
        Cache<Object, Object> cache;

        ConnectionAdderTask(String serverName) {
            this.serverName = serverName;
        }

        public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
            this.cache = cache;
        }

        public Integer call() throws Exception {
            GlobalConfiguration globalCfg = this.cache.getCacheManager().getCacheManagerConfiguration();
            String jmxDomain = globalCfg.globalJmxStatistics().domain();
            MBeanServer mbeanServer = JmxUtil.lookupMBeanServer((GlobalConfiguration)globalCfg);
            try {
                ObjectName transportMBeanName = new ObjectName(jmxDomain + ":type=Server,component=Transport,name=" + this.serverName);
                return (Integer)mbeanServer.getAttribute(transportMBeanName, "NumberOfLocalConnections");
            }
            catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

