/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateIdException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.utils.ByteUtil;
import org.jboss.logging.Logger;

public class DuplicateIDCacheImpl
implements DuplicateIDCache {
    private static final Logger logger = Logger.getLogger(DuplicateIDCacheImpl.class);
    private final Map<ByteArrayHolder, Integer> cache = new ConcurrentHashMap<ByteArrayHolder, Integer>();
    private final SimpleString address;
    private final ArrayList<Pair<ByteArrayHolder, Long>> ids;
    private int pos;
    private final int cacheSize;
    private final StorageManager storageManager;
    private final boolean persist;

    public DuplicateIDCacheImpl(SimpleString address, int size, StorageManager storageManager, boolean persist) {
        this.address = address;
        this.cacheSize = size;
        this.ids = new ArrayList(size);
        this.storageManager = storageManager;
        this.persist = persist;
    }

    @Override
    public void load(List<Pair<byte[], Long>> theIds) throws Exception {
        long txID = -1L;
        int deleteCount = theIds.size() - this.cacheSize;
        if (deleteCount < 0) {
            deleteCount = 0;
        }
        for (Pair<byte[], Long> id : theIds) {
            if (deleteCount > 0) {
                if (txID == -1L) {
                    txID = this.storageManager.generateID();
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("DuplicateIDCacheImpl::load deleting id=" + this.describeID((byte[])id.getA(), (Long)id.getB())));
                }
                this.storageManager.deleteDuplicateIDTransactional(txID, (Long)id.getB());
                --deleteCount;
                continue;
            }
            ByteArrayHolder bah = new ByteArrayHolder((byte[])id.getA());
            Pair pair = new Pair((Object)bah, id.getB());
            this.cache.put(bah, this.ids.size());
            this.ids.add((Pair<ByteArrayHolder, Long>)pair);
            if (!logger.isTraceEnabled()) continue;
            logger.trace((Object)("DuplicateIDCacheImpl::load loading id=" + this.describeID((byte[])id.getA(), (Long)id.getB())));
        }
        if (txID != -1L) {
            this.storageManager.commit(txID);
        }
        this.pos = this.ids.size();
        if (this.pos == this.cacheSize) {
            this.pos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFromCache(byte[] duplicateID) throws Exception {
        ByteArrayHolder bah;
        Integer posUsed;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("DuplicateIDCacheImpl::deleteFromCache deleting id=" + this.describeID(duplicateID, 0L)));
        }
        if ((posUsed = this.cache.remove(bah = new ByteArrayHolder(duplicateID))) != null) {
            DuplicateIDCacheImpl duplicateIDCacheImpl = this;
            synchronized (duplicateIDCacheImpl) {
                Pair<ByteArrayHolder, Long> id = this.ids.get(posUsed);
                if (((ByteArrayHolder)id.getA()).equals(bah)) {
                    id.setA(null);
                    this.storageManager.deleteDuplicateID((Long)id.getB());
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("DuplicateIDCacheImpl(" + this.address + ")::deleteFromCache deleting id=" + this.describeID(duplicateID, (Long)id.getB())));
                    }
                    id.setB(null);
                }
            }
        }
    }

    private String describeID(byte[] duplicateID, long id) {
        if (id != 0L) {
            return ByteUtil.bytesToHex((byte[])duplicateID, (int)4) + ", simpleString=" + ByteUtil.toSimpleString((byte[])duplicateID);
        }
        return ByteUtil.bytesToHex((byte[])duplicateID, (int)4) + ", simpleString=" + ByteUtil.toSimpleString((byte[])duplicateID) + ", id=" + id;
    }

    @Override
    public boolean contains(byte[] duplID) {
        boolean contains;
        boolean bl = contains = this.cache.get(new ByteArrayHolder(duplID)) != null;
        if (contains) {
            logger.trace((Object)("DuplicateIDCacheImpl(" + this.address + ")::constains found a duplicate " + this.describeID(duplID, 0L)));
        }
        return contains;
    }

    @Override
    public void addToCache(byte[] duplID) throws Exception {
        this.addToCache(duplID, null, false);
    }

    @Override
    public void addToCache(byte[] duplID, Transaction tx) throws Exception {
        this.addToCache(duplID, tx, false);
    }

    @Override
    public synchronized boolean atomicVerify(byte[] duplID, Transaction tx) throws Exception {
        if (this.contains(duplID)) {
            if (tx != null) {
                tx.markAsRollbackOnly((ActiveMQException)new ActiveMQDuplicateIdException());
            }
            return false;
        }
        this.addToCache(duplID, tx, true);
        return true;
    }

    @Override
    public synchronized void addToCache(byte[] duplID, Transaction tx, boolean instantAdd) throws Exception {
        long recordID = -1L;
        if (tx == null) {
            if (this.persist) {
                recordID = this.storageManager.generateID();
                this.storageManager.storeDuplicateID(this.address, duplID, recordID);
            }
            this.addToCacheInMemory(duplID, recordID);
        } else {
            if (this.persist) {
                recordID = this.storageManager.generateID();
                this.storageManager.storeDuplicateIDTransactional(tx.getID(), this.address, duplID, recordID);
                tx.setContainsPersistent();
            }
            if (instantAdd) {
                this.addToCacheInMemory(duplID, recordID);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("DuplicateIDCacheImpl(" + this.address + ")::addToCache Adding duplicateID TX operation for " + this.describeID(duplID, recordID) + ", tx=" + tx));
                }
                tx.addOperation(new AddDuplicateIDOperation(duplID, recordID));
            }
        }
    }

    @Override
    public void load(Transaction tx, byte[] duplID) {
        tx.addOperation(new AddDuplicateIDOperation(duplID, tx.getID()));
    }

    private synchronized void addToCacheInMemory(byte[] duplID, long recordID) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("DuplicateIDCacheImpl(" + this.address + ")::addToCacheInMemory Adding " + this.describeID(duplID, recordID)));
        }
        ByteArrayHolder holder = new ByteArrayHolder(duplID);
        this.cache.put(holder, this.pos);
        if (this.pos < this.ids.size()) {
            Pair<ByteArrayHolder, Long> id = this.ids.get(this.pos);
            if (id.getA() != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("DuplicateIDCacheImpl(" + this.address + ")::addToCacheInMemory removing excess duplicateDetection " + this.describeID(((ByteArrayHolder)id.getA()).bytes, (Long)id.getB())));
                }
                this.cache.remove(id.getA());
                if (id.getB() != null) {
                    try {
                        this.storageManager.deleteDuplicateID((Long)id.getB());
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorDeletingDuplicateCache(e);
                    }
                }
            }
            id.setA((Object)holder);
            id.setB((Object)(recordID >= 0L ? Long.valueOf(recordID) : null));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("DuplicateIDCacheImpl(" + this.address + ")::addToCacheInMemory replacing old duplicateID by " + this.describeID(((ByteArrayHolder)id.getA()).bytes, (Long)id.getB())));
            }
            holder.pos = this.pos;
        } else {
            Pair id = new Pair((Object)holder, (Object)(recordID >= 0L ? Long.valueOf(recordID) : null));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("DuplicateIDCacheImpl(" + this.address + ")::addToCacheInMemory Adding new duplicateID " + this.describeID(((ByteArrayHolder)id.getA()).bytes, (Long)id.getB())));
            }
            this.ids.add((Pair<ByteArrayHolder, Long>)id);
            holder.pos = this.pos;
        }
        if (this.pos++ == this.cacheSize - 1) {
            this.pos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws Exception {
        logger.debug((Object)("DuplicateIDCacheImpl(" + this.address + ")::clear removing duplicate ID data"));
        DuplicateIDCacheImpl duplicateIDCacheImpl = this;
        synchronized (duplicateIDCacheImpl) {
            if (this.ids.size() > 0) {
                long tx = this.storageManager.generateID();
                for (Pair<ByteArrayHolder, Long> id : this.ids) {
                    this.storageManager.deleteDuplicateIDTransactional(tx, (Long)id.getB());
                }
                this.storageManager.commit(tx);
            }
            this.ids.clear();
            this.cache.clear();
            this.pos = 0;
        }
    }

    @Override
    public List<Pair<byte[], Long>> getMap() {
        ArrayList<Pair<byte[], Long>> list = new ArrayList<Pair<byte[], Long>>();
        for (Pair<ByteArrayHolder, Long> id : this.ids) {
            list.add((Pair<byte[], Long>)new Pair((Object)((ByteArrayHolder)id.getA()).bytes, id.getB()));
        }
        return list;
    }

    private static final class ByteArrayHolder {
        final byte[] bytes;
        int hash;
        int pos;

        ByteArrayHolder(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object other) {
            if (other instanceof ByteArrayHolder) {
                ByteArrayHolder s = (ByteArrayHolder)other;
                if (this.bytes.length != s.bytes.length) {
                    return false;
                }
                for (int i = 0; i < this.bytes.length; ++i) {
                    if (this.bytes[i] == s.bytes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == 0) {
                for (byte b : this.bytes) {
                    this.hash = 31 * this.hash + b;
                }
            }
            return this.hash;
        }
    }

    private final class AddDuplicateIDOperation
    extends TransactionOperationAbstract {
        final byte[] duplID;
        final long recordID;
        volatile boolean done;

        AddDuplicateIDOperation(byte[] duplID, long recordID) {
            this.duplID = duplID;
            this.recordID = recordID;
        }

        private void process() {
            if (!this.done) {
                DuplicateIDCacheImpl.this.addToCacheInMemory(this.duplID, this.recordID);
                this.done = true;
            }
        }

        @Override
        public void afterCommit(Transaction tx) {
            this.process();
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }
}

