/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public final class ReplicationPrepareMessage
extends PacketImpl {
    private long txId;
    private byte journalID;
    private EncodingSupport encodingData;
    private byte[] recordData;

    public ReplicationPrepareMessage() {
        super((byte)95);
    }

    public ReplicationPrepareMessage(byte journalID, long txId, EncodingSupport encodingData) {
        this();
        this.journalID = journalID;
        this.txId = txId;
        this.encodingData = encodingData;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeByte(this.journalID);
        buffer.writeLong(this.txId);
        buffer.writeInt(this.encodingData.getEncodeSize());
        this.encodingData.encode(buffer);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.journalID = buffer.readByte();
        this.txId = buffer.readLong();
        int size = buffer.readInt();
        this.recordData = new byte[size];
        buffer.readBytes(this.recordData);
    }

    public long getTxId() {
        return this.txId;
    }

    public byte getJournalID() {
        return this.journalID;
    }

    public byte[] getRecordData() {
        return this.recordData;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.encodingData == null ? 0 : this.encodingData.hashCode());
        result = 31 * result + this.journalID;
        result = 31 * result + Arrays.hashCode(this.recordData);
        result = 31 * result + (int)(this.txId ^ this.txId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationPrepareMessage)) {
            return false;
        }
        ReplicationPrepareMessage other = (ReplicationPrepareMessage)((Object)obj);
        if (this.encodingData == null ? other.encodingData != null : !this.encodingData.equals(other.encodingData)) {
            return false;
        }
        if (this.journalID != other.journalID) {
            return false;
        }
        if (!Arrays.equals(this.recordData, other.recordData)) {
            return false;
        }
        return this.txId == other.txId;
    }
}

