/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.infinispan.commons.CacheException;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.ReplicableCommandManagerFunction;
import org.infinispan.manager.impl.ReplicableCommandRunnable;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.Responses;
import org.infinispan.remoting.transport.jgroups.SingleResponseFuture;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.function.SerializableRunnable;
import org.infinispan.util.function.TriConsumer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.jgroups.blocks.ResponseMode;

public class ClusterExecutorImpl
implements ClusterExecutor {
    private static final Log log = LogFactory.getLog(ClusterExecutorImpl.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final Predicate<? super Address> predicate;
    private final EmbeddedCacheManager manager;
    private final JGroupsTransport transport;
    private final long time;
    private final TimeUnit unit;
    private final Executor localExecutor;
    private final Address me;

    public ClusterExecutorImpl(Predicate<? super Address> predicate, EmbeddedCacheManager manager, JGroupsTransport transport, long time, TimeUnit unit, Executor localExecutor) {
        this.predicate = predicate;
        this.manager = manager;
        this.transport = transport;
        this.me = transport != null ? Objects.requireNonNull(transport.getAddress(), "Transport was not started before retrieving a ClusterExecutor!") : null;
        this.time = time;
        this.unit = unit;
        this.localExecutor = localExecutor;
    }

    private List<org.jgroups.Address> getJGroupsTargets() {
        Address member;
        if (this.transport == null) {
            return Collections.emptyList();
        }
        List<Address> ispnMembers = this.transport.getMembers();
        int size = ispnMembers.size();
        List<Object> list = size == 0 ? Collections.emptyList() : (this.predicate == null ? (size == 1 ? ((member = ispnMembers.get(0)).equals(this.me) ? Collections.emptyList() : Collections.singletonList(ClusterExecutorImpl.convertToJGroupsAddress(member))) : ispnMembers.stream().filter(a -> !a.equals(this.me)).map(ClusterExecutorImpl::convertToJGroupsAddress).collect(Collectors.toList())) : ispnMembers.stream().filter(a -> !a.equals(this.me)).filter(this.predicate).map(ClusterExecutorImpl::convertToJGroupsAddress).collect(Collectors.toList()));
        return list;
    }

    private static org.jgroups.Address convertToJGroupsAddress(Address address) {
        return ((JGroupsAddress)address).getJGroupsAddress();
    }

    private <T> CompletableFuture<T> startLocalInvocation(Function<? super EmbeddedCacheManager, ? extends T> callable) {
        if (this.me == null || this.predicate == null || this.predicate.test(this.me)) {
            if (isTrace) {
                log.trace("Submitting callable to local node on executor thread! - Usually remote command thread pool");
            }
            return CompletableFuture.supplyAsync(() -> {
                try {
                    return callable.apply(this.manager);
                }
                catch (Throwable t) {
                    this.handleCallableRuntimeThrowable(t);
                    throw new CacheException("Problems invoking command.", t);
                }
            }, this.localExecutor);
        }
        return null;
    }

    private CompletableFuture<Void> startLocalInvocation(Runnable runnable) {
        if (this.me == null || this.predicate == null || this.predicate.test(this.me)) {
            if (isTrace) {
                log.trace("Submitting runnable to local node on executor thread! - Usually remote command thread pool");
            }
            return CompletableFuture.runAsync(runnable, this.localExecutor);
        }
        return null;
    }

    @Override
    public void execute(Runnable runnable) {
        this.executeRunnable(runnable, ResponseMode.GET_ALL);
    }

    private void rethrowException(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    private void handleCallableRuntimeThrowable(Throwable t) {
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    private CompletableFuture<?> executeRunnable(Runnable runnable, ResponseMode mode) {
        CompletionStage<Responses> remoteFuture;
        CompletableFuture<Void> localFuture = this.startLocalInvocation(runnable);
        List<org.jgroups.Address> targets = this.getJGroupsTargets();
        int size = targets.size();
        if (size == 1) {
            org.jgroups.Address target = targets.get(0);
            if (isTrace) {
                log.tracef("Submitting runnable to single remote node - JGroups Address %s", target);
            }
            CommandAwareRpcDispatcher card = this.transport.getCommandAwareRpcDispatcher();
            remoteFuture = card.invokeRemoteCommand(target, new ReplicableCommandRunnable(runnable), mode, this.unit.toMillis(this.time), DeliverOrder.NONE).handle((r, t) -> {
                if (t != null) {
                    this.rethrowException((Throwable)t);
                }
                if (r.wasReceived()) {
                    if (r.hasException()) {
                        this.rethrowException(r.getException());
                    }
                } else {
                    if (r.wasSuspected()) {
                        throw log.remoteNodeSuspected(JGroupsAddressCache.fromJGroupsAddress(target));
                    }
                    throw log.remoteNodeTimedOut(JGroupsAddressCache.fromJGroupsAddress(target), this.time, this.unit);
                }
                return null;
            });
        } else if (size > 1) {
            CommandAwareRpcDispatcher card = this.transport.getCommandAwareRpcDispatcher();
            remoteFuture = card.invokeRemoteCommands(targets, new ReplicableCommandRunnable(runnable), mode, this.unit.toMillis(this.time), null, DeliverOrder.NONE);
        } else {
            if (localFuture != null) {
                return localFuture;
            }
            return CompletableFutures.completedExceptionFuture((Throwable)((Object)new SuspectException("No available nodes!")));
        }
        if (localFuture != null && mode != ResponseMode.GET_NONE) {
            return CompletableFuture.allOf(new CompletableFuture[]{localFuture, remoteFuture});
        }
        return remoteFuture;
    }

    @Override
    public void execute(SerializableRunnable runnable) {
        this.execute((Runnable)runnable);
    }

    @Override
    public CompletableFuture<Void> submit(Runnable command) {
        return this.executeRunnable(command, ResponseMode.GET_ALL).handle((r, t) -> {
            if (t != null) {
                this.rethrowException((Throwable)t);
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> submit(SerializableRunnable runnable) {
        return this.submit((Runnable)runnable);
    }

    @Override
    public <V> CompletableFuture<Void> submitConsumer(Function<? super EmbeddedCacheManager, ? extends V> function, TriConsumer<? super Address, ? super V, ? super Throwable> triConsumer) {
        List<org.jgroups.Address> targets;
        int size;
        CompletionStage<Object> localFuture = this.startLocalInvocation(function);
        if (localFuture != null) {
            localFuture = ((CompletableFuture)localFuture).handle((r, t) -> {
                triConsumer.accept(this.me, (Object)r, (Throwable)t);
                return null;
            });
        }
        if ((size = (targets = this.getJGroupsTargets()).size()) > 0) {
            CompletableFuture[] futures = new CompletableFuture[size];
            for (int i = 0; i < size; ++i) {
                CommandAwareRpcDispatcher card = this.transport.getCommandAwareRpcDispatcher();
                org.jgroups.Address target = targets.get(i);
                if (isTrace) {
                    log.tracef("Submitting consumer to single remote node - JGroups Address %s", target);
                }
                SingleResponseFuture srf = card.invokeRemoteCommand(target, new ReplicableCommandManagerFunction(function), ResponseMode.GET_ALL, this.unit.toMillis(this.time), DeliverOrder.NONE);
                futures[i] = srf.handle((r, t) -> {
                    if (t != null) {
                        triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), (Object)null, (Throwable)t);
                    } else if (r.wasReceived()) {
                        if (r.hasException()) {
                            triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), null, r.getException());
                        } else {
                            Response response = (Response)r.getValue();
                            if (response instanceof SuccessfulResponse) {
                                triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), (Object)((SuccessfulResponse)response).getResponseValue(), (Throwable)null);
                            } else if (response instanceof ExceptionResponse) {
                                triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), null, ((ExceptionResponse)response).getException());
                            } else {
                                triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), null, new IllegalStateException("Response was neither successful or an exception!"));
                            }
                        }
                    } else if (r.wasSuspected()) {
                        triConsumer.accept(JGroupsAddressCache.fromJGroupsAddress(target), (Object)null, (Throwable)((Object)new SuspectException()));
                    } else {
                        throw new TimeoutException();
                    }
                    return null;
                });
            }
            CompletableFuture<Void> remoteFutures = CompletableFuture.allOf(futures);
            return localFuture != null ? ((CompletableFuture)localFuture).thenCombine(remoteFutures, (t, u) -> null) : remoteFutures;
        }
        if (localFuture != null) {
            return ((CompletableFuture)localFuture).handle((r, t) -> null);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public <V> CompletableFuture<Void> submitConsumer(SerializableFunction<? super EmbeddedCacheManager, ? extends V> function, TriConsumer<? super Address, ? super V, ? super Throwable> triConsumer) {
        return this.submitConsumer((Function<? super EmbeddedCacheManager, ? extends V>)function, triConsumer);
    }

    @Override
    public ClusterExecutor timeout(long time, TimeUnit unit) {
        if (time <= 0L) {
            throw new IllegalArgumentException("Time must be greater than 0!");
        }
        Objects.requireNonNull(unit, "TimeUnit must be non null!");
        if (this.time == time && this.unit == unit) {
            return this;
        }
        return new ClusterExecutorImpl(this.predicate, this.manager, this.transport, time, unit, this.localExecutor);
    }

    @Override
    public ClusterExecutor filterTargets(Predicate<? super Address> predicate) {
        return new ClusterExecutorImpl(predicate, this.manager, this.transport, this.time, this.unit, this.localExecutor);
    }

    @Override
    public ClusterExecutor filterTargets(Collection<Address> addresses) {
        return this.filterTargets((? super Address address) -> addresses.contains(address));
    }

    @Override
    public ClusterExecutor noFilter() {
        if (this.predicate == null) {
            return this;
        }
        return new ClusterExecutorImpl(this.predicate, this.manager, this.transport, this.time, this.unit, this.localExecutor);
    }
}

