/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.responses;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.remoting.responses.Response;

public class WriteResponse
implements Response {
    public static final AdvancedExternalizer<WriteResponse> EXTERNALIZER = new Externalizer();
    private final Object returnValue;
    private final boolean commandSuccessful;

    public WriteResponse(Object returnValue, boolean commandSuccessful) {
        this.returnValue = returnValue;
        this.commandSuccessful = commandSuccessful;
    }

    public Object getReturnValue() {
        return this.returnValue;
    }

    public boolean isCommandSuccessful() {
        return this.commandSuccessful;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public String toString() {
        return "WriteResponse{returnValue=" + this.returnValue + ", commandSuccessful=" + this.commandSuccessful + '}';
    }

    private static class Externalizer
    extends AbstractExternalizer<WriteResponse> {
        private Externalizer() {
        }

        public void writeObject(ObjectOutput output, WriteResponse response) throws IOException {
            output.writeObject(response.returnValue);
            output.writeBoolean(response.commandSuccessful);
        }

        public WriteResponse readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new WriteResponse(input.readObject(), input.readBoolean());
        }

        public Integer getId() {
            return 118;
        }

        public Set<Class<? extends WriteResponse>> getTypeClasses() {
            return Collections.singleton(WriteResponse.class);
        }
    }
}

