/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web.common;

import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.Map;
import javax.naming.NamingException;
import org.jboss.as.ee.component.ComponentRegistry;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.web.common.ConcurrentReferenceHashMap;

public class WebInjectionContainer {
    private final ClassLoader classloader;
    private final ComponentRegistry componentRegistry;
    private final Map<Object, ManagedReference> instanceMap;

    public WebInjectionContainer(ClassLoader classloader, ComponentRegistry componentRegistry) {
        this.classloader = classloader;
        this.componentRegistry = componentRegistry;
        this.instanceMap = new ConcurrentReferenceHashMap<Object, ManagedReference>(256, 0.75f, Runtime.getRuntime().availableProcessors(), ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
    }

    public void destroyInstance(Object instance) {
        ManagedReference reference = this.instanceMap.remove(instance);
        if (reference != null) {
            reference.release();
        }
    }

    public Object newInstance(String className) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        return this.newInstance(this.classloader.loadClass(className));
    }

    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException {
        ManagedReferenceFactory factory = this.componentRegistry.createInstanceFactory(clazz);
        ManagedReference reference = factory.getReference();
        if (reference != null) {
            this.instanceMap.put(reference.getInstance(), reference);
            return reference.getInstance();
        }
        return clazz.newInstance();
    }

    public void newInstance(Object arg0) throws IllegalAccessException, InvocationTargetException, NamingException {
        ManagedReference reference = this.componentRegistry.createInstance(arg0);
        if (reference != null) {
            this.instanceMap.put(arg0, reference);
        }
    }

    public Object newInstance(String className, ClassLoader cl) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException {
        return this.newInstance(cl.loadClass(className));
    }

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }
}

