/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.client;

import io.undertow.client.ALPNClientSelector;
import io.undertow.client.ClientCallback;
import io.undertow.client.ClientConnection;
import io.undertow.protocols.ssl.UndertowXnioSsl;
import io.undertow.util.ALPN;
import io.undertow.util.ImmediatePooled;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.util.HashMap;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.xnio.ChannelListener;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.conduits.PushBackStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;
import org.xnio.ssl.SslConnection;

public class JDK9ALPNClientProvider
implements ALPNClientSelector.ClientSelector {
    @Override
    public void runAlpn(final SslConnection connection, final ChannelListener<SslConnection> fallback, final ClientCallback<ClientConnection> failedListener, ALPNClientSelector.ALPNProtocol ... details) {
        final SSLEngine sslEngine = UndertowXnioSsl.getSslEngine(connection);
        final HashMap<String, ALPNClientSelector.ALPNProtocol> protocolMap = new HashMap<String, ALPNClientSelector.ALPNProtocol>();
        String[] protocols = new String[details.length];
        for (int i = 0; i < details.length; ++i) {
            protocols[i] = details[i].getProtocol();
            protocolMap.put(details[i].getProtocol(), details[i]);
        }
        try {
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            ALPN.JDK_9_ALPN_METHODS.setApplicationProtocols().invoke((Object)sslParameters, new Object[]{protocols});
            sslEngine.setSSLParameters(sslParameters);
        }
        catch (Exception e) {
            fallback.handleEvent((Channel)connection);
            return;
        }
        try {
            connection.startHandshake();
            connection.getSourceChannel().getReadSetter().set((ChannelListener)new ChannelListener<StreamSourceChannel>(){

                public void handleEvent(StreamSourceChannel channel) {
                    try {
                        String selected = (String)ALPN.JDK_9_ALPN_METHODS.getApplicationProtocol().invoke((Object)sslEngine, new Object[0]);
                        if (selected != null) {
                            this.handleSelected(selected);
                        } else {
                            ByteBuffer buf = ByteBuffer.allocate(100);
                            int read = channel.read(buf);
                            if (read > 0) {
                                buf.flip();
                                PushBackStreamSourceConduit pb = new PushBackStreamSourceConduit(connection.getSourceChannel().getConduit());
                                pb.pushBack(new ImmediatePooled<ByteBuffer>(buf));
                                connection.getSourceChannel().setConduit((StreamSourceConduit)pb);
                            } else if (read == -1) {
                                failedListener.failed(new ClosedChannelException());
                            }
                            selected = (String)ALPN.JDK_9_ALPN_METHODS.getApplicationProtocol().invoke((Object)sslEngine, new Object[0]);
                            if (selected != null) {
                                this.handleSelected(selected);
                            } else if (read > 0) {
                                connection.getSourceChannel().suspendReads();
                                fallback.handleEvent((Channel)connection);
                                return;
                            }
                        }
                    }
                    catch (IOException e) {
                        failedListener.failed(e);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        failedListener.failed(new IOException(e));
                    }
                }

                protected void handleSelected(String selected) {
                    if (selected.isEmpty()) {
                        connection.getSourceChannel().suspendReads();
                        fallback.handleEvent((Channel)connection);
                        return;
                    }
                    ALPNClientSelector.ALPNProtocol details = (ALPNClientSelector.ALPNProtocol)protocolMap.get(selected);
                    if (details == null) {
                        connection.getSourceChannel().suspendReads();
                        fallback.handleEvent((Channel)connection);
                        return;
                    }
                    connection.getSourceChannel().suspendReads();
                    details.getSelected().handleEvent((Channel)connection);
                }
            });
            connection.getSourceChannel().resumeReads();
        }
        catch (IOException e) {
            failedListener.failed(e);
        }
        catch (Throwable e) {
            failedListener.failed(new IOException(e));
        }
    }

    @Override
    public boolean isEnabled() {
        return ALPN.JDK_9_ALPN_METHODS != null;
    }
}

