/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.BitSet;
import java.util.Collection;
import java.util.PrimitiveIterator;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;

public class SmallIntSet
implements Set<Integer> {
    private final BitSet bitSet;

    public static SmallIntSet of(int i1) {
        SmallIntSet set = new SmallIntSet();
        set.set(i1);
        return set;
    }

    public static SmallIntSet of(int i1, int i2) {
        SmallIntSet set = new SmallIntSet();
        set.set(i1);
        set.set(i2);
        return set;
    }

    public static SmallIntSet of(int i1, int i2, int i3) {
        SmallIntSet set = new SmallIntSet();
        set.set(i1);
        set.set(i2);
        set.set(i3);
        return set;
    }

    public static SmallIntSet of(int ... elements) {
        SmallIntSet set = new SmallIntSet();
        for (int i : elements) {
            set.set(i);
        }
        return set;
    }

    public SmallIntSet() {
        this.bitSet = new BitSet();
    }

    public SmallIntSet(int initialRange) {
        this.bitSet = new BitSet(initialRange);
    }

    public SmallIntSet(SmallIntSet other) {
        this.bitSet = new BitSet(other.bitSet.size());
        this.bitSet.or(other.bitSet);
    }

    public SmallIntSet(Set<Integer> set) {
        this.bitSet = new BitSet();
        set.forEach(this.bitSet::set);
    }

    @Override
    public int size() {
        return this.bitSet.cardinality();
    }

    public int capacity() {
        return this.bitSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.bitSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Integer && this.contains((Integer)o);
    }

    public boolean contains(Integer o) {
        return this.bitSet.get(o);
    }

    public boolean contains(int i) {
        return this.bitSet.get(i);
    }

    public PrimitiveIterator.OfInt iterator() {
        return this.bitSet.stream().iterator();
    }

    @Override
    public Object[] toArray() {
        int size = this.size();
        Object[] dest = new Integer[size];
        this.copyToArray(size, (Integer[])dest);
        return dest;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (!(a instanceof Integer[])) {
            throw new IllegalArgumentException("Only Integer arrays are supported");
        }
        int size = this.size();
        Integer[] dest = a.length < size ? new Integer[size] : (Integer[])a;
        this.copyToArray(size, dest);
        return dest;
    }

    private void copyToArray(int size, Integer[] dest) {
        int lastSetBit = -1;
        for (int i = 0; i < size; ++i) {
            lastSetBit = this.bitSet.nextSetBit(lastSetBit + 1);
            dest[i] = lastSetBit;
        }
    }

    @Override
    public boolean add(Integer i) {
        return this.add((int)i);
    }

    @Override
    public boolean add(int i) {
        boolean wasSet = this.bitSet.get(i);
        if (!wasSet) {
            this.bitSet.set(i);
            return true;
        }
        return false;
    }

    public void set(int i) {
        this.bitSet.set(i);
    }

    public void set(int i, boolean value) {
        this.bitSet.set(i, value);
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Integer)) {
            return false;
        }
        return this.remove((Integer)o);
    }

    public boolean remove(int i) {
        boolean wasSet = this.bitSet.get(i);
        if (wasSet) {
            this.bitSet.clear(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        boolean modified = false;
        for (Integer n : c) {
            modified |= this.add(n);
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        for (Object integer : c) {
            modified |= this.remove(integer);
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        int i = this.bitSet.nextSetBit(0);
        while (i >= 0) {
            if (!c.contains(i)) {
                this.bitSet.clear(i);
                modified = true;
            }
            i = this.bitSet.nextSetBit(i + 1);
        }
        return modified;
    }

    @Override
    public void clear() {
        this.bitSet.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Set)) {
            return false;
        }
        if (o instanceof SmallIntSet) {
            SmallIntSet integers = (SmallIntSet)o;
            return this.bitSet.equals(integers.bitSet);
        }
        Set set = (Set)o;
        return this.size() == set.size() && this.containsAll(set);
    }

    @Override
    public int hashCode() {
        return this.bitSet.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        int i = this.bitSet.nextSetBit(0);
        while (i >= 0) {
            if (sb.length() > "{".length()) {
                sb.append(' ');
            }
            int runStart = i;
            while (this.bitSet.get(i + 1)) {
                ++i;
            }
            if (i == runStart) {
                sb.append(i);
            } else {
                sb.append(runStart).append('-').append(i);
            }
            i = this.bitSet.nextSetBit(i + 1);
        }
        sb.append('}');
        return sb.toString();
    }

    public static void writeTo(ObjectOutput output, SmallIntSet set) throws IOException {
        UnsignedNumeric.writeUnsignedInt(output, set.capacity());
        UnsignedNumeric.writeUnsignedInt(output, set.size());
        PrimitiveIterator.OfInt ofInt = set.iterator();
        while (ofInt.hasNext()) {
            int element = (Integer)ofInt.next();
            UnsignedNumeric.writeUnsignedInt(output, element);
        }
    }

    public static SmallIntSet readFrom(ObjectInput input) throws IOException {
        int capacity = UnsignedNumeric.readUnsignedInt(input);
        int size = UnsignedNumeric.readUnsignedInt(input);
        SmallIntSet set = new SmallIntSet(capacity);
        for (int i = 0; i < size; ++i) {
            int element = UnsignedNumeric.readUnsignedInt(input);
            set.set(element);
        }
        return set;
    }
}

