/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.ping.kube;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.ping.common.OpenshiftPing;
import org.jgroups.ping.common.Utils;
import org.jgroups.ping.common.stream.CertificateStreamProvider;
import org.jgroups.ping.common.stream.InsecureStreamProvider;
import org.jgroups.ping.common.stream.StreamProvider;
import org.jgroups.ping.kube.Client;
import org.jgroups.ping.kube.Container;
import org.jgroups.ping.kube.Pod;
import org.jgroups.ping.kube.Port;

@MBean(description="Kubernetes based discovery protocol")
public class KubePing
extends OpenshiftPing {
    public static final short KUBERNETES_PING_ID = 2010;
    public static final short JGROUPS_KUBE_PING_ID = 2011;
    @Property
    private String masterProtocol;
    @Property
    private String masterHost;
    @Property
    private int masterPort;
    @Property
    private String apiVersion = "v1";
    @Property
    private String namespace;
    private String _namespace;
    @Property
    private String labels;
    private String _labels;
    @Property
    private int serverPort = 8888;
    private int _serverPort;
    @Property
    private String clientCertFile;
    @Property
    private String clientKeyFile;
    @Property
    private String clientKeyPassword;
    @Property
    private String clientKeyAlgo = "RSA";
    @Property
    private String caCertFile;
    @Property
    private String saTokenFile = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    private Client _client;

    public KubePing() {
        super("OPENSHIFT_KUBE_PING_");
    }

    public void setMasterProtocol(String masterProtocol) {
        this.masterProtocol = masterProtocol;
    }

    public void setMasterHost(String masterMost) {
        this.masterHost = masterMost;
    }

    public void setMasterPort(int masterPort) {
        this.masterPort = masterPort;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    protected boolean isClusteringEnabled() {
        return this._namespace != null;
    }

    protected int getServerPort() {
        return this._serverPort;
    }

    protected Client getClient() {
        return this._client;
    }

    public void init() throws Exception {
        InsecureStreamProvider streamProvider;
        int mPort;
        String mHost;
        super.init();
        this._namespace = Utils.getSystemEnv((String)this.getSystemEnvName("NAMESPACE"), (String)this.namespace, (boolean)true);
        if (this._namespace == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info(String.format("namespace not set; clustering disabled", new Object[0]));
            }
            return;
        }
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format("namespace [%s] set; clustering enabled", this._namespace));
        }
        String mProtocol = Utils.getSystemEnv((String)this.getSystemEnvName("MASTER_PROTOCOL"), (String)this.masterProtocol, (boolean)true);
        HashMap<String, String> headers = new HashMap<String, String>();
        String cCertFile = Utils.getSystemEnv((String[])new String[]{this.getSystemEnvName("CLIENT_CERT_FILE"), "KUBERNETES_CLIENT_CERTIFICATE_FILE"}, (String)this.clientCertFile, (boolean)true);
        if (cCertFile != null) {
            if (mProtocol == null) {
                mProtocol = "http";
            }
            mHost = Utils.getSystemEnv((String[])new String[]{this.getSystemEnvName("MASTER_HOST"), "KUBERNETES_RO_SERVICE_HOST"}, (String)this.masterHost, (boolean)true);
            mPort = Utils.getSystemEnvInt((String[])new String[]{this.getSystemEnvName("MASTER_PORT"), "KUBERNETES_RO_SERVICE_PORT"}, (int)this.masterPort);
            String cKeyFile = Utils.getSystemEnv((String[])new String[]{this.getSystemEnvName("CLIENT_KEY_FILE"), "KUBERNETES_CLIENT_KEY_FILE"}, (String)this.clientKeyFile, (boolean)true);
            String cKeyPassword = Utils.getSystemEnv((String[])new String[]{this.getSystemEnvName("CLIENT_KEY_PASSWORD"), "KUBERNETES_CLIENT_KEY_PASSWORD"}, (String)this.clientKeyPassword, (boolean)false);
            String cKeyAlgo = Utils.getSystemEnv((String[])new String[]{this.getSystemEnvName("CLIENT_KEY_ALGO"), "KUBERNETES_CLIENT_KEY_ALGO"}, (String)this.clientKeyAlgo, (boolean)true);
            String lCaCertFile = Utils.getSystemEnv((String[])new String[]{this.getSystemEnvName("CA_CERT_FILE"), "KUBERNETES_CA_CERTIFICATE_FILE"}, (String)this.caCertFile, (boolean)true);
            streamProvider = new CertificateStreamProvider(cCertFile, cKeyFile, cKeyPassword, cKeyAlgo, lCaCertFile);
        } else {
            if (mProtocol == null) {
                mProtocol = "https";
            }
            mHost = Utils.getSystemEnv((String[])new String[]{this.getSystemEnvName("MASTER_HOST"), "KUBERNETES_SERVICE_HOST"}, (String)this.masterHost, (boolean)true);
            mPort = Utils.getSystemEnvInt((String[])new String[]{this.getSystemEnvName("MASTER_PORT"), "KUBERNETES_SERVICE_PORT"}, (int)this.masterPort);
            String saToken = Utils.readFileToString((String)Utils.getSystemEnv((String)this.getSystemEnvName("SA_TOKEN_FILE"), (String)this.saTokenFile, (boolean)true));
            if (saToken != null) {
                headers.put("Authorization", "Bearer " + saToken);
            }
            streamProvider = new InsecureStreamProvider();
        }
        String ver = Utils.getSystemEnv((String)this.getSystemEnvName("API_VERSION"), (String)this.apiVersion, (boolean)true);
        String url = String.format("%s://%s:%s/api/%s", mProtocol, mHost, mPort, ver);
        this._labels = Utils.getSystemEnv((String)this.getSystemEnvName("LABELS"), (String)this.labels, (boolean)true);
        this._serverPort = Utils.getSystemEnvInt((String)this.getSystemEnvName("SERVER_PORT"), (int)this.serverPort);
        this._client = new Client(url, headers, this.getConnectTimeout(), this.getReadTimeout(), this.getOperationAttempts(), this.getOperationSleep(), (StreamProvider)streamProvider, this._serverPort);
        if (this.log.isDebugEnabled()) {
            this.log.debug("KubePING configuration: " + this.toString());
        }
    }

    public void destroy() {
        this._namespace = null;
        this._labels = null;
        this._serverPort = 0;
        this._client = null;
        super.destroy();
    }

    protected synchronized List<InetSocketAddress> doReadAll(String clusterName) {
        List<Pod> pods;
        Client client = this.getClient();
        try {
            pods = client.getPods(this._namespace, this._labels);
        }
        catch (Exception e) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(String.format("Problem getting Pod json from Kubernetes %s for cluster [%s], namespace [%s], labels [%s]; encountered [%s: %s]", client.info(), clusterName, this._namespace, this._labels, e.getClass().getName(), e.getMessage()));
            }
            pods = Collections.emptyList();
        }
        ArrayList<InetSocketAddress> retval = new ArrayList<InetSocketAddress>();
        for (Pod pod : pods) {
            pod.getContainers().stream().filter(container -> client.accept((Container)container)).flatMap(container -> container.getPorts().stream()).filter(port -> client.accept((Port)port)).map(port -> port.getContainerPort()).forEach(portAsInt -> retval.add(new InetSocketAddress(pod.getPodIP(), (int)portAsInt)));
        }
        return retval;
    }

    public String toString() {
        return "KubePing{_namespace='" + this._namespace + '\'' + ", _labels='" + this._labels + '\'' + ", _serverPort=" + this._serverPort + '}';
    }

    static {
        ClassConfigurator.addProtocol((short)2010, KubePing.class);
    }
}

