/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.metadata.impl.BackReference;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.util.impl.ReflectionHelper;

public class PropertyMetadata {
    private final BackReference<TypeMetadata> declaringType;
    private final XProperty propertyAccessor;
    private final Class<?> propertyClass;
    private final Map<String, DocumentFieldMetadata> documentFieldMetadataMap;
    private final Set<DocumentFieldMetadata> documentFieldMetadataList;
    private final Set<SortableFieldMetadata> sortableFieldMetadata;
    private final BoostStrategy dynamicBoostStrategy;
    private final String propertyAccessorName;

    private PropertyMetadata(Builder builder) {
        this.declaringType = builder.declaringType;
        this.propertyAccessor = builder.propertyAccessor;
        this.propertyClass = builder.propertyClass;
        this.documentFieldMetadataList = Collections.unmodifiableSet(builder.fieldMetadataSet);
        this.documentFieldMetadataMap = this.createDocumentFieldMetadataMap(builder.fieldMetadataSet);
        this.sortableFieldMetadata = Collections.unmodifiableSet(builder.sortableFieldMetadata);
        this.propertyAccessorName = this.propertyAccessor == null ? null : this.propertyAccessor.getName();
        this.dynamicBoostStrategy = builder.dynamicBoostStrategy != null ? builder.dynamicBoostStrategy : DefaultBoostStrategy.INSTANCE;
    }

    private Map<String, DocumentFieldMetadata> createDocumentFieldMetadataMap(Set<DocumentFieldMetadata> fieldMetadataSet) {
        LinkedHashMap<String, DocumentFieldMetadata> tmpMap = new LinkedHashMap<String, DocumentFieldMetadata>();
        for (DocumentFieldMetadata documentFieldMetadata : fieldMetadataSet) {
            tmpMap.put(documentFieldMetadata.getAbsoluteName(), documentFieldMetadata);
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    public TypeMetadata getDeclaringType() {
        return this.declaringType.get();
    }

    public XProperty getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public Class<?> getPropertyClass() {
        return this.propertyClass;
    }

    public String getPropertyAccessorName() {
        return this.propertyAccessorName;
    }

    @Deprecated
    public List<DocumentFieldMetadata> getFieldMetadata() {
        return new ArrayList<DocumentFieldMetadata>(this.documentFieldMetadataList);
    }

    public Set<DocumentFieldMetadata> getFieldMetadataSet() {
        return this.documentFieldMetadataList;
    }

    public DocumentFieldMetadata getFieldMetadata(String fieldName) {
        return this.documentFieldMetadataMap.get(fieldName);
    }

    public Set<SortableFieldMetadata> getSortableFieldMetadata() {
        return this.sortableFieldMetadata;
    }

    public BoostStrategy getDynamicBoostStrategy() {
        return this.dynamicBoostStrategy;
    }

    public String toString() {
        return "PropertyMetadata{propertyAccessor=" + this.propertyAccessor + ", fieldMetadata=" + this.documentFieldMetadataList + ", dynamicBoostStrategy=" + this.dynamicBoostStrategy + '}';
    }

    public static class Builder {
        private final BackReference<PropertyMetadata> resultReference = new BackReference();
        private final BackReference<TypeMetadata> declaringType;
        private final XProperty propertyAccessor;
        private final Class<?> propertyClass;
        private final Set<DocumentFieldMetadata> fieldMetadataSet;
        private final Set<SortableFieldMetadata> sortableFieldMetadata;
        private BoostStrategy dynamicBoostStrategy;

        public Builder(BackReference<TypeMetadata> declaringType, XProperty propertyAccessor, Class<?> propertyClass) {
            this.declaringType = declaringType;
            if (propertyAccessor != null) {
                ReflectionHelper.setAccessible((XMember)propertyAccessor);
            }
            this.propertyAccessor = propertyAccessor;
            this.propertyClass = propertyClass;
            this.fieldMetadataSet = new LinkedHashSet<DocumentFieldMetadata>();
            this.sortableFieldMetadata = new LinkedHashSet<SortableFieldMetadata>();
        }

        public Builder dynamicBoostStrategy(BoostStrategy boostStrategy) {
            this.dynamicBoostStrategy = boostStrategy;
            return this;
        }

        public Builder addDocumentField(DocumentFieldMetadata documentFieldMetadata) {
            this.fieldMetadataSet.add(documentFieldMetadata);
            return this;
        }

        public Builder addSortableField(SortableFieldMetadata sortableField) {
            this.sortableFieldMetadata.add(sortableField);
            return this;
        }

        public XProperty getPropertyAccessor() {
            return this.propertyAccessor;
        }

        public Set<DocumentFieldMetadata> getFieldMetadata() {
            return this.fieldMetadataSet;
        }

        public BackReference<PropertyMetadata> getResultReference() {
            return this.resultReference;
        }

        public PropertyMetadata build() {
            PropertyMetadata result = new PropertyMetadata(this);
            this.resultReference.initialize(result);
            return result;
        }
    }
}

