/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class StandardServiceManager
implements ServiceManager {
    private static final Log log = LoggerFactory.make();
    private final Properties properties;
    private final BuildContext buildContext;
    private final ConcurrentHashMap<Class<?>, ServiceWrapper<?>> cachedServices = new ConcurrentHashMap();
    private final Map<Class<? extends Service>, Object> providedServices;
    private final Map<Class<? extends Service>, String> defaultServices;
    private final ClassLoaderService classloaderService;
    private final boolean failOnUnreleasedService;
    private volatile boolean allServicesReleased = false;

    public StandardServiceManager(SearchConfiguration searchConfiguration, BuildContext buildContext) {
        this(searchConfiguration, buildContext, Collections.emptyMap());
    }

    public StandardServiceManager(SearchConfiguration searchConfiguration, BuildContext buildContext, Map<Class<? extends Service>, String> defaultServices) {
        this.buildContext = buildContext;
        this.properties = searchConfiguration.getProperties();
        this.providedServices = this.createProvidedServices(searchConfiguration);
        this.defaultServices = defaultServices;
        this.classloaderService = searchConfiguration.getClassLoaderService();
        this.failOnUnreleasedService = Boolean.getBoolean("org.hibernate.search.fail_on_unreleased_service");
    }

    @Override
    public <S extends Service> S requestService(Class<S> serviceRole) {
        if (serviceRole == null) {
            throw new IllegalArgumentException("'null' is not a valid service role");
        }
        if (this.allServicesReleased) {
            throw log.serviceRequestedAfterReleasedAllWasCalled();
        }
        Object providedService = this.providedServices.get(serviceRole);
        if (providedService != null) {
            return (S)((Service)providedService);
        }
        ServiceWrapper<Object> wrapper = this.cachedServices.get(serviceRole);
        if (wrapper == null) {
            wrapper = this.createAndCacheWrapper(serviceRole);
        }
        wrapper.startVirtual();
        return (S)((Service)wrapper.getService());
    }

    @Override
    public <S extends Service> ServiceReference<S> requestReference(Class<S> serviceRole) {
        return new ServiceReference<S>(this, serviceRole);
    }

    @Override
    public <S extends Service> void releaseService(Class<S> serviceRole) {
        if (serviceRole == null) {
            throw new IllegalArgumentException("'null' is not a valid service role");
        }
        if (this.providedServices.containsKey(serviceRole)) {
            return;
        }
        ServiceWrapper<?> wrapper = this.cachedServices.get(serviceRole);
        if (wrapper != null) {
            wrapper.stopVirtual();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseAllServices() {
        for (ServiceWrapper<?> wrapper : this.cachedServices.values()) {
            wrapper.stopVirtual();
        }
        ArrayList<String> unreleasedServicesToReport = this.failOnUnreleasedService ? new ArrayList<String>() : null;
        Iterator<ServiceWrapper<?>> iterator = this.cachedServices.values().iterator();
        while (iterator.hasNext()) {
            ServiceWrapper<?> wrapper;
            ServiceWrapper<?> serviceWrapper = wrapper = iterator.next();
            synchronized (serviceWrapper) {
                if (((ServiceWrapper)wrapper).status != ServiceStatus.STOPPED) {
                    log.serviceProviderNotReleased(((ServiceWrapper)wrapper).serviceClass);
                    wrapper.stopReal();
                    if (unreleasedServicesToReport != null) {
                        unreleasedServicesToReport.add(((ServiceWrapper)wrapper).serviceClass.getName());
                    }
                }
            }
        }
        this.cachedServices.clear();
        this.allServicesReleased = true;
        if (this.failOnUnreleasedService && !unreleasedServicesToReport.isEmpty()) {
            throw new AssertionFailure("The following services have been used but not released: " + unreleasedServicesToReport);
        }
    }

    private Map<Class<? extends Service>, Object> createProvidedServices(SearchConfiguration searchConfiguration) {
        HashMap<Class<? extends Service>, Object> tmpServices = new HashMap<Class<? extends Service>, Object>(searchConfiguration.getProvidedServices());
        if (tmpServices.containsKey(ClassLoaderService.class)) {
            throw log.classLoaderServiceContainedInProvidedServicesException();
        }
        tmpServices.put(ClassLoaderService.class, searchConfiguration.getClassLoaderService());
        return Collections.unmodifiableMap(tmpServices);
    }

    private synchronized <S extends Service> ServiceWrapper<S> createAndCacheWrapper(Class<S> serviceRole) {
        ServiceWrapper<?> existingWrapper = this.cachedServices.get(serviceRole);
        if (existingWrapper != null) {
            return existingWrapper;
        }
        HashSet<Service> services = new HashSet<Service>();
        for (Service service : this.requestService(ClassLoaderService.class).loadJavaServices(serviceRole)) {
            services.add(service);
        }
        if (services.size() == 0) {
            this.tryLoadingDefaultService(serviceRole, services);
        } else if (services.size() > 1) {
            throw log.getMultipleServiceImplementationsException(serviceRole.toString(), StringHelper.join(services, ","));
        }
        Service service = (Service)services.iterator().next();
        ServiceWrapper<Service> wrapper = new ServiceWrapper<Service>(service, serviceRole, this.buildContext);
        ServiceWrapper<Service> previousWrapper = this.cachedServices.putIfAbsent(serviceRole, wrapper);
        if (previousWrapper != null) {
            wrapper = previousWrapper;
        } else {
            wrapper.startVirtual();
        }
        return wrapper;
    }

    private <S extends Service> void tryLoadingDefaultService(Class<S> serviceRole, Set<S> services) {
        if (!this.defaultServices.containsKey(serviceRole)) {
            throw log.getNoServiceImplementationFoundException(serviceRole.toString());
        }
        Service service = (Service)ClassLoaderHelper.instanceFromName(serviceRole, this.defaultServices.get(serviceRole), "default service", this);
        services.add(service);
    }

    @Override
    public ClassLoaderService getClassLoaderService() {
        return this.classloaderService;
    }

    private static enum ServiceStatus {
        RUNNING,
        STOPPED,
        STARTING,
        STOPPING;

    }

    private class ServiceWrapper<S> {
        private final S service;
        private final BuildContext context;
        private final Class<S> serviceClass;
        private int userCounter = 0;
        private ServiceStatus status = ServiceStatus.STOPPED;

        ServiceWrapper(S service, Class<S> serviceClass, BuildContext context) {
            this.service = service;
            this.context = context;
            this.serviceClass = serviceClass;
        }

        synchronized S getService() {
            if (this.status != ServiceStatus.RUNNING) {
                this.stateExpectedFailure();
            }
            return this.service;
        }

        synchronized void startVirtual() {
            int previousValue;
            if ((previousValue = this.userCounter++) == 0) {
                if (this.status != ServiceStatus.STOPPED) {
                    this.stateExpectedFailure();
                }
                this.startService(this.service);
            }
            if (this.status != ServiceStatus.RUNNING) {
                this.stateExpectedFailure();
            }
        }

        synchronized void stopVirtual() {
            --this.userCounter;
            if (this.userCounter == 0) {
                this.stopReal();
            }
        }

        synchronized void stopReal() {
            this.status = ServiceStatus.STOPPING;
            try {
                if (this.service instanceof Stoppable) {
                    ((Stoppable)this.service).stop();
                }
            }
            catch (Exception e) {
                log.stopServiceFailed(this.serviceClass, e);
            }
            finally {
                this.status = ServiceStatus.STOPPED;
            }
        }

        private void startService(S service) {
            this.status = ServiceStatus.STARTING;
            if (service instanceof Startable) {
                ((Startable)service).start(StandardServiceManager.this.properties, this.context);
            }
            this.status = ServiceStatus.RUNNING;
        }

        private void stateExpectedFailure() {
            throw log.getUnexpectedServiceStatusException(this.status.name(), this.service.toString());
        }
    }
}

