/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSet;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.jboss.GenericJBossMarshaller;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.upgrade.SourceMigrator;

class HotRodSourceMigrator
implements SourceMigrator {
    private static final String KNOWN_KEY = "___MigrationManager_HotRod_KnownKeys___";
    private final AdvancedCache<byte[], byte[]> cache;
    private final Marshaller marshaller;

    public String getCacheName() {
        return this.cache.getName();
    }

    HotRodSourceMigrator(AdvancedCache<byte[], byte[]> cache) {
        this.cache = cache;
        this.marshaller = new GenericJBossMarshaller();
    }

    public void recordKnownGlobalKeyset() {
        try {
            byte[] bak = this.marshaller.objectToByteBuffer((Object)KNOWN_KEY);
            CacheSet allKeys = this.cache.keySet();
            Set copy = allKeys.stream().collect(Collectors.toSet());
            copy.remove(bak);
            Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(1L)).build();
            this.cache.put((Object)bak, (Object)this.marshaller.objectToByteBuffer(copy), metadata);
        }
        catch (IOException | InterruptedException e) {
            throw new CacheException((Throwable)e);
        }
    }
}

