/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries;

import org.infinispan.atomic.impl.AtomicHashMap;
import org.infinispan.commons.util.Util;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.MVCCEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReadCommittedEntry
implements MVCCEntry {
    private static final Log log = LogFactory.getLog(ReadCommittedEntry.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object key;
    protected Object value;
    protected long created;
    protected long lastUsed;
    protected byte flags = 0;
    protected Metadata metadata;

    public ReadCommittedEntry(Object key, Object value, Metadata metadata) {
        this.setValid(true);
        this.key = key;
        this.value = value;
        this.metadata = metadata;
    }

    final boolean isFlagSet(Flags flag) {
        return (this.flags & flag.mask) != 0;
    }

    protected final void setFlag(Flags flag) {
        this.flags = (byte)(this.flags | flag.mask);
    }

    private void unsetFlag(Flags flag) {
        this.flags = (byte)(this.flags & ~flag.mask);
    }

    @Override
    public final long getLifespan() {
        return this.metadata.lifespan();
    }

    @Override
    public final long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public final Object getKey() {
        return this.key;
    }

    @Override
    public final Object getValue() {
        return this.value;
    }

    @Override
    public boolean isNull() {
        return this.value == null;
    }

    @Override
    public final void commit(DataContainer container, Metadata providedMetadata) {
        if (this.isChanged()) {
            if (trace) {
                log.tracef("Updating entry (key=%s removed=%s valid=%s changed=%s created=%s value=%s metadata=%s, providedMetadata=%s)", new Object[]{Util.toStr((Object)this.getKey()), this.isRemoved(), this.isValid(), this.isChanged(), this.isCreated(), Util.toStr((Object)this.value), this.getMetadata(), providedMetadata});
            }
            if (this.value instanceof AtomicHashMap) {
                AtomicHashMap ahm = (AtomicHashMap)this.value;
                if (this.isRemoved() && !this.isEvicted()) {
                    ahm.markRemoved(true);
                }
            }
            if (this.isEvicted()) {
                container.evict(this.key);
            } else if (this.isRemoved()) {
                container.remove(this.key);
            } else if (this.value != null) {
                container.put(this.key, this.value, providedMetadata == null ? this.metadata : providedMetadata);
            }
        }
    }

    @Override
    public final boolean isChanged() {
        return this.isFlagSet(Flags.CHANGED);
    }

    @Override
    public final void setChanged(boolean changed) {
        this.setFlag(changed, Flags.CHANGED);
    }

    @Override
    public void setSkipLookup(boolean skipLookup) {
    }

    @Override
    public boolean skipLookup() {
        return false;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public Object setValue(Object value) {
        Object prev = this.value;
        this.value = value;
        return prev;
    }

    @Override
    public boolean isValid() {
        return this.isFlagSet(Flags.VALID);
    }

    @Override
    public final void setValid(boolean valid) {
        this.setFlag(valid, Flags.VALID);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public final boolean isCreated() {
        return this.isFlagSet(Flags.CREATED);
    }

    @Override
    public final void setCreated(boolean created) {
        this.setFlag(created, Flags.CREATED);
    }

    @Override
    public boolean isRemoved() {
        return this.isFlagSet(Flags.REMOVED);
    }

    @Override
    public boolean isEvicted() {
        return this.isFlagSet(Flags.EVICTED);
    }

    @Override
    public boolean isExpired() {
        return this.isFlagSet(Flags.EXPIRED);
    }

    @Override
    public void resetCurrentValue() {
    }

    @Override
    public void updatePreviousValue() {
    }

    @Override
    public final void setRemoved(boolean removed) {
        this.setFlag(removed, Flags.REMOVED);
    }

    @Override
    public void setEvicted(boolean evicted) {
        this.setFlag(evicted, Flags.EVICTED);
    }

    @Override
    public void setExpired(boolean expired) {
        this.setFlag(expired, Flags.EXPIRED);
    }

    @Override
    @Deprecated
    public boolean isLoaded() {
        return false;
    }

    @Override
    @Deprecated
    public void setLoaded(boolean loaded) {
    }

    final void setFlag(boolean enable, Flags flag) {
        if (enable) {
            this.setFlag(flag);
        } else {
            this.unsetFlag(flag);
        }
    }

    public ReadCommittedEntry clone() {
        try {
            return (ReadCommittedEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setCreated(long created) {
        this.created = created;
    }

    @Override
    public void setLastUsed(long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + Util.hexIdHashCode((Object)this) + "){key=" + Util.toStr((Object)this.key) + ", value=" + Util.toStr((Object)this.value) + ", isCreated=" + this.isCreated() + ", isChanged=" + this.isChanged() + ", isRemoved=" + this.isRemoved() + ", isValid=" + this.isValid() + ", isExpired=" + this.isExpired() + ", skipLookup=" + this.skipLookup() + ", metadata=" + this.metadata + '}';
    }

    protected static enum Flags {
        CHANGED(1),
        CREATED(2),
        REMOVED(4),
        VALID(8),
        EVICTED(16),
        EXPIRED(32),
        SKIP_LOOKUP(64),
        READ(128);

        final byte mask;

        private Flags(int mask) {
            this.mask = (byte)mask;
        }
    }
}

