/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security.impl;

import java.security.AccessControlException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AuthorizationConfiguration;
import org.infinispan.configuration.global.GlobalSecurityConfiguration;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuditLogger;
import org.infinispan.security.AuditResponse;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.Role;
import org.infinispan.security.Security;
import org.infinispan.security.impl.CachePrincipalPair;
import org.infinispan.security.impl.SubjectACL;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class AuthorizationHelper {
    private static final Log log = LogFactory.getLog(AuthorizationHelper.class);
    private static final boolean trace = log.isTraceEnabled();
    private final GlobalSecurityConfiguration globalConfiguration;
    private final AuditLogger audit;
    private final AuditContext context;
    private final String name;
    private final ConcurrentMap<CachePrincipalPair, SubjectACL> aclCache;

    public AuthorizationHelper(GlobalSecurityConfiguration globalConfiguration, AuditContext context, String name, ConcurrentMap<CachePrincipalPair, SubjectACL> aclCache) {
        this.globalConfiguration = globalConfiguration;
        this.audit = globalConfiguration.authorization().auditLogger();
        this.context = context;
        this.name = name;
        this.aclCache = aclCache;
    }

    public AuthorizationHelper(GlobalSecurityConfiguration security, AuditContext context, String name) {
        this(security, context, name, CollectionFactory.makeBoundedConcurrentMap((int)10));
    }

    public void checkPermission(AuthorizationPermission perm) {
        this.checkPermission(null, perm, null);
    }

    public void checkPermission(AuthorizationPermission perm, String role) {
        this.checkPermission(null, perm, role);
    }

    public void checkPermission(AuthorizationConfiguration configuration, AuthorizationPermission perm) {
        this.checkPermission(configuration, perm, null);
    }

    public void checkPermission(AuthorizationConfiguration configuration, AuthorizationPermission perm, String role) {
        if (this.globalConfiguration.authorization().enabled()) {
            if (Security.isPrivileged()) {
                Security.checkPermission(perm.getSecurityPermission());
            } else {
                Subject subject = Security.getSubject();
                try {
                    if (subject != null) {
                        if (this.checkSubjectPermissionAndRole(subject, configuration, perm, role)) {
                            this.audit.audit(subject, this.context, this.name, perm, AuditResponse.ALLOW);
                        } else {
                            this.checkSecurityManagerPermission(perm);
                        }
                    } else {
                        this.checkSecurityManagerPermission(perm);
                    }
                }
                catch (SecurityException e) {
                    this.audit.audit(subject, this.context, this.name, perm, AuditResponse.DENY);
                    throw log.unauthorizedAccess(Util.prettyPrintSubject((Subject)subject), perm.toString());
                }
            }
        }
    }

    private void checkSecurityManagerPermission(AuthorizationPermission perm) {
        if (System.getSecurityManager() == null) {
            throw new AccessControlException("", perm.getSecurityPermission());
        }
        System.getSecurityManager().checkPermission(perm.getSecurityPermission());
    }

    private boolean checkSubjectPermissionAndRole(Subject subject, AuthorizationConfiguration configuration, AuthorizationPermission requiredPermission, String requestedRole) {
        Principal userPrincipal = this.getUserPrincipal(subject);
        if (userPrincipal != null) {
            boolean authorized;
            CachePrincipalPair cpp = new CachePrincipalPair(userPrincipal, this.name);
            SubjectACL subjectACL = this.aclCache != null ? this.aclCache.computeIfAbsent(cpp, s -> this.computeSubjectACL(subject, configuration)) : this.computeSubjectACL(subject, configuration);
            int permissionMask = requiredPermission.getMask();
            boolean bl = authorized = subjectACL.matches(permissionMask) && (requestedRole == null || subjectACL.containsRole(requestedRole));
            if (trace) {
                log.tracef("Check subject '%s' with ACL '%s' has permission '%s' and role '%s' = %b", new Object[]{subject, subjectACL, requiredPermission, requestedRole, authorized});
            }
            return authorized;
        }
        return false;
    }

    private SubjectACL computeSubjectACL(Subject subject, AuthorizationConfiguration configuration) {
        PrincipalRoleMapper roleMapper = this.globalConfiguration.authorization().principalRoleMapper();
        Set<Principal> principals = subject.getPrincipals();
        HashSet<String> allRoles = new HashSet<String>(principals.size());
        for (Principal principal : principals) {
            Set<String> roleNames = roleMapper.principalToRoles(principal);
            if (roleNames == null) continue;
            allRoles.addAll(roleNames);
        }
        int subjectMask = 0;
        Map<String, Role> globalRoles = this.globalConfiguration.authorization().roles();
        for (String role : allRoles) {
            Role globalRole;
            if (configuration != null && !configuration.roles().contains(role) || (globalRole = globalRoles.get(role)) == null) continue;
            subjectMask |= globalRole.getMask();
        }
        if (trace) {
            log.tracef("Subject '%s' has roles '%s' and permission mask %d", subject, allRoles, subjectMask);
        }
        return new SubjectACL(allRoles, subjectMask);
    }

    private Principal getUserPrincipal(Subject subject) {
        Set<Principal> principals;
        if (subject != null && (principals = subject.getPrincipals()) != null && !principals.isEmpty()) {
            for (Principal p : principals) {
                if (p instanceof Group) continue;
                return p;
            }
        }
        return null;
    }
}

