/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stats.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.CacheException;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.jmx.JmxStatisticsExposer;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.DisplayType;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.Units;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;

public abstract class AbstractClusterStats
implements JmxStatisticsExposer {
    public static final long DEFAULT_STALE_STATS_THRESHOLD = 3000L;
    private TimeService timeService;
    private volatile long staleStatsThreshold = 3000L;
    private volatile long statsUpdateTimestamp = 0L;
    volatile boolean statisticsEnabled = false;
    private final Log log;
    private final AtomicLong resetNanoseconds = new AtomicLong(0L);
    final HashMap<String, Number> statsMap = new HashMap();

    AbstractClusterStats(Log log) {
        this.log = log;
    }

    abstract void updateStats() throws Exception;

    @Inject
    void init(TimeService timeService) {
        this.timeService = timeService;
    }

    @Start
    void start() {
        this.setStatisticsEnabled(this.statisticsEnabled);
    }

    public void reset() {
        this.statsMap.clear();
    }

    @ManagedAttribute(description="Gets the threshold for cluster wide stats refresh (milliseconds)", displayName="Stale Stats Threshold", dataType=DataType.TRAIT, writable=true)
    public long getStaleStatsThreshold() {
        return this.staleStatsThreshold;
    }

    public void setStaleStatsThreshold(long staleStatsThreshold) {
        this.staleStatsThreshold = staleStatsThreshold;
    }

    @Override
    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        if (this.isStatisticsEnabled()) {
            this.reset();
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @ManagedAttribute(description="Number of seconds since the cluster-wide statistics were last reset", displayName="Seconds since cluster-wide statistics were reset", units=Units.SECONDS, displayType=DisplayType.SUMMARY)
    public long getTimeSinceReset() {
        long result = -1L;
        if (this.isStatisticsEnabled()) {
            result = this.timeService.timeDuration(this.resetNanoseconds.get(), TimeUnit.SECONDS);
        }
        return result;
    }

    @Override
    public void setStatisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
        if (enabled) {
            this.resetNanoseconds.set(this.timeService.time());
        }
    }

    @Override
    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", dataType=DataType.TRAIT, writable=true)
    public boolean isStatisticsEnabled() {
        return this.getStatisticsEnabled();
    }

    synchronized void fetchClusterWideStatsIfNeeded() {
        long duration = this.timeService.timeDuration(this.statsUpdateTimestamp, this.timeService.time(), TimeUnit.MILLISECONDS);
        if (duration > 3000L) {
            try {
                this.updateStats();
            }
            catch (Exception e) {
                this.log.error("Could not execute cluster wide cache stats operation ", e);
                throw new CacheException("Could not execute cluster wide cache stats operation", (Throwable)e);
            }
            finally {
                this.statsUpdateTimestamp = this.timeService.time();
            }
        }
    }

    long addLongAttributes(List<Map<String, Number>> responseList, String attribute) {
        long total = 0L;
        for (Map<String, Number> m : responseList) {
            Number value = m.get(attribute);
            long longValue = value.longValue();
            if (longValue <= -1L) continue;
            total += longValue;
        }
        return total;
    }

    double addDoubleAttributes(List<Map<String, Number>> responseList, String attribute) {
        double total = 0.0;
        for (Map<String, Number> m : responseList) {
            Number value = m.get(attribute);
            double doubleValue = value.doubleValue();
            if (!(doubleValue > -1.0)) continue;
            total += doubleValue;
        }
        return total;
    }

    int addIntAttributes(List<Map<String, Number>> responseList, String attribute) {
        int total = 0;
        for (Map<String, Number> m : responseList) {
            Number value = m.get(attribute);
            long intValue = value.intValue();
            if (intValue <= -1L) continue;
            total = (int)((long)total + intValue);
        }
        return total;
    }

    void putLongAttributesAverage(List<Map<String, Number>> responseList, String attribute) {
        long average = this.addLongAttributes(responseList, attribute) / (long)responseList.size();
        this.statsMap.put(attribute, average);
    }

    void putLongAttributes(List<Map<String, Number>> responseList, String attribute) {
        this.statsMap.put(attribute, this.addLongAttributes(responseList, attribute));
    }

    void putIntAttributes(List<Map<String, Number>> responseList, String attribute) {
        this.statsMap.put(attribute, this.addIntAttributes(responseList, attribute));
    }

    long getStatAsLong(String attribute) {
        return this.getStat(attribute).longValue();
    }

    int getStatAsInt(String attribute) {
        return this.getStat(attribute).intValue();
    }

    private Number getStat(String attribute) {
        if (this.isStatisticsEnabled()) {
            this.fetchClusterWideStatsIfNeeded();
            return this.statsMap.getOrDefault(attribute, 0);
        }
        return -1;
    }
}

