/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.jgroups.subsystem;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.server.commons.service.Builder;
import org.infinispan.server.commons.service.InjectedValueDependency;
import org.infinispan.server.commons.service.ServiceNameProvider;
import org.infinispan.server.commons.service.ValueDependency;
import org.infinispan.server.jgroups.ForkChannelFactory;
import org.infinispan.server.jgroups.spi.ChannelFactory;
import org.infinispan.server.jgroups.spi.ProtocolConfiguration;
import org.infinispan.server.jgroups.spi.service.ChannelServiceName;
import org.infinispan.server.jgroups.spi.service.ProtocolStackServiceName;
import org.infinispan.server.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ValueService;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;
import org.jgroups.JChannel;

public class ForkChannelFactoryBuilder
implements Builder<ChannelFactory>,
Value<ChannelFactory> {
    private final String channelName;
    private final InjectedValue<JChannel> parentChannel = new InjectedValue();
    private final InjectedValue<ChannelFactory> parentFactory = new InjectedValue();
    private final List<ValueDependency<ProtocolConfiguration>> protocols = new LinkedList<ValueDependency<ProtocolConfiguration>>();

    public ForkChannelFactoryBuilder(String channelName) {
        this.channelName = channelName;
    }

    public ServiceName getServiceName() {
        return ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(this.channelName);
    }

    public ServiceBuilder<ChannelFactory> build(ServiceTarget target) {
        return target.addService(this.getServiceName(), (Service)new ValueService((Value)this)).addDependency(ChannelServiceName.CONNECTOR.getServiceName(this.channelName), JChannel.class, this.parentChannel).addDependency(ChannelServiceName.FACTORY.getServiceName(this.channelName), ChannelFactory.class, this.parentFactory).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public ChannelFactory getValue() {
        ArrayList<ProtocolConfiguration> protocols = new ArrayList<ProtocolConfiguration>(this.protocols.size());
        for (Value value : this.protocols) {
            protocols.add((ProtocolConfiguration)value.getValue());
        }
        return new ForkChannelFactory((JChannel)this.parentChannel.getValue(), (ChannelFactory)this.parentFactory.getValue(), protocols);
    }

    public ProtocolConfigurationBuilder addProtocol(String type) {
        ProtocolConfigurationBuilder builder = new ProtocolConfigurationBuilder(this.channelName, type);
        this.protocols.add((ValueDependency<ProtocolConfiguration>)new InjectedValueDependency((ServiceNameProvider)builder, ProtocolConfiguration.class));
        return builder;
    }
}

