/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.TP;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.GossipData;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.RouterStub;
import org.jgroups.stack.RouterStubManager;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.NameCache;
import org.jgroups.util.Util;

@Experimental
public class TUNNEL
extends TP
implements RouterStub.StubReceiver {
    @Property(description="Interval in msec to attempt connecting back to router in case of torn connection. Default is 5000 msec")
    protected long reconnect_interval = 5000L;
    @Property(description="Should TCP no delay flag be turned on")
    protected boolean tcp_nodelay = false;
    @Property(description="Whether to use blocking (false) or non-blocking (true) connections. If GossipRouter is used, this needs to be false; if GossipRouterNio is used, it needs to be true")
    protected boolean use_nio;
    protected final List<InetSocketAddress> gossip_router_hosts = new ArrayList<InetSocketAddress>();
    protected TUNNELPolicy tunnel_policy = new DefaultTUNNELPolicy();
    protected DatagramSocket sock;
    protected volatile RouterStubManager stubManager;

    @Override
    public boolean supportsMulticasting() {
        return true;
    }

    @Property(description="A comma-separated list of GossipRouter hosts, e.g. HostA[12001],HostB[12001]")
    public void setGossipRouterHosts(String hosts) throws UnknownHostException {
        this.gossip_router_hosts.clear();
        if (hosts.startsWith("[") && hosts.endsWith("]")) {
            hosts = hosts.substring(1, hosts.length() - 1);
        }
        this.gossip_router_hosts.addAll(Util.parseCommaDelimitedHosts2(hosts, 1));
    }

    @ManagedOperation(description="Prints all stubs and the reconnect list")
    public String print() {
        RouterStubManager mgr = this.stubManager;
        return mgr != null ? mgr.print() : "n/a";
    }

    @ManagedOperation(description="Prints all currently connected stubs")
    public String printStubs() {
        RouterStubManager mgr = this.stubManager;
        return mgr != null ? mgr.printStubs() : "n/a";
    }

    @ManagedOperation(description="Prints the reconnect list")
    public String printReconnectList() {
        RouterStubManager mgr = this.stubManager;
        return mgr != null ? mgr.printReconnectList() : "n/a";
    }

    public RouterStubManager getStubManager() {
        return this.stubManager;
    }

    @Override
    public String toString() {
        return "TUNNEL";
    }

    public long getReconnectInterval() {
        return this.reconnect_interval;
    }

    public void setReconnectInterval(long reconnect_interval) {
        this.reconnect_interval = reconnect_interval;
    }

    public synchronized void setTUNNELPolicy(TUNNELPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("Tunnel policy has to be non null");
        }
        this.tunnel_policy = policy;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.timer == null) {
            throw new Exception("timer cannot be retrieved from protocol stack");
        }
        if (this.gossip_router_hosts.isEmpty()) {
            throw new IllegalStateException("gossip_router_hosts needs to contain at least one address of a GossipRouter");
        }
        this.log.debug("GossipRouters are:" + this.gossip_router_hosts.toString());
        this.stubManager = RouterStubManager.emptyGossipClientStubManager(this).useNio(this.use_nio);
        this.sock = this.getSocketFactory().createDatagramSocket("jgroups.tunnel.ucast_sock", this.bind_port, this.bind_addr);
    }

    @Override
    public void destroy() {
        this.stubManager.destroyStubs();
        super.destroy();
    }

    private void disconnectStub() {
        this.stubManager.disconnectStubs();
    }

    @Override
    public Object handleDownEvent(Event evt) {
        Object retEvent = super.handleDownEvent(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                String group = (String)evt.getArg();
                Address local = this.local_addr;
                if (this.stubManager != null) {
                    this.stubManager.destroyStubs();
                }
                PhysicalAddress physical_addr = this.getPhysicalAddressFromCache(local);
                String logical_name = NameCache.get(local);
                this.stubManager = new RouterStubManager(this, group, local, logical_name, physical_addr, this.getReconnectInterval()).useNio(this.use_nio);
                for (InetSocketAddress gr : this.gossip_router_hosts) {
                    this.stubManager.createAndRegisterStub(new IpAddress(this.bind_addr, this.bind_port), new IpAddress(gr.getAddress(), gr.getPort())).receiver(this).set("tcp_nodelay", this.tcp_nodelay);
                }
                this.stubManager.connectStubs();
                break;
            }
            case 4: {
                this.disconnectStub();
            }
        }
        return retEvent;
    }

    @Override
    public void receive(GossipData data) {
        switch (data.getType()) {
            case MESSAGE: {
                byte[] msg = data.getBuffer();
                if (Objects.equals(this.local_addr, data.getSender())) {
                    return;
                }
                this.receive(data.getSender(), msg, 0, msg.length);
                break;
            }
            case SUSPECT: {
                Address suspect = data.getAddress();
                if (suspect == null) break;
                this.log.debug("%s: firing suspect event for %s", this.local_addr, suspect);
                this.up(new Event(9, suspect));
            }
        }
    }

    @Override
    protected void send(Message msg, Address dest) throws Exception {
        TpHeader hdr = (TpHeader)msg.getHeader(this.id);
        if (hdr == null) {
            throw new Exception("message " + msg + " doesn't have a transport header, cannot route it");
        }
        String group = this.cluster_name != null ? this.cluster_name.toString() : null;
        ByteArrayDataOutputStream dos = new ByteArrayDataOutputStream((int)(msg.size() + 50L));
        Util.writeMessage(msg, dos, dest == null);
        if (this.stats) {
            this.msg_stats.incrNumMsgsSent(1);
            this.msg_stats.incrNumBytesSent(dos.position());
        }
        if (dest == null) {
            this.tunnel_policy.sendToAllMembers(group, this.local_addr, dos.buffer(), 0, dos.position());
        } else {
            this.tunnel_policy.sendToSingleMember(group, dest, this.local_addr, dos.buffer(), 0, dos.position());
        }
    }

    @Override
    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        throw new UnsupportedOperationException("sendMulticast() should not get called on TUNNEL");
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        throw new UnsupportedOperationException("sendUnicast() should not get called on TUNNEL");
    }

    @Override
    public String getInfo() {
        return this.stubManager.printStubs();
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.sock != null ? new IpAddress(this.bind_addr, this.sock.getLocalPort()) : null;
    }

    private class DefaultTUNNELPolicy
    implements TUNNELPolicy {
        private DefaultTUNNELPolicy() {
        }

        @Override
        public void sendToAllMembers(String group, Address sender, byte[] data, int offset, int length) throws Exception {
            TUNNEL.this.stubManager.forAny(stub -> {
                try {
                    if (TUNNEL.this.log.isTraceEnabled()) {
                        TUNNEL.this.log.trace("sent a message to all members, GR used %s", stub.gossipRouterAddress());
                    }
                    stub.sendToAllMembers(group, sender, data, offset, length);
                }
                catch (Exception ex) {
                    TUNNEL.this.log.warn("failed sending a message to all members, router used %s", stub.gossipRouterAddress());
                }
            });
        }

        @Override
        public void sendToSingleMember(String group, Address dest, Address sender, byte[] data, int offset, int length) throws Exception {
            TUNNEL.this.stubManager.forAny(stub -> {
                try {
                    if (TUNNEL.this.log.isTraceEnabled()) {
                        TUNNEL.this.log.trace("sent a message to all members, GR used %s", stub.gossipRouterAddress());
                    }
                    stub.sendToMember(group, dest, sender, data, offset, length);
                }
                catch (Exception ex) {
                    TUNNEL.this.log.warn("failed sending a message to all members, router used %s", stub.gossipRouterAddress());
                }
            });
        }
    }

    public static interface TUNNELPolicy {
        public void sendToAllMembers(String var1, Address var2, byte[] var3, int var4, int var5) throws Exception;

        public void sendToSingleMember(String var1, Address var2, Address var3, byte[] var4, int var5, int var6) throws Exception;
    }
}

