/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.memcached;

import java.io.IOException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.compat.TypeConverter;
import org.infinispan.context.Flag;

public class MemcachedTypeConverter
implements TypeConverter<String, Object, String, Object> {
    private Marshaller marshaller = new JavaSerializationMarshaller();

    public String boxKey(String key) {
        return key;
    }

    public Object boxValue(Object value) {
        return this.unmarshall(value);
    }

    public String unboxKey(String target) {
        return target;
    }

    public Object unboxValue(Object target) {
        return this.marshall(target);
    }

    public boolean supportsInvocation(Flag flag) {
        return flag == Flag.OPERATION_MEMCACHED;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    private Object unmarshall(Object source) {
        if (source instanceof byte[]) {
            try {
                return this.marshaller.objectFromByteBuffer((byte[])source);
            }
            catch (IOException | ClassNotFoundException e) {
                throw new CacheException((Throwable)e);
            }
        }
        return source;
    }

    private byte[] marshall(Object source) {
        if (source != null) {
            try {
                return this.marshaller.objectToByteBuffer(source);
            }
            catch (IOException | InterruptedException e) {
                throw new CacheException((Throwable)e);
            }
        }
        return null;
    }
}

