/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.filter.FullTextFilter;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.FacetManager;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.SearchIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.EagerIterator;
import org.infinispan.query.impl.EntityLoader;
import org.infinispan.query.impl.LazyIterator;
import org.infinispan.query.impl.NullFilteringResultIterator;
import org.infinispan.query.impl.ProjectionConverter;
import org.infinispan.query.impl.ProjectionLoader;
import org.infinispan.query.impl.QueryResultLoader;

public class CacheQueryImpl<E>
implements CacheQuery<E> {
    private static final FetchOptions DEFAULT_FETCH_OPTIONS = new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER);
    protected final AdvancedCache<?, ?> cache;
    protected final KeyTransformationHandler keyTransformationHandler;
    protected HSQuery hSearchQuery;
    private ProjectionConverter projectionConverter;

    public CacheQueryImpl(Query luceneQuery, SearchIntegrator searchFactory, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler, TimeoutExceptionFactory timeoutExceptionFactory, Class<?> ... classes) {
        this(timeoutExceptionFactory == null ? searchFactory.createHSQuery(luceneQuery, (Class[])classes) : searchFactory.createHSQuery(luceneQuery, (Class[])classes).timeoutExceptionFactory(timeoutExceptionFactory), cache, keyTransformationHandler);
    }

    public CacheQueryImpl(HSQuery hSearchQuery, AdvancedCache<?, ?> cache, KeyTransformationHandler keyTransformationHandler) {
        this.hSearchQuery = hSearchQuery;
        this.cache = cache;
        this.keyTransformationHandler = keyTransformationHandler;
    }

    @Override
    public CacheQuery<E> filter(Filter filter) {
        this.hSearchQuery.filter(filter);
        return this;
    }

    @Override
    public int getResultSize() {
        return this.hSearchQuery.queryResultSize();
    }

    @Override
    public CacheQuery<E> sort(Sort sort) {
        this.hSearchQuery.sort(sort);
        return this;
    }

    @Override
    public FullTextFilter enableFullTextFilter(String name) {
        return this.hSearchQuery.enableFullTextFilter(name);
    }

    @Override
    public CacheQuery<E> disableFullTextFilter(String name) {
        this.hSearchQuery.disableFullTextFilter(name);
        return this;
    }

    @Override
    public CacheQuery<E> firstResult(int firstResult) {
        this.hSearchQuery.firstResult(firstResult);
        return this;
    }

    @Override
    public CacheQuery<E> maxResults(int maxResults) {
        this.hSearchQuery.maxResults(maxResults);
        return this;
    }

    @Override
    public ResultIterator<E> iterator() throws SearchException {
        return this.iterator(DEFAULT_FETCH_OPTIONS);
    }

    @Override
    public ResultIterator<E> iterator(FetchOptions fetchOptions) throws SearchException {
        if (fetchOptions.getFetchMode() == FetchOptions.FetchMode.EAGER) {
            this.hSearchQuery.getTimeoutManager().start();
            List entityInfos = this.hSearchQuery.queryEntityInfos();
            return this.filterNulls(new EagerIterator(entityInfos, this.getResultLoader(), fetchOptions.getFetchSize()));
        }
        if (fetchOptions.getFetchMode() == FetchOptions.FetchMode.LAZY) {
            DocumentExtractor extractor = this.hSearchQuery.queryDocumentExtractor();
            return this.filterNulls(new LazyIterator(extractor, this.getResultLoader(), fetchOptions.getFetchSize()));
        }
        throw new IllegalArgumentException("Unknown FetchMode " + (Object)((Object)fetchOptions.getFetchMode()));
    }

    private ResultIterator<E> filterNulls(ResultIterator<E> iterator) {
        return new NullFilteringResultIterator<E>(iterator);
    }

    @Override
    public List<E> list() throws SearchException {
        this.hSearchQuery.getTimeoutManager().start();
        List entityInfos = this.hSearchQuery.queryEntityInfos();
        return this.getResultLoader().load(entityInfos);
    }

    private QueryResultLoader getResultLoader() {
        return this.isProjected() ? this.getProjectionLoader() : this.getEntityLoader();
    }

    private boolean isProjected() {
        return this.hSearchQuery.getProjectedFields() != null;
    }

    private ProjectionLoader getProjectionLoader() {
        return new ProjectionLoader(this.projectionConverter, this.getEntityLoader());
    }

    private EntityLoader getEntityLoader() {
        return new EntityLoader(this.cache, this.keyTransformationHandler);
    }

    @Override
    public FacetManager getFacetManager() {
        return this.hSearchQuery.getFacetManager();
    }

    @Override
    public Explanation explain(int documentId) {
        return this.hSearchQuery.explain(documentId);
    }

    @Override
    public CacheQuery<Object[]> projection(String ... fields) {
        this.projectionConverter = new ProjectionConverter(fields, this.cache, this.keyTransformationHandler);
        this.hSearchQuery.projection(this.projectionConverter.getHSearchProjection());
        return this;
    }

    @Override
    public CacheQuery<E> timeout(long timeout, TimeUnit timeUnit) {
        this.hSearchQuery.getTimeoutManager().setTimeout(timeout, timeUnit);
        return this;
    }
}

