/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.query.Transformer;

public class DefaultTransformer
implements Transformer {
    private static final Log log = LogFactory.getLog(DefaultTransformer.class);

    @Override
    public Object fromString(String encodedObject) {
        byte[] objBytes = Base64.getDecoder().decode(encodedObject);
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(objBytes));
            return ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            log.error((Object)"Error while decoding object", (Throwable)e);
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public String toString(Object customType) {
        if (customType instanceof Serializable) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(Base64.getEncoder().wrap(baos));
                oos.writeObject(customType);
                oos.close();
                byte[] base64encoded = baos.toByteArray();
                try {
                    return new String(base64encoded, "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    return new String(base64encoded);
                }
            }
            catch (IOException e) {
                log.error((Object)"Error while encoding object", (Throwable)e);
                throw new CacheException((Throwable)e);
            }
        }
        throw new IllegalArgumentException("Expected " + customType.getClass() + " to be Serializable!");
    }
}

