/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.lucene.ExternalizerIds;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.KeyVisitor;

public final class FileReadLockKey
implements IndexScopedKey {
    private final String indexName;
    private final String fileName;
    private final int hashCode;
    private final int affinitySegmentId;

    public FileReadLockKey(String indexName, String fileName, int affinitySegmentId) {
        if (indexName == null) {
            throw new IllegalArgumentException("indexName shall not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName shall not be null");
        }
        this.indexName = indexName;
        this.fileName = fileName;
        this.affinitySegmentId = affinitySegmentId;
        this.hashCode = this.generateHashCode();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public int getAffinitySegmentId() {
        return this.affinitySegmentId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Object accept(KeyVisitor visitor) throws Exception {
        return visitor.visit(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int prime = 31;
        int result = 31 + this.fileName.hashCode();
        return 31 * result + this.indexName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileReadLockKey.class != obj.getClass()) {
            return false;
        }
        FileReadLockKey other = (FileReadLockKey)obj;
        return this.fileName.equals(other.fileName) && this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "RL|" + this.fileName + "|" + this.indexName + "|" + this.affinitySegmentId;
    }

    public static final class Externalizer
    extends AbstractExternalizer<FileReadLockKey> {
        public void writeObject(ObjectOutput output, FileReadLockKey key) throws IOException {
            output.writeUTF(key.indexName);
            output.writeUTF(key.fileName);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)key.affinitySegmentId);
        }

        public FileReadLockKey readObject(ObjectInput input) throws IOException {
            String indexName = input.readUTF();
            String fileName = input.readUTF();
            int affinitySegmentId = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            return new FileReadLockKey(indexName, fileName, affinitySegmentId);
        }

        public Integer getId() {
            return ExternalizerIds.FILE_READLOCK_KEY;
        }

        public Set<Class<? extends FileReadLockKey>> getTypeClasses() {
            return Collections.singleton(FileReadLockKey.class);
        }
    }
}

