/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.accesscontrol.AccessRequirementBuilder;
import org.jboss.as.cli.accesscontrol.PerNodeOperationAccess;
import org.jboss.as.cli.embedded.EmbeddedProcessLaunch;
import org.jboss.as.cli.handlers.BaseOperationCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.CLIModelControllerClient;
import org.jboss.as.cli.impl.CommaSeparatedCompleter;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class ShutdownHandler
extends BaseOperationCommand {
    private final ArgumentWithValue restart;
    private final ArgumentWithValue host;
    private final ArgumentWithValue timeout;
    private final AtomicReference<EmbeddedProcessLaunch> embeddedServerRef;
    private PerNodeOperationAccess hostShutdownPermission;

    public ShutdownHandler(CommandContext ctx, AtomicReference<EmbeddedProcessLaunch> embeddedServerRef) {
        super(ctx, "shutdown", true);
        this.embeddedServerRef = embeddedServerRef;
        this.restart = new ArgumentWithValue((CommandHandlerWithArguments)this, SimpleTabCompleter.BOOLEAN, "--restart");
        this.timeout = new ArgumentWithValue(this, "--timeout");
        this.host = new ArgumentWithValue(this, new CommaSeparatedCompleter(){

            @Override
            protected Collection<String> getAllCandidates(CommandContext ctx) {
                return ShutdownHandler.this.hostShutdownPermission.getAllowedOn(ctx);
            }
        }, "--host"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (!ctx.isDomainMode()) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
    }

    @Override
    protected AccessRequirement setupAccessRequirement(CommandContext ctx) {
        this.hostShutdownPermission = new PerNodeOperationAccess(ctx, "host", null, "shutdown");
        return AccessRequirementBuilder.Factory.create(ctx).any().operation("shutdown").requirement(this.hostShutdownPermission).build();
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return super.isAvailable(ctx) && (this.embeddedServerRef == null || this.embeddedServerRef.get() == null);
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        boolean disconnect;
        CLIModelControllerClient cliClient;
        block13: {
            ModelControllerClient client = ctx.getModelControllerClient();
            if (client == null) {
                throw new CommandLineException("Connection is not available.");
            }
            if (this.embeddedServerRef != null && this.embeddedServerRef.get() != null) {
                this.embeddedServerRef.get().stop();
                return;
            }
            if (!(client instanceof CLIModelControllerClient)) {
                throw new CommandLineException("Unsupported ModelControllerClient implementation " + client.getClass().getName());
            }
            cliClient = (CLIModelControllerClient)client;
            ModelNode op = this.buildRequestWithoutHeaders(ctx);
            disconnect = true;
            String restartValue = this.restart.getValue(ctx.getParsedCommandLine());
            if ("true".equals(restartValue) || ctx.isDomainMode() && !this.isLocalHost(ctx.getModelControllerClient(), this.host.getValue(ctx.getParsedCommandLine()))) {
                disconnect = false;
            }
            try {
                ModelNode response = cliClient.execute(op, true);
                if (!Util.isSuccess(response)) {
                    throw new CommandLineException(Util.getFailureDescription(response));
                }
            }
            catch (IOException e) {
                if (!cliClient.isConnected()) break block13;
                StreamUtils.safeClose(cliClient);
                throw new CommandLineException("Failed to execute :shutdown", e);
            }
        }
        if (disconnect) {
            ctx.disconnectController();
        } else {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new CommandLineException("Interrupted while pausing before reconnecting.", e);
            }
            try {
                cliClient.ensureConnected(ctx.getConfig().getConnectionTimeout() + 1000);
            }
            catch (CommandLineException e) {
                ctx.disconnectController();
                throw e;
            }
        }
    }

    @Override
    protected ModelNode buildRequestWithoutHeaders(CommandContext ctx) throws CommandFormatException {
        ModelNode op = new ModelNode();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (ctx.isDomainMode()) {
            String hostName = this.host.getValue(args);
            if (hostName == null) {
                throw new CommandFormatException("Missing required argument " + this.host.getFullName());
            }
            op.get("address").add("host", hostName);
        } else {
            if (this.host.isPresent(args)) {
                throw new CommandFormatException(this.host.getFullName() + " is not allowed in the standalone mode.");
            }
            op.get("address").setEmptyList();
        }
        op.get("operation").set("shutdown");
        this.setBooleanArgument(args, op, this.restart, "restart");
        this.setIntArgument(args, op, this.timeout, "timeout");
        return op;
    }

    protected boolean isLocalHost(ModelControllerClient client, String host) throws CommandLineException {
        ModelNode response;
        ModelNode request = new ModelNode();
        request.get("address").setEmptyList();
        request.get("operation").set("read-attribute");
        request.get("name").set("local-host-name");
        try {
            response = client.execute(request);
        }
        catch (IOException e) {
            throw new CommandLineException("Failed to read attribute local-host-name", e);
        }
        if (!Util.isSuccess(response)) {
            throw new CommandLineException("Failed to read attribute local-host-name: " + Util.getFailureDescription(response));
        }
        ModelNode result = response.get("result");
        if (!result.isDefined()) {
            throw new CommandLineException("The result is not defined for attribute local-host-name: " + result);
        }
        return result.asString().equals(host);
    }

    protected void setBooleanArgument(ParsedCommandLine args, ModelNode op, ArgumentWithValue arg, String paramName) throws CommandFormatException {
        if (!arg.isPresent(args)) {
            return;
        }
        String value = arg.getValue(args);
        if (value == null) {
            throw new CommandFormatException(arg.getFullName() + " is missing value.");
        }
        if (value.equalsIgnoreCase("true")) {
            op.get(paramName).set(true);
        } else if (value.equalsIgnoreCase("false")) {
            op.get(paramName).set(false);
        } else {
            throw new CommandFormatException("Invalid value for " + arg.getFullName() + ": '" + value + "'");
        }
    }

    private void setIntArgument(ParsedCommandLine args, ModelNode op, ArgumentWithValue arg, String paramName) throws CommandFormatException {
        if (!arg.isPresent(args)) {
            return;
        }
        String value = arg.getValue(args);
        if (value == null) {
            throw new CommandFormatException(arg.getFullName() + " is missing value.");
        }
        try {
            Integer i = Integer.parseInt(value);
            op.get(paramName).set(i);
        }
        catch (NumberFormatException nfe) {
            throw new CommandFormatException("Invalid value for " + arg.getFullName() + ": '" + value + "'");
        }
    }
}

