/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.bridge.builtin.time.impl;

import java.time.DateTimeException;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import java.util.Locale;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchLocalTimeBridge;
import org.hibernate.search.elasticsearch.bridge.builtin.time.impl.ElasticsearchTemporalAccessorStringBridge;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchOffsetTimeBridge
extends ElasticsearchTemporalAccessorStringBridge<OffsetTime> {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final DateTimeFormatter FORMATTER = new DateTimeFormatterBuilder().append(ElasticsearchLocalTimeBridge.FORMATTER).appendOffsetId().toFormatter(Locale.ROOT).withResolverStyle(ResolverStyle.STRICT);
    public static final ElasticsearchOffsetTimeBridge INSTANCE = new ElasticsearchOffsetTimeBridge();

    private ElasticsearchOffsetTimeBridge() {
        super(FORMATTER, OffsetTime.class);
    }

    @Override
    OffsetTime parse(DateTimeFormatter formatter, String stringValue) throws DateTimeException {
        return OffsetTime.parse(stringValue, formatter);
    }

    @Override
    protected IllegalArgumentException createInvalidIndexNullAsException(String indexNullAs, DateTimeException e) {
        return LOG.invalidNullMarkerForOffsetTime(e);
    }
}

