/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import io.searchbox.client.JestResult;
import java.util.Collections;
import java.util.Set;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.client.impl.ExecutableRequest;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.ErrorContextBuilder;

public class SingleRequest
implements ExecutableRequest {
    private final JestClient jestClient;
    private final ErrorHandler errorHandler;
    private final BackendRequest<?> request;

    public SingleRequest(JestClient jestClient, ErrorHandler errorHandler, BackendRequest<?> request) {
        this.jestClient = jestClient;
        this.errorHandler = errorHandler;
        this.request = request;
    }

    @Override
    public void execute() {
        this.doExecute(this.request);
    }

    private <T extends JestResult> void doExecute(BackendRequest<T> request) {
        try {
            T result = this.jestClient.executeRequest(request.getAction(), request.getResultAssessor());
            IndexingMonitor monitor = request.getIndexingMonitor();
            if (monitor != null) {
                request.getSuccessReporter().report(result, monitor);
            }
        }
        catch (Exception e) {
            ErrorContextBuilder builder = new ErrorContextBuilder();
            builder.allWorkToBeDone(Collections.singletonList(request.getLuceneWork()));
            builder.addWorkThatFailed(request.getLuceneWork());
            builder.errorThatOccurred((Throwable)e);
            this.errorHandler.handle(builder.createErrorContext());
        }
    }

    @Override
    public Set<String> getTouchedIndexes() {
        return Collections.singleton(this.request.getIndexName());
    }

    @Override
    public Set<String> getIndexesNeedingRefresh() {
        return this.request.needsRefreshAfterWrite() ? Collections.singleton(this.request.getIndexName()) : Collections.emptySet();
    }

    @Override
    public int getSize() {
        return 1;
    }
}

